/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.proxy;

import WayofTime.bloodmagic.client.helper.ShaderHelper;
import WayofTime.bloodmagic.client.hud.Elements;
import WayofTime.bloodmagic.client.key.KeyBindings;
import WayofTime.bloodmagic.client.render.LayerBloodElytra;
import WayofTime.bloodmagic.client.render.block.RenderAlchemyArray;
import WayofTime.bloodmagic.client.render.block.RenderAltar;
import WayofTime.bloodmagic.client.render.block.RenderBloodTank;
import WayofTime.bloodmagic.client.render.block.RenderDemonCrucible;
import WayofTime.bloodmagic.client.render.block.RenderItemRoutingNode;
import WayofTime.bloodmagic.client.render.block.RenderMimic;
import WayofTime.bloodmagic.client.render.entity.BloodLightRenderFactory;
import WayofTime.bloodmagic.client.render.entity.CorruptedChickenRenderFactory;
import WayofTime.bloodmagic.client.render.entity.CorruptedSheepRenderFactory;
import WayofTime.bloodmagic.client.render.entity.CorruptedSpiderRenderFactory;
import WayofTime.bloodmagic.client.render.entity.CorruptedZombieRenderFactory;
import WayofTime.bloodmagic.client.render.entity.MeteorRenderFactory;
import WayofTime.bloodmagic.client.render.entity.MimicRenderFactory;
import WayofTime.bloodmagic.client.render.entity.SentientArrowRenderFactory;
import WayofTime.bloodmagic.client.render.entity.SentientSpecterRenderFactory;
import WayofTime.bloodmagic.client.render.entity.SoulSnareRenderFactory;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.entity.mob.EntityCorruptedChicken;
import WayofTime.bloodmagic.entity.mob.EntityCorruptedSheep;
import WayofTime.bloodmagic.entity.mob.EntityCorruptedSpider;
import WayofTime.bloodmagic.entity.mob.EntityCorruptedZombie;
import WayofTime.bloodmagic.entity.mob.EntityMimic;
import WayofTime.bloodmagic.entity.mob.EntitySentientSpecter;
import WayofTime.bloodmagic.entity.projectile.EntityBloodLight;
import WayofTime.bloodmagic.entity.projectile.EntityMeteor;
import WayofTime.bloodmagic.entity.projectile.EntitySentientArrow;
import WayofTime.bloodmagic.entity.projectile.EntitySoulSnare;
import WayofTime.bloodmagic.item.types.AlchemicVialType;
import WayofTime.bloodmagic.proxy.CommonProxy;
import WayofTime.bloodmagic.soul.DemonWillHolder;
import WayofTime.bloodmagic.tile.TileAlchemyArray;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.tile.TileBloodTank;
import WayofTime.bloodmagic.tile.TileDemonCrucible;
import WayofTime.bloodmagic.tile.TileInversionPillar;
import WayofTime.bloodmagic.tile.TileMimic;
import WayofTime.bloodmagic.tile.routing.TileRoutingNode;
import WayofTime.bloodmagic.util.BMLog;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.animation.AnimationTESR;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ClientProxy
extends CommonProxy {
    public static DemonWillHolder currentAura = new DemonWillHolder();

    @Override
    public void preInit() {
        super.preInit();
        OBJLoader.INSTANCE.addDomain("bloodmagic");
        ClientRegistry.bindTileEntitySpecialRenderer(TileInversionPillar.class, (TileEntitySpecialRenderer)new AnimationTESR<TileInversionPillar>(){

            public void handleEvents(TileInversionPillar chest, float time, Iterable<Event> pastEvents) {
                chest.handleEvents(time, pastEvents);
            }
        });
        ClientRegistry.bindTileEntitySpecialRenderer(TileAlchemyArray.class, (TileEntitySpecialRenderer)new RenderAlchemyArray());
        ClientRegistry.bindTileEntitySpecialRenderer(TileAltar.class, (TileEntitySpecialRenderer)new RenderAltar());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRoutingNode.class, (TileEntitySpecialRenderer)new RenderItemRoutingNode());
        ClientRegistry.bindTileEntitySpecialRenderer(TileDemonCrucible.class, (TileEntitySpecialRenderer)new RenderDemonCrucible());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMimic.class, (TileEntitySpecialRenderer)new RenderMimic());
        ClientRegistry.bindTileEntitySpecialRenderer(TileBloodTank.class, (TileEntitySpecialRenderer)new RenderBloodTank());
        for (KeyBindings key : KeyBindings.values()) {
            key.getKey();
        }
    }

    @Override
    public void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntitySoulSnare.class, (IRenderFactory)new SoulSnareRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(EntitySentientArrow.class, (IRenderFactory)new SentientArrowRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(EntityBloodLight.class, (IRenderFactory)new BloodLightRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(EntityMeteor.class, (IRenderFactory)new MeteorRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(EntitySentientSpecter.class, (IRenderFactory)new SentientSpecterRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(EntityMimic.class, (IRenderFactory)new MimicRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(EntityCorruptedZombie.class, (IRenderFactory)new CorruptedZombieRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(EntityCorruptedSheep.class, (IRenderFactory)new CorruptedSheepRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(EntityCorruptedChicken.class, (IRenderFactory)new CorruptedChickenRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(EntityCorruptedSpider.class, (IRenderFactory)new CorruptedSpiderRenderFactory());
        ShaderHelper.init();
    }

    @Override
    public void init() {
        super.init();
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
            try {
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("color") && tintIndex == 1) {
                    return Color.decode(stack.func_77978_p().func_74779_i("color")).getRGB();
                }
            }
            catch (NumberFormatException e) {
                return -1;
            }
            return -1;
        }, new Item[]{RegistrarBloodMagicItems.SIGIL_HOLDING});
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
            if (tintIndex != 0 && tintIndex != 2) {
                return -1;
            }
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("empty")) {
                return -1;
            }
            return PotionUtils.func_185181_a((Collection)PotionUtils.func_185189_a((ItemStack)stack));
        }, new Item[]{RegistrarBloodMagicItems.POTION_FLASK});
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
            int variant = stack.func_77960_j();
            return AlchemicVialType.getColourForLayer(variant, tintIndex);
        }, new Item[]{RegistrarBloodMagicItems.ALCHEMIC_VIAL});
        this.addElytraLayer();
    }

    @Override
    public void postInit() {
        Elements.registerElements();
    }

    private void addElytraLayer() {
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        try {
            Map skinMap = (Map)ObfuscationReflectionHelper.getPrivateValue(RenderManager.class, (Object)renderManager, (String[])new String[]{"skinMap", "field_178636_l"});
            ((RenderPlayer)skinMap.get("default")).func_177094_a((LayerRenderer)new LayerBloodElytra((RenderPlayer)skinMap.get("default")));
            ((RenderPlayer)skinMap.get("slim")).func_177094_a((LayerRenderer)new LayerBloodElytra((RenderPlayer)skinMap.get("slim")));
            BMLog.DEBUG.info("Elytra layer added", new Object[0]);
        }
        catch (Exception e) {
            BMLog.DEBUG.error("Failed to set custom Elytra Layer for Elytra Living Armour Upgrade: {}", e.getMessage());
        }
    }

    @Override
    public IAnimationStateMachine load(ResourceLocation location, ImmutableMap<String, ITimeValue> parameters) {
        return ModelLoaderRegistry.loadASM((ResourceLocation)location, parameters);
    }
}

