/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.sigil;

import WayofTime.bloodmagic.item.sigil.ItemSigilBase;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;

public abstract class ItemSigilFluidBase
extends ItemSigilBase {
    public final FluidStack sigilFluid;

    public ItemSigilFluidBase(String name, int lpUsed, FluidStack fluid) {
        super(name, lpUsed);
        this.sigilFluid = fluid;
    }

    public ItemSigilFluidBase(String name, FluidStack fluid) {
        super(name);
        this.sigilFluid = fluid;
    }

    public ItemSigilFluidBase(String name) {
        super(name);
        this.sigilFluid = null;
    }

    @Nullable
    protected IFluidHandler getFluidHandler(World world, BlockPos blockPos, @Nullable EnumFacing side) {
        IFluidHandler handler;
        IBlockState state = world.func_180495_p(blockPos);
        Block block = state.func_177230_c();
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile != null && (handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) != null) {
            return handler;
        }
        if (block instanceof IFluidBlock) {
            return new FluidBlockWrapper((IFluidBlock)block, world, blockPos);
        }
        if (block instanceof BlockLiquid) {
            return new BlockLiquidWrapper((BlockLiquid)block, world, blockPos);
        }
        return null;
    }

    protected boolean tryInsertSigilFluid(IFluidHandler destination, boolean doTransfer) {
        if (destination == null) {
            return false;
        }
        return destination.fill(this.sigilFluid, doTransfer) > 0;
    }

    protected boolean tryRemoveFluid(IFluidHandler source, int amount, boolean doTransfer) {
        if (source == null) {
            return false;
        }
        return source.drain(amount, doTransfer) != null;
    }

    protected boolean tryPlaceSigilFluid(EntityPlayer player, World world, BlockPos blockPos) {
        if (world == null || blockPos == null) {
            return false;
        }
        Fluid fluid = this.sigilFluid.getFluid();
        if (!fluid.canBePlacedInWorld()) {
            return false;
        }
        IBlockState state = world.func_180495_p(blockPos);
        Material mat = state.func_185904_a();
        boolean isDestSolid = mat.func_76220_a();
        boolean isDestReplaceable = state.func_177230_c().func_176200_f((IBlockAccess)world, blockPos);
        if (!world.func_175623_d(blockPos) && isDestSolid && !isDestReplaceable) {
            return false;
        }
        if (world.field_73011_w.func_177500_n() && fluid.doesVaporize(this.sigilFluid)) {
            fluid.vaporize(player, world, blockPos, this.sigilFluid);
            return true;
        }
        Block block = fluid.getBlock();
        Object handler = block instanceof IFluidBlock ? new FluidBlockWrapper((IFluidBlock)block, world, blockPos) : (block instanceof BlockLiquid ? new BlockLiquidWrapper((BlockLiquid)block, world, blockPos) : new BlockWrapper(block, world, blockPos));
        return this.tryInsertSigilFluid((IFluidHandler)handler, true);
    }
}

