/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import rustic.common.blocks.BlockBase;
import rustic.common.blocks.BlockRope;
import rustic.common.blocks.crops.BlockGrapeLeaves;

public abstract class BlockRopeBase
extends BlockBase {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);
    public static final PropertyBool DANGLE = PropertyBool.func_177716_a((String)"dangle");
    protected static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625);
    protected static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.4375, 0.4375, 1.0, 0.5625, 0.5625);
    protected static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.4375, 0.4375, 0.0, 0.5625, 0.5625, 1.0);
    protected static final AxisAlignedBB X_DANGLE_AABB = new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 0.5625, 0.5625);
    protected static final AxisAlignedBB Z_DANGLE_AABB = new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 0.5625, 1.0);

    public BlockRopeBase(Material mat, String name, boolean register) {
        super(mat, name, register);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.func_176198_a(world, pos.func_177972_a(side), side) && stack.func_77973_b() == Item.func_150898_a((Block)this)) {
            int yOffset;
            if (!this.isBlockSupported(world, pos, state)) {
                this.dropBlock(world, pos, state);
                return true;
            }
            for (yOffset = 1; yOffset < 64 && world.func_180495_p(pos.func_177979_c(yOffset)).func_177230_c() == this; ++yOffset) {
                if (world.func_180495_p(pos.func_177979_c(yOffset)).func_177229_b(AXIS) == EnumFacing.Axis.Y) continue;
                return false;
            }
            if (this.func_176196_c(world, pos.func_177979_c(yOffset))) {
                world.func_180501_a(pos.func_177979_c(yOffset), state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y), 3);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
                SoundType soundType = this.getSoundType(state, world, pos, (Entity)player);
                world.func_184134_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() - yOffset), (double)pos.func_177952_p(), soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, false);
                return true;
            }
        }
        return false;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        IBlockState testState = world.func_180495_p(pos.func_177972_a(side.func_176734_d()));
        if (side == EnumFacing.UP) {
            return this.func_176198_a(world, pos, EnumFacing.DOWN);
        }
        boolean isThis = testState.func_177230_c() == this && testState.func_177229_b(AXIS) == side.func_176740_k();
        boolean isSideSolid = world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side, false);
        return isThis || isSideSolid;
    }

    protected void dropBlock(World worldIn, BlockPos pos, IBlockState state) {
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        SoundType soundType = this.getSoundType(state, worldIn, pos, null);
        worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, true);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing dir = null;
        if (fromPos.func_177958_n() != pos.func_177958_n()) {
            dir = fromPos.func_177958_n() - pos.func_177958_n() < 0 ? EnumFacing.WEST : EnumFacing.EAST;
        } else if (fromPos.func_177956_o() != pos.func_177956_o()) {
            dir = fromPos.func_177956_o() - pos.func_177956_o() < 0 ? EnumFacing.DOWN : EnumFacing.UP;
        } else if (fromPos.func_177952_p() != pos.func_177952_p()) {
            EnumFacing enumFacing = dir = fromPos.func_177952_p() - pos.func_177952_p() < 0 ? EnumFacing.NORTH : EnumFacing.SOUTH;
        }
        if (dir != null && state.func_177229_b(AXIS) == dir.func_176740_k() && !this.isSideSupported(worldIn, pos, state, dir)) {
            if (dir == EnumFacing.UP) {
                this.dropBlock(worldIn, pos, state);
            } else if (!this.isBlockSupported(worldIn, pos, state)) {
                this.dropBlock(worldIn, pos, state);
            }
        }
    }

    public boolean isSideSupported(World world, BlockPos pos, IBlockState state, EnumFacing facing) {
        IBlockState testState = world.func_180495_p(pos.func_177972_a(facing));
        if (facing == EnumFacing.DOWN) {
            return false;
        }
        boolean isSame = testState.func_177230_c() == state.func_177230_c() && (state.func_177229_b(AXIS) == EnumFacing.Axis.Y && facing.func_176740_k() == EnumFacing.Axis.Y || testState.func_177229_b(AXIS) == state.func_177229_b(AXIS));
        boolean isSideSolid = world.isSideSolid(pos.func_177972_a(facing), facing.func_176734_d(), false);
        return isSame || isSideSolid;
    }

    public boolean isBlockSupported(World world, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(AXIS) == EnumFacing.Axis.X) {
            return this.isSideSupported(world, pos, state, EnumFacing.WEST) && this.isSideSupported(world, pos, state, EnumFacing.EAST);
        }
        if (state.func_177229_b(AXIS) == EnumFacing.Axis.Y) {
            return this.isSideSupported(world, pos, state, EnumFacing.UP);
        }
        if (state.func_177229_b(AXIS) == EnumFacing.Axis.Z) {
            return this.isSideSupported(world, pos, state, EnumFacing.NORTH) && this.isSideSupported(world, pos, state, EnumFacing.SOUTH);
        }
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS, DANGLE});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing.Axis enumfacing$axis = EnumFacing.Axis.Y;
        int i = meta & 3;
        if (i == 0) {
            enumfacing$axis = EnumFacing.Axis.Y;
        } else if (i == 1) {
            enumfacing$axis = EnumFacing.Axis.X;
        } else if (i == 2) {
            enumfacing$axis = EnumFacing.Axis.Z;
        }
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)enumfacing$axis);
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        EnumFacing.Axis enumfacing$axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (enumfacing$axis == EnumFacing.Axis.X) {
            i = 1;
        } else if (enumfacing$axis == EnumFacing.Axis.Z) {
            i = 2;
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177229_b(AXIS) != EnumFacing.Axis.Y && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockRopeBase && !(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockGrapeLeaves) && world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)BlockRope.AXIS) == EnumFacing.Axis.Y) {
            return state.func_177226_a((IProperty)DANGLE, (Comparable)Boolean.valueOf(true));
        }
        return state.func_177226_a((IProperty)DANGLE, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(AXIS, (Comparable)facing.func_176740_k());
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z);
                    }
                    case Z: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
            case Y: {
                return Y_AABB;
            }
            case X: {
                if (((Boolean)state.func_177229_b((IProperty)DANGLE)).booleanValue()) {
                    return X_DANGLE_AABB;
                }
                return X_AABB;
            }
            case Z: {
                if (((Boolean)state.func_177229_b((IProperty)DANGLE)).booleanValue()) {
                    return Z_DANGLE_AABB;
                }
                return Z_AABB;
            }
        }
        return Y_AABB;
    }
}

