/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.proxy;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.AnimationTESR;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import vazkii.botania.api.boss.IBotaniaBoss;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.multiblock.IMultiblockRenderHook;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.lexicon.multiblock.component.AnyComponent;
import vazkii.botania.api.wiki.IWikiProvider;
import vazkii.botania.api.wiki.WikiHooks;
import vazkii.botania.client.challenge.ModChallenges;
import vazkii.botania.client.core.handler.BaubleRenderHandler;
import vazkii.botania.client.core.handler.BossBarHandler;
import vazkii.botania.client.core.handler.BoundTileRenderer;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.ColorHandler;
import vazkii.botania.client.core.handler.ContributorFancinessHandler;
import vazkii.botania.client.core.handler.CorporeaAutoCompleteHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.handler.MultiblockRenderHandler;
import vazkii.botania.client.core.handler.PersistentVariableHelper;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.fx.FXLightning;
import vazkii.botania.client.fx.FXSparkle;
import vazkii.botania.client.fx.FXWisp;
import vazkii.botania.client.gui.lexicon.GuiLexicon;
import vazkii.botania.client.gui.lexicon.GuiLexiconEntry;
import vazkii.botania.client.gui.lexicon.GuiLexiconIndex;
import vazkii.botania.client.render.entity.LayerGaiaHead;
import vazkii.botania.client.render.entity.RenderBabylonWeapon;
import vazkii.botania.client.render.entity.RenderCorporeaSpark;
import vazkii.botania.client.render.entity.RenderDoppleganger;
import vazkii.botania.client.render.entity.RenderManaStorm;
import vazkii.botania.client.render.entity.RenderPinkWither;
import vazkii.botania.client.render.entity.RenderPixie;
import vazkii.botania.client.render.entity.RenderPoolMinecart;
import vazkii.botania.client.render.entity.RenderSnowballStack;
import vazkii.botania.client.render.entity.RenderSpark;
import vazkii.botania.client.render.tile.RenderTileAlfPortal;
import vazkii.botania.client.render.tile.RenderTileAltar;
import vazkii.botania.client.render.tile.RenderTileAnimatedTorch;
import vazkii.botania.client.render.tile.RenderTileAvatar;
import vazkii.botania.client.render.tile.RenderTileBellows;
import vazkii.botania.client.render.tile.RenderTileBrewery;
import vazkii.botania.client.render.tile.RenderTileCocoon;
import vazkii.botania.client.render.tile.RenderTileCorporeaCrystalCube;
import vazkii.botania.client.render.tile.RenderTileCorporeaIndex;
import vazkii.botania.client.render.tile.RenderTileEnchanter;
import vazkii.botania.client.render.tile.RenderTileFloatingFlower;
import vazkii.botania.client.render.tile.RenderTileGaiaHead;
import vazkii.botania.client.render.tile.RenderTileHourglass;
import vazkii.botania.client.render.tile.RenderTileIncensePlate;
import vazkii.botania.client.render.tile.RenderTileLightRelay;
import vazkii.botania.client.render.tile.RenderTilePool;
import vazkii.botania.client.render.tile.RenderTilePrism;
import vazkii.botania.client.render.tile.RenderTilePylon;
import vazkii.botania.client.render.tile.RenderTileRedString;
import vazkii.botania.client.render.tile.RenderTileRuneAltar;
import vazkii.botania.client.render.tile.RenderTileSparkChanger;
import vazkii.botania.client.render.tile.RenderTileSpreader;
import vazkii.botania.client.render.tile.RenderTileStarfield;
import vazkii.botania.client.render.tile.RenderTileTerraPlate;
import vazkii.botania.client.render.tile.RenderTileTeruTeruBozu;
import vazkii.botania.client.render.tile.RenderTileTinyPotato;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAlfPortal;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileAnimatedTorch;
import vazkii.botania.common.block.tile.TileAvatar;
import vazkii.botania.common.block.tile.TileBrewery;
import vazkii.botania.common.block.tile.TileCocoon;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.block.tile.TileFloatingFlower;
import vazkii.botania.common.block.tile.TileFloatingSpecialFlower;
import vazkii.botania.common.block.tile.TileGaiaHead;
import vazkii.botania.common.block.tile.TileHourglass;
import vazkii.botania.common.block.tile.TileIncensePlate;
import vazkii.botania.common.block.tile.TileLightRelay;
import vazkii.botania.common.block.tile.TilePylon;
import vazkii.botania.common.block.tile.TileRuneAltar;
import vazkii.botania.common.block.tile.TileSparkChanger;
import vazkii.botania.common.block.tile.TileStarfield;
import vazkii.botania.common.block.tile.TileTerraPlate;
import vazkii.botania.common.block.tile.TileTeruTeruBozu;
import vazkii.botania.common.block.tile.TileTinyPotato;
import vazkii.botania.common.block.tile.corporea.TileCorporeaCrystalCube;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.block.tile.mana.TileBellows;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.block.tile.mana.TilePrism;
import vazkii.botania.common.block.tile.mana.TilePump;
import vazkii.botania.common.block.tile.mana.TileSpreader;
import vazkii.botania.common.block.tile.string.TileRedString;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.core.proxy.IProxy;
import vazkii.botania.common.core.version.AdaptorNotifier;
import vazkii.botania.common.entity.EntityBabylonWeapon;
import vazkii.botania.common.entity.EntityCorporeaSpark;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.entity.EntityEnderAirBottle;
import vazkii.botania.common.entity.EntityManaStorm;
import vazkii.botania.common.entity.EntityPinkWither;
import vazkii.botania.common.entity.EntityPixie;
import vazkii.botania.common.entity.EntityPoolMinecart;
import vazkii.botania.common.entity.EntitySpark;
import vazkii.botania.common.entity.EntityThornChakram;
import vazkii.botania.common.entity.EntityVineBall;
import vazkii.botania.common.item.ItemSextant;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemMonocle;
import vazkii.botania.common.lexicon.LexiconData;

public class ClientProxy
implements IProxy {
    public static final VertexFormat POSITION_TEX_LMAP_NORMAL = new VertexFormat().func_181721_a(DefaultVertexFormats.field_181713_m).func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(DefaultVertexFormats.field_181716_p).func_181721_a(DefaultVertexFormats.field_181717_q);
    public static final VertexFormat POSITION_TEX_LMAP = new VertexFormat().func_181721_a(DefaultVertexFormats.field_181713_m).func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(DefaultVertexFormats.field_181716_p);
    public static boolean jingleTheBells = false;
    public static boolean dootDoot = false;
    private static final ModelBiped EMPTY_MODEL = new ModelBiped();
    public static final KeyBinding CORPOREA_REQUEST;
    private static boolean noclipEnabled;
    private static boolean corruptSparkle;
    private static boolean distanceLimit;
    private static boolean depthTest;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        PersistentVariableHelper.setCacheFile(new File(Minecraft.func_71410_x().field_71412_D, "BotaniaVars.dat"));
        try {
            PersistentVariableHelper.load();
            PersistentVariableHelper.save();
        }
        catch (IOException e) {
            Botania.LOGGER.fatal("Persistent Variables couldn't load!!");
        }
        MinecraftForge.EVENT_BUS.register((Object)MiscellaneousIcons.INSTANCE);
        this.initRenderers();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ColorHandler.init();
        this.initAuxiliaryRender();
        ModChallenges.init();
        if (ConfigHandler.boundBlockWireframe) {
            MinecraftForge.EVENT_BUS.register(BoundTileRenderer.class);
        }
        if (ConfigHandler.useAdaptativeConfig) {
            MinecraftForge.EVENT_BUS.register(AdaptorNotifier.class);
        }
        if (ConfigHandler.enableSeasonalFeatures) {
            LocalDateTime now = LocalDateTime.now();
            if (now.getMonth() == Month.DECEMBER && now.getDayOfMonth() >= 16 || now.getMonth() == Month.JANUARY && now.getDayOfMonth() <= 2) {
                jingleTheBells = true;
            }
            if (now.getMonth() == Month.OCTOBER) {
                dootDoot = true;
            }
        }
        TileEntityItemStackRenderer.field_147719_a = new RenderTilePylon.ForwardingTEISR(TileEntityItemStackRenderer.field_147719_a);
        ClientRegistry.registerKeyBinding((KeyBinding)CORPOREA_REQUEST);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        CorporeaAutoCompleteHandler.updateItemList();
    }

    private void initRenderers() {
        RenderTileFloatingFlower renderTileFloatingFlower = new RenderTileFloatingFlower();
        RenderTilePylon renderTilePylon = new RenderTilePylon();
        ClientRegistry.bindTileEntitySpecialRenderer(TileAltar.class, (TileEntitySpecialRenderer)new RenderTileAltar());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSpreader.class, (TileEntitySpecialRenderer)new RenderTileSpreader());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePool.class, (TileEntitySpecialRenderer)new RenderTilePool());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRuneAltar.class, (TileEntitySpecialRenderer)new RenderTileRuneAltar());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePylon.class, (TileEntitySpecialRenderer)renderTilePylon);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEnchanter.class, (TileEntitySpecialRenderer)new RenderTileEnchanter());
        ClientRegistry.bindTileEntitySpecialRenderer(TileAlfPortal.class, (TileEntitySpecialRenderer)new RenderTileAlfPortal());
        ClientRegistry.bindTileEntitySpecialRenderer(TileFloatingFlower.class, (TileEntitySpecialRenderer)renderTileFloatingFlower);
        ClientRegistry.bindTileEntitySpecialRenderer(TileFloatingSpecialFlower.class, (TileEntitySpecialRenderer)renderTileFloatingFlower);
        ClientRegistry.bindTileEntitySpecialRenderer(TileTinyPotato.class, (TileEntitySpecialRenderer)new RenderTileTinyPotato());
        ClientRegistry.bindTileEntitySpecialRenderer(TileStarfield.class, (TileEntitySpecialRenderer)new RenderTileStarfield());
        ClientRegistry.bindTileEntitySpecialRenderer(TileBrewery.class, (TileEntitySpecialRenderer)new RenderTileBrewery());
        ClientRegistry.bindTileEntitySpecialRenderer(TileTerraPlate.class, (TileEntitySpecialRenderer)new RenderTileTerraPlate());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRedString.class, (TileEntitySpecialRenderer)new RenderTileRedString());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePrism.class, (TileEntitySpecialRenderer)new RenderTilePrism());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCorporeaIndex.class, (TileEntitySpecialRenderer)new RenderTileCorporeaIndex());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePump.class, (TileEntitySpecialRenderer)new AnimationTESR());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCorporeaCrystalCube.class, (TileEntitySpecialRenderer)new RenderTileCorporeaCrystalCube());
        ClientRegistry.bindTileEntitySpecialRenderer(TileIncensePlate.class, (TileEntitySpecialRenderer)new RenderTileIncensePlate());
        ClientRegistry.bindTileEntitySpecialRenderer(TileHourglass.class, (TileEntitySpecialRenderer)new RenderTileHourglass());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSparkChanger.class, (TileEntitySpecialRenderer)new RenderTileSparkChanger());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCocoon.class, (TileEntitySpecialRenderer)new RenderTileCocoon());
        ClientRegistry.bindTileEntitySpecialRenderer(TileLightRelay.class, (TileEntitySpecialRenderer)new RenderTileLightRelay());
        ClientRegistry.bindTileEntitySpecialRenderer(TileBellows.class, (TileEntitySpecialRenderer)new RenderTileBellows());
        ClientRegistry.bindTileEntitySpecialRenderer(TileGaiaHead.class, (TileEntitySpecialRenderer)new RenderTileGaiaHead());
        ClientRegistry.bindTileEntitySpecialRenderer(TileTeruTeruBozu.class, (TileEntitySpecialRenderer)new RenderTileTeruTeruBozu());
        ClientRegistry.bindTileEntitySpecialRenderer(TileAvatar.class, (TileEntitySpecialRenderer)new RenderTileAvatar());
        ClientRegistry.bindTileEntitySpecialRenderer(TileAnimatedTorch.class, (TileEntitySpecialRenderer)new RenderTileAnimatedTorch());
        RenderingRegistry.registerEntityRenderingHandler(EntityPixie.class, RenderPixie::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityDoppleganger.class, RenderDoppleganger::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpark.class, RenderSpark::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCorporeaSpark.class, RenderCorporeaSpark::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPoolMinecart.class, RenderPoolMinecart::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPinkWither.class, RenderPinkWither::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityManaStorm.class, RenderManaStorm::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBabylonWeapon.class, RenderBabylonWeapon::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityThornChakram.class, renderManager -> new RenderSnowballStack<EntityThornChakram>(renderManager, ModItems.thornChakram, Minecraft.func_71410_x().func_175599_af(), entity -> new ItemStack(ModItems.thornChakram, 1, entity.isFire() ? 1 : 0)));
        RenderingRegistry.registerEntityRenderingHandler(EntityVineBall.class, renderManager -> new RenderSnowball(renderManager, ModItems.vineBall, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderAirBottle.class, renderManager -> new RenderSnowballStack<EntityEnderAirBottle>(renderManager, ModItems.manaResource, Minecraft.func_71410_x().func_175599_af(), entity -> new ItemStack(ModItems.manaResource, 1, 15)));
        ShaderHelper.initShaders();
        IMultiblockRenderHook.renderHooks.put(ModBlocks.pylon, renderTilePylon);
    }

    private void initAuxiliaryRender() {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        RenderPlayer render = (RenderPlayer)skinMap.get("default");
        render.func_177094_a((LayerRenderer)new ContributorFancinessHandler());
        render.func_177094_a((LayerRenderer)new BaubleRenderHandler());
        render.func_177094_a((LayerRenderer)new LayerGaiaHead(render.func_177087_b().field_78116_c));
        render = (RenderPlayer)skinMap.get("slim");
        render.func_177094_a((LayerRenderer)new ContributorFancinessHandler());
        render.func_177094_a((LayerRenderer)new BaubleRenderHandler());
        render.func_177094_a((LayerRenderer)new LayerGaiaHead(render.func_177087_b().field_78116_c));
    }

    @Override
    public void setEntryToOpen(LexiconEntry entry) {
        GuiLexicon.currentOpenLexicon = new GuiLexiconEntry(entry, new GuiLexiconIndex(entry.category));
    }

    @Override
    public void setToTutorialIfFirstLaunch() {
        if (PersistentVariableHelper.firstLoad) {
            GuiLexicon.currentOpenLexicon = new GuiLexiconEntry(LexiconData.welcome, new GuiLexiconEntry(LexiconData.tutorial, new GuiLexicon())).setFirstEntry();
        }
    }

    @Override
    public void setLexiconStack(ItemStack stack) {
        GuiLexicon.stackUsed = stack;
    }

    @Override
    public boolean isTheClientPlayer(EntityLivingBase entity) {
        return entity == Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public boolean isClientPlayerWearingMonocle() {
        return ItemMonocle.hasMonocle((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public boolean openWikiPage(World world, Block block, RayTraceResult pos) {
        if (ConfigHandler.lexicaOfflineMode) {
            return false;
        }
        IWikiProvider wiki = WikiHooks.getWikiFor(block);
        String url = wiki.getWikiURL(world, pos, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (url != null && !url.isEmpty()) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getLastVersion() {
        String s = PersistentVariableHelper.lastBotaniaVersion;
        if (s == null) {
            return "N/A";
        }
        if (s.indexOf("-") > 0) {
            return s.split("-")[1];
        }
        return s;
    }

    @Override
    public long getWorldElapsedTicks() {
        return ClientTickHandler.ticksInGame;
    }

    @Override
    public void setMultiblock(World world, int x, int y, int z, double radius, Block block) {
        ItemSextant.MultiblockSextant mb = new ItemSextant.MultiblockSextant();
        int iradius = (int)radius + 1;
        for (int i = 0; i < iradius * 2 + 1; ++i) {
            for (int j = 0; j < iradius * 2 + 1; ++j) {
                int xp = x + i - iradius;
                int zp = z + j - iradius;
                if ((int)Math.floor(MathHelper.pointDistancePlane(xp, zp, x, z)) != iradius - 1) continue;
                mb.addComponent(new AnyComponent(new BlockPos(xp - x, 1, zp - z), block.func_176223_P()));
            }
        }
        MultiblockRenderHandler.setMultiblock(mb.makeSet());
        MultiblockRenderHandler.anchor = new BlockPos(x, y, z);
    }

    @Override
    public void removeSextantMultiblock() {
        Multiblock mb;
        MultiblockSet set = MultiblockRenderHandler.currentMultiblock;
        if (set != null && (mb = set.getForFacing(EnumFacing.SOUTH)) instanceof ItemSextant.MultiblockSextant) {
            MultiblockRenderHandler.setMultiblock(null);
        }
    }

    @Override
    public void setSparkleFXNoClip(boolean noclip) {
        noclipEnabled = noclip;
    }

    @Override
    public void setSparkleFXCorrupt(boolean corrupt) {
        corruptSparkle = corrupt;
    }

    @Override
    public void sparkleFX(double x, double y, double z, float r, float g, float b, float size, int m, boolean fake) {
        if (!this.doParticle() && !fake) {
            return;
        }
        FXSparkle sparkle = new FXSparkle((World)Minecraft.func_71410_x().field_71441_e, x, y, z, size, r, g, b, m);
        sparkle.fake = fake;
        sparkle.setCanCollide(!fake);
        if (noclipEnabled) {
            sparkle.setCanCollide(false);
        }
        if (corruptSparkle) {
            sparkle.corrupt = true;
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)sparkle);
    }

    @Override
    public void setWispFXDistanceLimit(boolean limit) {
        distanceLimit = limit;
    }

    @Override
    public void setWispFXDepthTest(boolean test) {
        depthTest = test;
    }

    @Override
    public void wispFX(double x, double y, double z, float r, float g, float b, float size, float motionx, float motiony, float motionz, float maxAgeMul) {
        if (!this.doParticle()) {
            return;
        }
        FXWisp wisp = new FXWisp((World)Minecraft.func_71410_x().field_71441_e, x, y, z, size, r, g, b, distanceLimit, depthTest, maxAgeMul);
        wisp.setSpeed(motionx, motiony, motionz);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)wisp);
    }

    private boolean doParticle() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return false;
        }
        if (!ConfigHandler.useVanillaParticleLimiter) {
            return true;
        }
        float chance = 1.0f;
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 1) {
            chance = 0.6f;
        } else if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 2) {
            chance = 0.2f;
        }
        return chance == 1.0f || Math.random() < (double)chance;
    }

    @Override
    public void lightningFX(Vector3 vectorStart, Vector3 vectorEnd, float ticksPerMeter, long seed, int colorOuter, int colorInner) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new FXLightning((World)Minecraft.func_71410_x().field_71441_e, vectorStart, vectorEnd, ticksPerMeter, seed, colorOuter, colorInner));
    }

    @Override
    public void addBoss(IBotaniaBoss boss) {
        BossBarHandler.bosses.add(boss);
    }

    @Override
    public void removeBoss(IBotaniaBoss boss) {
        BossBarHandler.bosses.remove(boss);
    }

    @Override
    public int getClientRenderDistance() {
        return Minecraft.func_71410_x().field_71474_y.field_151451_c;
    }

    public ModelBiped getEmptyModelBiped() {
        return EMPTY_MODEL;
    }

    static {
        EMPTY_MODEL.func_178719_a(false);
        CORPOREA_REQUEST = new KeyBinding("nei.options.keys.gui.botania_corporea_request", (IKeyConflictContext)KeyConflictContext.GUI, 46, "Botania");
        noclipEnabled = false;
        corruptSparkle = false;
        distanceLimit = true;
        depthTest = true;
    }
}

