/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import mysticalmechanics.api.IMechCapability;
import net.minecraft.util.EnumFacing;

public class ConsumerMechCapability
implements IMechCapability {
    public double[] power = new double[6];
    double maxPower;
    boolean dirty = true;
    boolean additive = false;

    public void setAdditive(boolean additive) {
        this.additive = additive;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public double getPower(EnumFacing enumFacing) {
        if (enumFacing == null) {
            if (this.dirty) {
                this.recalculateMax();
                this.dirty = false;
            }
            return this.maxPower;
        }
        return this.power[enumFacing.func_176745_a()];
    }

    private void recalculateMax() {
        this.maxPower = 0.0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            double power = this.getPower(facing);
            if (this.additive) {
                this.maxPower += power;
                continue;
            }
            this.maxPower = Math.max(power, this.maxPower);
        }
    }

    public void setPower(double value, EnumFacing enumFacing) {
        if (enumFacing == null) {
            for (int i = 0; i < 6; ++i) {
                this.power[i] = value;
            }
        } else {
            double oldPower = this.power[enumFacing.func_176745_a()];
            this.power[enumFacing.func_176745_a()] = value;
            if (oldPower != value) {
                this.dirty = true;
                this.onPowerChange();
            }
        }
    }

    public void onPowerChange() {
    }

    public boolean isOutput(EnumFacing from) {
        return false;
    }
}

