/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import teamroots.embers.block.BlockStampBase;
import teamroots.embers.tileentity.TileEntityStampBase;

public class TileEntityStampBaseRenderer
extends TileEntitySpecialRenderer<TileEntityStampBase> {
    int blue;
    int green;
    int red;
    int alpha;
    int lightx;
    int lighty;
    double minU;
    double minV;
    double maxU;
    double maxV;
    double diffU;
    double diffV;

    public void render(TileEntityStampBase tile, double x, double y, double z, float partialTicks, int destroyStage, float tileAlpha) {
        if (tile != null && !tile.func_145831_w().func_175623_d(tile.func_174877_v()) && tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177230_c() instanceof BlockStampBase) {
            EnumFacing face = (EnumFacing)tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177229_b((IProperty)BlockStampBase.facing);
            int capacity = tile.getCapacity();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            FluidStack fluidStack = tile.getFluidStack();
            if (fluidStack != null) {
                Fluid fluid = fluidStack.getFluid();
                int amount = fluidStack.amount;
                int c = fluid.getColor(fluidStack);
                this.blue = c & 0xFF;
                this.green = c >> 8 & 0xFF;
                this.red = c >> 16 & 0xFF;
                this.alpha = c >> 24 & 0xFF;
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill(fluidStack).toString());
                this.diffU = this.maxU - this.minU;
                this.diffV = this.maxV - this.minV;
                this.minU = (double)sprite.func_94209_e() + this.diffU * 0.25;
                this.maxU = (double)sprite.func_94212_f() - this.diffU * 0.25;
                this.minV = (double)sprite.func_94206_g() + this.diffV * 0.25;
                this.maxV = (double)sprite.func_94210_h() - this.diffV * 0.25;
                int i = this.func_178459_a().func_175626_b(tile.func_174877_v(), fluid.getLuminosity(fluidStack));
                this.lightx = i >> 16 & 0xFFFF;
                this.lighty = i & 0xFFFF;
                GlStateManager.func_179129_p();
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                GlStateManager.func_179141_d();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                GL11.glPushMatrix();
                GL11.glTranslated((double)x, (double)y, (double)z);
                GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
                if (face == EnumFacing.UP) {
                    GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.NORTH) {
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.WEST) {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.SOUTH) {
                    GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.EAST) {
                    GL11.glRotated((double)270.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
                Tessellator tess = Tessellator.func_178181_a();
                BufferBuilder buffer = tess.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
                buffer.func_181662_b(0.25, 0.75 + 0.1875 * (double)((float)amount / (float)capacity), 0.25).func_187315_a(this.minU, this.minV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alpha).func_181675_d();
                buffer.func_181662_b(0.75, 0.75 + 0.1875 * (double)((float)amount / (float)capacity), 0.25).func_187315_a(this.maxU, this.minV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alpha).func_181675_d();
                buffer.func_181662_b(0.75, 0.75 + 0.1875 * (double)((float)amount / (float)capacity), 0.75).func_187315_a(this.maxU, this.maxV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alpha).func_181675_d();
                buffer.func_181662_b(0.25, 0.75 + 0.1875 * (double)((float)amount / (float)capacity), 0.75).func_187315_a(this.minU, this.maxV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alpha).func_181675_d();
                tess.func_78381_a();
                GL11.glPopMatrix();
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                GlStateManager.func_179145_e();
                GlStateManager.func_179089_o();
            }
            if (!tile.inputs.getStackInSlot(0).func_190926_b()) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)x, (double)y, (double)z);
                GL11.glTranslated((double)0.5, (double)0.75, (double)0.5);
                if (face == EnumFacing.UP) {
                    GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.NORTH) {
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.WEST) {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.SOUTH) {
                    GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (face == EnumFacing.EAST) {
                    GL11.glRotated((double)270.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                Random random = new Random();
                ItemStack stack = tile.inputs.getStackInSlot(0);
                random.setSeed(stack.func_190926_b() ? 187 : Item.func_150891_b((Item)stack.func_77973_b()) + stack.func_77960_j());
                GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
                for (int j = 0; j < Math.min(stack.func_190916_E(), 6); ++j) {
                    GlStateManager.func_179094_E();
                    float f7 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f9 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f6 = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    if (stack.func_190916_E() > 1) {
                        GlStateManager.func_179109_b((float)f7, (float)f9, (float)f6);
                    }
                    Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.GROUND);
                    GlStateManager.func_179121_F();
                }
                GL11.glPopMatrix();
            }
        }
    }
}

