/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.block.BlockItemTransfer;
import teamroots.embers.tileentity.TileEntityItemPipeBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;

public class TileEntityItemTransfer
extends TileEntityItemPipeBase {
    public static final int PRIORITY_TRANSFER = -10;
    double angle = 0.0;
    double turnRate = 1.0;
    public ItemStack filterItem = ItemStack.field_190927_a;
    Random random = new Random();
    boolean syncFilter;
    IItemHandler outputSide;

    @Override
    protected void initInventory() {
        this.inventory = new ItemStackHandler(1){

            public int getSlotLimit(int slot) {
                return TileEntityItemTransfer.this.getCapacity();
            }

            protected void onContentsChanged(int slot) {
                TileEntityItemTransfer.this.func_70296_d();
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (!TileEntityItemTransfer.this.filterItem.func_190926_b()) {
                    if (!stack.func_190926_b() && TileEntityItemTransfer.this.filterItem.func_77973_b() == stack.func_77973_b() && TileEntityItemTransfer.this.filterItem.func_77952_i() == stack.func_77952_i()) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
        this.outputSide = Misc.makeRestrictedItemHandler((IItemHandler)this.inventory, false, true);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeFilter(tag);
        return tag;
    }

    private void writeFilter(NBTTagCompound tag) {
        if (!this.filterItem.func_190926_b()) {
            tag.func_74782_a("filter", (NBTBase)this.filterItem.func_77955_b(new NBTTagCompound()));
        } else {
            tag.func_74778_a("filter", "empty");
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("filter")) {
            this.filterItem = new ItemStack(tag.func_74775_l("filter"));
        }
    }

    @Override
    public NBTTagCompound getSyncTag() {
        NBTTagCompound compound = super.func_189517_E_();
        if (this.syncFilter) {
            this.writeFilter(compound);
        }
        return compound;
    }

    @Override
    protected boolean requiresSync() {
        return this.syncFilter || super.requiresSync();
    }

    @Override
    protected void resetSync() {
        super.resetSync();
        this.syncFilter = false;
    }

    @Override
    int getCapacity() {
        return 4;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return facing == null || facing.func_176740_k() == this.getFacing().func_176740_k();
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            EnumFacing transferFacing = this.getFacing();
            if (facing == transferFacing) {
                return (T)this.outputSide;
            }
            if (facing == null || facing.func_176740_k() == transferFacing.func_176740_k()) {
                return (T)this.inventory;
            }
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    private EnumFacing getFacing() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        return (EnumFacing)state.func_177229_b((IProperty)BlockItemTransfer.facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (heldItem != ItemStack.field_190927_a) {
                this.filterItem = heldItem.func_77946_l();
                world.func_180501_a(pos, state.func_177226_a((IProperty)BlockItemTransfer.filter, (Comparable)Boolean.valueOf(true)), 10);
            } else {
                this.filterItem = ItemStack.field_190927_a;
                world.func_180501_a(pos, state.func_177226_a((IProperty)BlockItemTransfer.filter, (Comparable)Boolean.valueOf(false)), 10);
            }
            this.syncFilter = true;
            this.func_70296_d();
            return true;
        }
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && this.clogged && this.isAnySideUnclogged()) {
            Misc.spawnClogParticles(this.field_145850_b, this.field_174879_c, 2, 0.7f);
        }
        this.angle += this.turnRate;
        super.func_73660_a();
    }

    @Override
    public int getPriority(EnumFacing facing) {
        return -10;
    }

    @Override
    public EnumPipeConnection getInternalConnection(EnumFacing facing) {
        return EnumPipeConnection.NONE;
    }

    @Override
    void setInternalConnection(EnumFacing facing, EnumPipeConnection connection) {
    }

    @Override
    boolean isConnected(EnumFacing facing) {
        return this.getFacing().func_176740_k() == facing.func_176740_k();
    }

    @Override
    protected boolean isFrom(EnumFacing facing) {
        return facing == this.getFacing().func_176734_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing facing) {
        if (this.getFacing().func_176740_k() == facing.func_176740_k()) {
            return EnumPipeConnection.PIPE;
        }
        return EnumPipeConnection.NONE;
    }
}

