/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import teamroots.embers.SoundManager;
import teamroots.embers.block.BlockInfernoForgeEdge;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityInfernoForge;
import teamroots.embers.util.Misc;

public class TileEntityInfernoForgeOpening
extends TileEntity
implements ITileEntityBase,
ITickable {
    public boolean isOpen;
    public boolean prevState;
    public float openAmount;
    public float lastOpenAmount;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("isOpen", this.isOpen);
        tag.func_74757_a("prevState", this.prevState);
        tag.func_74776_a("openAmount", this.openAmount);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.isOpen = tag.func_74767_n("isOpen");
        this.prevState = tag.func_74767_n("prevState");
        this.openAmount = tag.func_74760_g("openAmount");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    public void toggle() {
        if (this.isOpen) {
            this.close();
        } else {
            this.open();
        }
    }

    public void open() {
        this.isOpen = true;
        this.prevState = false;
        this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundManager.INFERNO_FORGE_OPEN, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.func_70296_d();
    }

    public void close() {
        this.isOpen = false;
        this.prevState = true;
        this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundManager.INFERNO_FORGE_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.func_70296_d();
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityInfernoForge forge;
        if (!player.func_70093_af() && world.func_175625_s(pos.func_177977_b()) instanceof TileEntityInfernoForge && (forge = this.getForge(world, pos)) != null && forge.progress == 0) {
            this.toggle();
            return true;
        }
        return false;
    }

    private TileEntityInfernoForge getForge(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos.func_177977_b());
        return tile instanceof TileEntityInfernoForge ? (TileEntityInfernoForge)tile : null;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        BlockInfernoForgeEdge.breakBlockSafe(world, pos.func_177977_b(), player);
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        this.lastOpenAmount = this.openAmount;
        if (this.isOpen && !this.prevState && this.openAmount < 1.0f) {
            this.openAmount = 0.5f + 0.5f * this.openAmount;
            if (this.openAmount > 0.99f) {
                this.openAmount = 1.0f;
                this.prevState = this.isOpen;
                this.func_70296_d();
            }
        }
        if (!this.isOpen && this.prevState && this.openAmount > 0.0f) {
            this.openAmount = 0.5f * this.openAmount;
            if (this.openAmount < 0.01f) {
                this.openAmount = 0.0f;
                TileEntityInfernoForge forge = this.getForge(this.field_145850_b, this.field_174879_c);
                if (forge != null) {
                    forge.updateProgress();
                }
                this.prevState = this.isOpen;
                this.func_70296_d();
            }
        }
    }
}

