/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.RegistryManager;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IBin;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageAshenAmuletFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityCinderPlinth
extends TileEntity
implements ITileEntityBase,
ITickable,
ISoundController,
IExtraCapabilityInformation {
    public static final double EMBER_COST = 0.5;
    public static final int PROCESS_TIME = 40;
    public IEmberCapability capability = new DefaultEmberCapability();
    int angle = 0;
    int turnRate = 0;
    int progress = 0;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityCinderPlinth.this.func_70296_d();
        }
    };
    Random random = new Random();
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public TileEntityCinderPlinth() {
        this.capability.setEmberCapacity(4000.0);
        this.capability.setEmber(0.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        tag.func_74768_a("progress", 0);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        this.progress = tag.func_74762_e("progress");
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            player.func_184611_a(hand, this.inventory.insertItem(0, heldItem, false));
            this.func_70296_d();
            return true;
        }
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            if (!this.func_145831_w().field_72995_K) {
                player.func_184611_a(hand, this.inventory.extractItem(0, this.inventory.getStackInSlot(0).func_190916_E(), false));
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        this.turnRate = 1;
        List<IUpgradeProvider> upgrades = UpgradeUtil.getUpgrades(this.field_145850_b, this.field_174879_c, EnumFacing.field_82609_l);
        UpgradeUtil.verifyUpgrades(this, upgrades);
        if (UpgradeUtil.doTick(this, upgrades)) {
            return;
        }
        if (this.func_145831_w().field_72995_K) {
            this.handleSound();
        }
        if (this.shouldWork()) {
            boolean cancel = UpgradeUtil.doWork(this, upgrades);
            if (!cancel) {
                ++this.progress;
                if (this.func_145831_w().field_72995_K) {
                    ParticleUtil.spawnParticleSmoke(this.func_145831_w(), (float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 0.875f, (float)this.func_174877_v().func_177952_p() + 0.5f, 0.0125f * (this.random.nextFloat() - 0.5f), 0.025f * (this.random.nextFloat() + 1.0f), 0.0125f * (this.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 0.6f, 3.0f + this.random.nextFloat(), 48);
                }
                double emberCost = UpgradeUtil.getTotalEmberConsumption(this, 0.5, upgrades);
                UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, emberCost), upgrades);
                this.capability.removeAmount(emberCost, true);
                if (this.progress > UpgradeUtil.getWorkTime(this, 40, upgrades)) {
                    this.progress = 0;
                    this.inventory.extractItem(0, 1, false);
                    TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177977_b());
                    ArrayList outputs = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(RegistryManager.dust_ash, 1)});
                    UpgradeUtil.transformOutput((TileEntity)this, outputs, upgrades);
                    for (ItemStack remainder : outputs) {
                        if (tile instanceof IBin) {
                            remainder = ((IBin)tile).getInventory().insertItem(0, remainder, false);
                        }
                        if (remainder.func_190926_b() || this.func_145831_w().field_72995_K) continue;
                        this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 0.5, remainder));
                    }
                    if (!this.func_145831_w().field_72995_K) {
                        AxisAlignedBB aabb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.3, (double)this.field_174879_c.func_177956_o() + 0.9, (double)this.field_174879_c.func_177952_p() + 0.3, (double)this.field_174879_c.func_177958_n() + 0.7, (double)this.field_174879_c.func_177956_o() + 1.3, (double)this.field_174879_c.func_177952_p() + 0.7);
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageAshenAmuletFX(aabb));
                    }
                }
                this.func_70296_d();
            }
        } else if (this.progress != 0) {
            this.progress = 0;
            this.func_70296_d();
        }
        this.angle += this.turnRate;
    }

    private boolean shouldWork() {
        return !this.inventory.getStackInSlot(0).func_190926_b() && this.capability.getEmber() > 0.0;
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.PLINTH_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.shouldWork();
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", null));
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.OUTPUT, "embers.tooltip.goggles.item", I18n.func_135052_a((String)"embers.tooltip.goggles.item.ash", (Object[])new Object[0])));
        }
    }
}

