/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.recipe;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.recipe.DawnstoneAnvilRecipe;
import teamroots.embers.recipe.IFocusRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.util.IngredientSpecial;
import teamroots.embers.util.Misc;

public class AnvilBreakdownRecipe
extends DawnstoneAnvilRecipe
implements IFocusRecipe {
    public AnvilBreakdownRecipe() {
        super(new IngredientSpecial(stack -> stack.func_77973_b().func_82789_a(stack, Misc.getRepairItem(stack)) && Misc.getResourceCount(stack) != -1 && !RecipeRegistry.isBlacklistedFromBreakdown(stack)), Ingredient.field_193370_a, new ItemStack[0]);
    }

    @Override
    public boolean matches(ItemStack input1, ItemStack input2) {
        ItemStack repairItem = Misc.getRepairItem(input1);
        return !input1.func_190926_b() && !ItemModUtil.hasHeat(input1) && input1.func_77973_b().func_82789_a(input1, repairItem) && input2.func_190926_b() && Misc.getResourceCount(input1) != -1 && !RecipeRegistry.isBlacklistedFromBreakdown(input1);
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.getBottomInputs().stream().map(this::getBreakResult).collect(Collectors.toList());
    }

    @Override
    public List<ItemStack> getResult(TileEntity tile, ItemStack input1, ItemStack input2) {
        return Lists.newArrayList((Object[])new ItemStack[]{this.getBreakResult(input1)});
    }

    @Override
    public List<ItemStack> getOutputs(IFocus<ItemStack> focus, int slot) {
        if (slot == 2) {
            if (focus.getMode() == IFocus.Mode.OUTPUT) {
                List collect = this.getBottomInputs().stream().filter(x -> Misc.getRepairItem(x).func_77969_a((ItemStack)focus.getValue())).map(this::getBreakResult).collect(Collectors.toList());
                return Lists.newArrayList(collect);
            }
            return Lists.newArrayList((Object[])new ItemStack[]{this.getBreakResult((ItemStack)focus.getValue())});
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ItemStack> getInputs(IFocus<ItemStack> focus, int slot) {
        if (slot == 0) {
            if (focus.getMode() == IFocus.Mode.INPUT) {
                return Lists.newArrayList((Object[])new ItemStack[]{(ItemStack)focus.getValue()});
            }
            return this.getBottomInputs().stream().filter(x -> Misc.getRepairItem(x).func_77969_a((ItemStack)focus.getValue())).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private ItemStack getBreakResult(ItemStack x) {
        int resourceAmount = Misc.getResourceCount(x);
        ItemStack repairItem = Misc.getRepairItem(x);
        return new ItemStack(repairItem.func_77973_b(), resourceAmount, repairItem.func_77960_j());
    }
}

