/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.itemmod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.ConfigManager;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.event.ScaleEvent;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.util.RenderUtil;

public class ModifierShiftingScales
extends ModifierBase {
    public static final ResourceLocation TEXTURE_HUD = new ResourceLocation("embers:textures/gui/icons.png");
    public static final IAttribute SCALES = new RangedAttribute(null, "generic.scales", 0.0, 0.0, 2048.0).func_111112_a(true);
    public static final int COOLDOWN = 33;
    public static final double MOVE_PER_SECOND_THRESHOLD = 0.5;
    public static HashSet<String> unaffectedDamageTypes = new HashSet();
    public static HashMap<UUID, Integer> cooldownTicksServer = new HashMap();
    public static HashMap<UUID, Vec3d> lastPositionServer = new HashMap();
    public static ArrayList<ShardParticle> shards = new ArrayList();
    public static int scalesLast = 0;

    public static void setLastPosition(UUID uuid, Vec3d pos) {
        lastPositionServer.put(uuid, pos);
    }

    public static double getMoveDistance(UUID uuid, Vec3d pos) {
        Vec3d lastPos = lastPositionServer.getOrDefault(uuid, pos);
        return lastPos.func_72438_d(pos);
    }

    private static void resetEntity(UUID uuid) {
        lastPositionServer.remove(uuid);
        cooldownTicksServer.remove(uuid);
    }

    public static void setCooldown(UUID uuid, int ticks) {
        cooldownTicksServer.put(uuid, ticks);
    }

    public static void setMaxCooldown(UUID uuid, int ticks) {
        cooldownTicksServer.put(uuid, Math.max(ticks, cooldownTicksServer.getOrDefault(uuid, 0)));
    }

    public static boolean hasCooldown(UUID uuid) {
        return cooldownTicksServer.getOrDefault(uuid, 0) > 0;
    }

    public ModifierShiftingScales() {
        super(ModifierBase.EnumType.ARMOR, "shifting_scales", 0.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEntityConstructEvent(EntityEvent.EntityConstructing event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_110140_aT().func_111150_b(SCALES);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (UUID uuid : cooldownTicksServer.keySet()) {
                int ticks = cooldownTicksServer.get(uuid) - 1;
                cooldownTicksServer.put(uuid, ticks);
            }
        }
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!entity.field_70170_p.field_72995_K) {
            UUID uuid = entity.func_110124_au();
            int scaleLevel = ItemModUtil.getArmorModifierLevel(entity, EmbersAPI.SHIFTING_SCALES) * 2;
            if (scaleLevel > 0) {
                if (ModifierShiftingScales.getMoveDistance(uuid, entity.func_174791_d()) * 20.0 > 0.5) {
                    ModifierShiftingScales.setMaxCooldown(uuid, 33);
                }
                double scales = EmbersAPI.getScales(entity);
                if (!ModifierShiftingScales.hasCooldown(uuid)) {
                    scales += 1.0;
                    ModifierShiftingScales.setCooldown(uuid, 33);
                }
                scales = Math.min(Math.min(scales, (double)(scaleLevel * 3)), (double)entity.func_110138_aP() * 1.5);
                EmbersAPI.setScales(entity, scales);
                ModifierShiftingScales.setLastPosition(uuid, entity.func_174791_d());
            } else {
                ModifierShiftingScales.resetEntity(uuid);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onHit(LivingDamageEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (unaffectedDamageTypes.contains(source.func_76355_l())) {
            return;
        }
        int scaleLevel = ItemModUtil.getArmorModifierLevel(entity, EmbersAPI.SHIFTING_SCALES) * 2;
        if (scaleLevel > 0) {
            if (!entity.field_70170_p.field_72995_K) {
                ModifierShiftingScales.setMaxCooldown(entity.func_110124_au(), 99);
            }
            ScaleEvent scaleEvent = new ScaleEvent(entity, event.getAmount(), source, ConfigManager.scaleDamageRates.getOrDefault(source.func_76355_l(), 1.0), ConfigManager.scaleDamagePasses.getOrDefault(source.func_76355_l(), 0.0));
            MinecraftForge.EVENT_BUS.post((Event)scaleEvent);
            double totalDamage = event.getAmount();
            double extraDamage = totalDamage * scaleEvent.getScalePassRate();
            double multiplier = scaleEvent.getScaleDamageRate();
            double damage = (totalDamage -= extraDamage) * multiplier;
            double scales = EmbersAPI.getScales(entity);
            double absorbed = Math.min(scales, damage);
            double prevScales = scales;
            damage -= absorbed;
            if ((int)(scales -= absorbed) < (int)prevScales) {
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundManager.SHIFTING_SCALES_BREAK, entity instanceof EntityPlayer ? SoundCategory.PLAYERS : SoundCategory.HOSTILE, 10.0f, 1.0f);
            }
            EmbersAPI.setScales(entity, scales);
            event.setAmount((float)((damage == 0.0 ? 0.0 : damage / multiplier) + extraDamage));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreenPre(RenderGameOverlayEvent.Pre event) {
        ScaledResolution resolution = event.getResolution();
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            mc.field_71446_o.func_110577_a(TEXTURE_HUD);
            int x = this.getBarX(resolution);
            int y = this.getBarY(resolution);
            int scales = (int)Math.ceil(EmbersAPI.getScales((EntityLivingBase)player));
            int segs = scales / 3;
            int last = scales % 3;
            if (last > 0) {
                ++segs;
            }
            int u = 18;
            int v = 0;
            for (int i = 0; i < segs; ++i) {
                if (i == segs - 1) {
                    u = (last + 2) % 3 * 9;
                }
                RenderUtil.drawTexturedModalRect(x + 8 * (i % 10), y - 10 * (i / 10), 0.0, (double)u / 256.0, (double)v / 256.0, (double)(u + 9) / 256.0, (double)(v + 9) / 256.0, 9, 9);
            }
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.field_71446_o.func_110577_a(Gui.field_110324_m);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private int getBarY(ScaledResolution resolution) {
        return resolution.func_78328_b() - 42;
    }

    @SideOnly(value=Side.CLIENT)
    private int getBarX(ScaledResolution resolution) {
        return resolution.func_78326_a() / 2 - 11 - 80;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (ShardParticle particle : shards) {
                particle.update();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreenPost(RenderGameOverlayEvent.Post event) {
        ScaledResolution resolution = event.getResolution();
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        mc.field_71446_o.func_110577_a(TEXTURE_HUD);
        Iterator<ShardParticle> iterator = shards.iterator();
        GlStateManager.func_179141_d();
        while (iterator.hasNext()) {
            ShardParticle particle = iterator.next();
            if (particle.getY() > (double)resolution.func_78328_b()) {
                iterator.remove();
            }
            int u = particle.getFrame() % 8 > 4 ? 5 : 0;
            int v = 9;
            RenderUtil.drawTexturedModalRect((int)particle.getX() - 2, (int)particle.getY() - 2, 0.0, (double)u / 256.0, (double)v / 256.0, (double)(u + 5) / 256.0, (double)(v + 5) / 256.0, 5, 5);
        }
        int scales = (int)Math.ceil(EmbersAPI.getScales((EntityLivingBase)player));
        Random random = new Random();
        if (scales < scalesLast) {
            int x = this.getBarX(resolution);
            int y = this.getBarY(resolution);
            int segsLast = scalesLast / 3;
            int lastLast = scalesLast % 3;
            if (lastLast > 0) {
                ++segsLast;
            }
            int segs = scales / 3;
            int last = scales % 3;
            if (last > 0) {
                ++segs;
            }
            for (int i = 0; i < Math.max(segs, segsLast); ++i) {
                int currentScale = i * 3 + last;
                if (currentScale < scales) continue;
                int xHeart = x + 8 * (i % 10) + 4;
                int yHeart = y - 10 * (i / 10) + 4;
                int pieces = 2;
                if (lastLast == 1 && i == Math.max(segs, segsLast) - 1) {
                    pieces = 1;
                }
                for (int e = 0; e < pieces; ++e) {
                    shards.add(new ShardParticle(xHeart, yHeart, random.nextInt(8), (random.nextDouble() - 0.5) * 10.0, (random.nextDouble() - 0.5) * 10.0, 0.5));
                }
            }
        }
        scalesLast = scales;
        mc.field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    private static class ShardParticle {
        double x;
        double y;
        int frame;
        double xSpeed;
        double ySpeed;
        double gravity;

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public int getFrame() {
            return this.frame;
        }

        public ShardParticle(double x, double y, int frame, double xSpeed, double ySpeed, double gravity) {
            this.x = x;
            this.y = y;
            this.frame = frame;
            this.xSpeed = xSpeed;
            this.ySpeed = ySpeed;
            this.gravity = gravity;
        }

        public void update() {
            this.x += this.xSpeed;
            this.y += this.ySpeed;
            if (this.ySpeed < 12.0) {
                this.ySpeed += this.gravity;
            }
            ++this.frame;
        }
    }
}

