/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.jei;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import teamroots.embers.RegistryManager;
import teamroots.embers.compat.jei.category.AlchemyRecipeCategory;
import teamroots.embers.compat.jei.category.DawnstoneAnvilCategory;
import teamroots.embers.compat.jei.category.MelterRecipeCategory;
import teamroots.embers.compat.jei.category.MixingRecipeCategory;
import teamroots.embers.compat.jei.category.StampRecipeCategory;
import teamroots.embers.compat.jei.wrapper.AlchemyRecipeWrapper;
import teamroots.embers.compat.jei.wrapper.DawnstoneAnvilWrapper;
import teamroots.embers.compat.jei.wrapper.MeltingRecipeWrapper;
import teamroots.embers.compat.jei.wrapper.MixingRecipeWrapper;
import teamroots.embers.compat.jei.wrapper.StampingRecipeWrapper;
import teamroots.embers.recipe.AlchemyRecipe;
import teamroots.embers.recipe.DawnstoneAnvilRecipe;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.recipe.IWrappableRecipe;
import teamroots.embers.recipe.ItemMeltingRecipe;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@JEIPlugin
public class EmbersJEIPlugin
implements IModPlugin {
    public static IJeiHelpers HELPER;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new StampRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MelterRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MixingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AlchemyRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new DawnstoneAnvilCategory(guiHelper)});
    }

    public void register(IModRegistry reg) {
        HELPER = reg.getJeiHelpers();
        reg.handleRecipes(ItemStampingRecipe.class, StampingRecipeWrapper::new, "embers.stamp");
        reg.handleRecipes(ItemMeltingRecipe.class, MeltingRecipeWrapper::new, "embers.melter");
        reg.handleRecipes(FluidMixingRecipe.class, MixingRecipeWrapper::new, "embers.mixer");
        reg.handleRecipes(AlchemyRecipe.class, AlchemyRecipeWrapper::new, "embers.alchemy");
        reg.handleRecipes(DawnstoneAnvilRecipe.class, DawnstoneAnvilWrapper::new, "embers.dawnstone_anvil");
        reg.addRecipes(RecipeRegistry.stampingRecipes, "embers.stamp");
        reg.addRecipes(RecipeRegistry.meltingRecipes, "embers.melter");
        reg.addRecipes(RecipeRegistry.mixingRecipes, "embers.mixer");
        reg.addRecipes(RecipeRegistry.alchemyRecipes, "embers.alchemy");
        reg.addRecipes(EmbersJEIPlugin.expandRecipes(RecipeRegistry.dawnstoneAnvilRecipes), "embers.dawnstone_anvil");
        reg.addRecipeCatalyst((Object)new ItemStack(RegistryManager.stamper), new String[]{"embers.stamp"});
        reg.addRecipeCatalyst((Object)new ItemStack(RegistryManager.block_furnace), new String[]{"embers.melter"});
        reg.addRecipeCatalyst((Object)new ItemStack(RegistryManager.mixer), new String[]{"embers.mixer"});
        reg.addRecipeCatalyst((Object)new ItemStack(RegistryManager.alchemy_tablet), new String[]{"embers.alchemy"});
        reg.addRecipeCatalyst((Object)new ItemStack(RegistryManager.dawnstone_anvil), new String[]{"embers.dawnstone_anvil"});
    }

    public static List<List<ItemStack>> expandIngredients(Ingredient ingredient) {
        return EmbersJEIPlugin.expandIngredients(Lists.newArrayList((Object[])new Ingredient[]{ingredient}));
    }

    public static List<List<ItemStack>> expandIngredients(List<Ingredient> ingredients) {
        IStackHelper stackHelper = HELPER.getStackHelper();
        return stackHelper.expandRecipeItemStackInputs(ingredients);
    }

    public static List<IWrappableRecipe> expandRecipes(List<? extends IWrappableRecipe> recipes) {
        return recipes.stream().map(IWrappableRecipe::getWrappers).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

