/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@ZenRegister
@ZenClass(value="mods.embers.Mixer")
public class Mixer {
    public static final String NAME = "Mixer";
    public static final String CLASS = "mods.embers.Mixer";

    @ZenMethod
    public static void add(ILiquidStack output, @NotNull ILiquidStack[] inputs) {
        FluidMixingRecipe recipe = new FluidMixingRecipe(CraftTweakerMC.getLiquidStacks((ILiquidStack[])inputs), CraftTweakerMC.getLiquidStack((ILiquidStack)output));
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void remove(ILiquidStack output) {
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CraftTweakerMC.getLiquidStack((ILiquidStack)output)));
    }

    private static List<FluidMixingRecipe> getRecipesByOutput(FluidStack stack) {
        return RecipeRegistry.mixingRecipes.stream().filter(recipe -> recipe.output.isFluidStackIdentical(stack)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static class RemoveByOutput
    implements IAction {
        FluidStack output;

        protected RemoveByOutput(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            RecipeRegistry.mixingRecipes.removeAll(Mixer.getRecipesByOutput(this.output));
        }

        public String describe() {
            return String.format("Removing %s recipes with output: %s", Mixer.NAME, this.output.toString());
        }
    }

    public static class Add
    implements IAction {
        FluidMixingRecipe recipe;

        public Add(FluidMixingRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            RecipeRegistry.mixingRecipes.add(this.recipe);
        }

        public String describe() {
            return String.format("Adding %s recipe: %s", Mixer.NAME, this.recipe.toString());
        }
    }
}

