/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import teamroots.embers.RegistryManager;
import teamroots.embers.api.alchemy.AspectList;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.block.BlockExplosionPedestal;
import teamroots.embers.item.ItemEmberStorage;
import teamroots.embers.item.bauble.ItemAshenAmulet;
import teamroots.embers.item.bauble.ItemDawnstoneMail;
import teamroots.embers.item.bauble.ItemEmberAmulet;
import teamroots.embers.item.bauble.ItemEmberBelt;
import teamroots.embers.item.bauble.ItemEmberBulb;
import teamroots.embers.item.bauble.ItemEmberRing;
import teamroots.embers.item.bauble.ItemExplosionCharm;
import teamroots.embers.item.bauble.ItemNonbelieverAmulet;
import teamroots.embers.recipe.AlchemyRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.research.ResearchBase;
import teamroots.embers.research.ResearchManager;
import teamroots.embers.research.subtypes.ResearchShowItem;
import teamroots.embers.tileentity.TileEntityExplosionPedestal;

public class BaublesIntegration {
    public static Block explosion_pedestal;
    public static Item ember_amulet;
    public static Item ember_belt;
    public static Item ember_ring;
    public static Item mantle_bulb;
    public static Item radiant_crown;
    public static Item rocket_booster;
    public static Item ashen_amulet;
    public static Item glimmer_charm;
    public static Item nonbeliever_amulet;
    public static Item dawnstone_mail;
    public static Item explosion_charm;
    public static Item climbers_belt;
    public static Item crystal_lenses;

    public static ResourceLocation getRL(String s) {
        return new ResourceLocation("embers", s);
    }

    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register(new ShapedOreRecipe(BaublesIntegration.getRL("ember_ring"), new ItemStack(ember_ring, 1), new Object[]{true, new Object[]{"CN ", "N N", " N ", Character.valueOf('C'), RegistryManager.ember_cluster, Character.valueOf('N'), "nuggetDawnstone"}}).setMirrored(true).setRegistryName(BaublesIntegration.getRL("ember_ring")));
        event.getRegistry().register(new ShapedOreRecipe(BaublesIntegration.getRL("ember_amulet"), new ItemStack(ember_amulet, 1), new Object[]{true, new Object[]{" L ", "L L", "NCN", Character.valueOf('C'), RegistryManager.ember_cluster, Character.valueOf('N'), "nuggetDawnstone", Character.valueOf('L'), Items.field_151116_aA}}).setRegistryName(BaublesIntegration.getRL("ember_amulet")));
        event.getRegistry().register(new ShapedOreRecipe(BaublesIntegration.getRL("ember_belt"), new ItemStack(ember_belt, 1), new Object[]{true, new Object[]{"LIL", "L L", "PCP", Character.valueOf('C'), RegistryManager.ember_cluster, Character.valueOf('I'), "ingotDawnstone", Character.valueOf('P'), "plateDawnstone", Character.valueOf('L'), Items.field_151116_aA}}).setRegistryName(BaublesIntegration.getRL("ember_belt")));
        event.getRegistry().register(new ShapedOreRecipe(BaublesIntegration.getRL("ember_bulb"), new ItemStack(mantle_bulb, 1), new Object[]{true, new Object[]{" CI", "GSG", " G ", Character.valueOf('I'), "ingotLead", Character.valueOf('S'), RegistryManager.ember_cluster, Character.valueOf('C'), "plateDawnstone", Character.valueOf('G'), "blockGlass"}}).setMirrored(true).setRegistryName(BaublesIntegration.getRL("ember_bulb")));
        event.getRegistry().register(new ShapedOreRecipe(BaublesIntegration.getRL("ashen_amulet"), new ItemStack(ashen_amulet, 1), new Object[]{true, new Object[]{" L ", "L L", "NCN", Character.valueOf('C'), "dustAsh", Character.valueOf('N'), RegistryManager.archaic_brick, Character.valueOf('L'), Items.field_151116_aA}}).setRegistryName(BaublesIntegration.getRL("ashen_amulet")));
        event.getRegistry().register(new ShapedOreRecipe(BaublesIntegration.getRL("dawnstone_mail"), new ItemStack(dawnstone_mail, 1), new Object[]{true, new Object[]{"P P", "PPP", "PPP", Character.valueOf('P'), "plateDawnstone"}}).setMirrored(true).setRegistryName(BaublesIntegration.getRL("dawnstone_mail")));
        Ingredient leather = Ingredient.func_193367_a((Item)Items.field_151116_aA);
        Ingredient archaicBrick = Ingredient.func_193367_a((Item)RegistryManager.archaic_brick);
        Ingredient eldritchInsignia = Ingredient.func_193367_a((Item)RegistryManager.eldritch_insignia);
        Ingredient archaicCircuit = Ingredient.func_193367_a((Item)RegistryManager.archaic_circuit);
        RecipeRegistry.alchemyRecipes.add(new AlchemyRecipe(new AspectList.AspectRangeList().setRange("iron", 8, 32).setRange("copper", 8, 32), Ingredient.func_193367_a((Item)RegistryManager.ember_cluster), Lists.newArrayList((Object[])new Ingredient[]{archaicBrick, leather, archaicBrick, archaicBrick}), new ItemStack(explosion_charm, 1)));
        RecipeRegistry.alchemyRecipes.add(new AlchemyRecipe(new AspectList.AspectRangeList().setRange("dawnstone", 32, 64).setRange("silver", 32, 64), Ingredient.func_193367_a((Item)ashen_amulet), Lists.newArrayList((Object[])new Ingredient[]{archaicCircuit, archaicBrick, archaicCircuit, eldritchInsignia}), new ItemStack(nonbeliever_amulet, 1)));
        RecipeRegistry.alchemyRecipes.add(new AlchemyRecipe(new AspectList.AspectRangeList().setRange("copper", 16, 24).setRange("silver", 16, 24), Ingredient.func_193367_a((Item)RegistryManager.dust_ember), Lists.newArrayList((Object[])new Ingredient[]{Ingredient.field_193370_a, Ingredient.func_193367_a((Item)explosion_charm), Ingredient.field_193370_a, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(RegistryManager.alchemy_pedestal)})}), new ItemStack(explosion_pedestal, 1)));
    }

    public static void registerAll() {
        explosion_pedestal = new BlockExplosionPedestal(Material.field_151576_e, "explosion_pedestal", true).setIsFullCube(false).setIsOpaqueCube(false).setHarvestProperties("pickaxe", 0).func_149711_c(1.6f);
        RegistryManager.blocks.add(explosion_pedestal);
        ember_ring = new ItemEmberRing("ember_ring", true);
        RegistryManager.items.add(ember_ring);
        ember_belt = new ItemEmberBelt("ember_belt", true);
        RegistryManager.items.add(ember_belt);
        ember_amulet = new ItemEmberAmulet("ember_amulet", true);
        RegistryManager.items.add(ember_amulet);
        mantle_bulb = new ItemEmberBulb();
        RegistryManager.items.add(mantle_bulb);
        dawnstone_mail = new ItemDawnstoneMail("dawnstone_mail", true);
        RegistryManager.items.add(dawnstone_mail);
        ashen_amulet = new ItemAshenAmulet("ashen_amulet", true);
        RegistryManager.items.add(ashen_amulet);
        nonbeliever_amulet = new ItemNonbelieverAmulet("nonbeliever_amulet", true);
        RegistryManager.items.add(nonbeliever_amulet);
        explosion_charm = new ItemExplosionCharm("explosion_charm", true);
        RegistryManager.items.add(explosion_charm);
        GameRegistry.registerTileEntity(TileEntityExplosionPedestal.class, (String)"embers:tile_entity_explosion_pedestal");
    }

    public static void init() {
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerClientSide() {
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemEmberStorage.ColorHandler(), new Item[]{mantle_bulb});
    }

    public static double getEmberCapacityTotal(EntityPlayer player) {
        IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        double amount = 0.0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack bauble = handler.getStackInSlot(i);
            if (!bauble.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) continue;
            IEmberCapability capability = (IEmberCapability)bauble.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            amount += capability.getEmberCapacity();
        }
        return amount;
    }

    public static double getEmberTotal(EntityPlayer player) {
        IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        double amount = 0.0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack bauble = handler.getStackInSlot(i);
            if (!bauble.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) continue;
            IEmberCapability capability = (IEmberCapability)bauble.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            amount += capability.getEmber();
        }
        return amount;
    }

    public static double removeEmber(EntityPlayer player, double amount) {
        IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack bauble = handler.getStackInSlot(i);
            if (!bauble.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) continue;
            IEmberCapability capability = (IEmberCapability)bauble.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            amount -= capability.removeAmount(amount, true);
        }
        return amount;
    }

    public static void initBaublesCategory() {
        ItemStack fullBulb = ((ItemEmberBulb)mantle_bulb).withFill(((ItemEmberBulb)mantle_bulb).getCapacity());
        ResearchManager.cost_reduction = new ResearchShowItem("cost_reduction", new ItemStack(ember_amulet), 5.0, 5.0).addItem(new ResearchShowItem.DisplayItem(new ItemStack(ember_amulet), new ItemStack(ember_belt), new ItemStack(ember_ring)));
        ResearchManager.mantle_bulb = new ResearchBase("mantle_bulb", fullBulb, 7.0, 3.0);
        ResearchManager.explosion_charm = new ResearchBase("explosion_charm", new ItemStack(explosion_charm), 9.0, 2.0);
        ResearchManager.nonbeliever_amulet = new ResearchBase("nonbeliever_amulet", new ItemStack(nonbeliever_amulet), 1.0, 3.0);
        ResearchManager.ashen_amulet = new ResearchBase("ashen_amulet", new ItemStack(ashen_amulet), 4.0, 3.0);
        ResearchManager.dawnstone_mail = new ResearchBase("dawnstone_mail", new ItemStack(dawnstone_mail), 3.0, 7.0);
        ResearchManager.explosion_pedestal = new ResearchBase("explosion_pedestal", new ItemStack(explosion_pedestal), 11.0, 1.0).addAncestor(ResearchManager.explosion_charm);
        ResearchManager.subCategoryBaubles.addResearch(ResearchManager.cost_reduction);
        ResearchManager.subCategoryBaubles.addResearch(ResearchManager.mantle_bulb);
        ResearchManager.subCategoryBaubles.addResearch(ResearchManager.explosion_charm);
        ResearchManager.subCategoryBaubles.addResearch(ResearchManager.nonbeliever_amulet);
        ResearchManager.subCategoryBaubles.addResearch(ResearchManager.ashen_amulet);
        ResearchManager.subCategoryBaubles.addResearch(ResearchManager.dawnstone_mail);
        ResearchManager.subCategoryBaubles.addResearch(ResearchManager.explosion_pedestal);
    }
}

