/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import teamroots.embers.Embers;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.block.BlockBaseGauge;
import teamroots.embers.tileentity.TileEntityEmberGauge;

public class BlockEmberGauge
extends BlockBaseGauge {
    public static final String DIAL_TYPE = "ember";

    public BlockEmberGauge(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    @Override
    protected void getTEData(EnumFacing facing, ArrayList<String> text, TileEntity tileEntity) {
        IEmberCapability handler;
        if (tileEntity.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, facing) && (handler = (IEmberCapability)tileEntity.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing)) != null) {
            text.add(BlockEmberGauge.formatEmber(handler.getEmber(), handler.getEmberCapacity()));
        }
    }

    public static String formatEmber(double ember, double emberCapacity) {
        DecimalFormat emberFormat = Embers.proxy.getDecimalFormat("embers.decimal_format.ember");
        return I18n.func_135052_a((String)"embers.tooltip.emberdial.ember", (Object[])new Object[]{emberFormat.format(ember), emberFormat.format(emberCapacity)});
    }

    @Override
    public String getDialType() {
        return DIAL_TYPE;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityEmberGauge();
    }
}

