/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.IRSAPI;
import com.raoulvdberge.refinedstorage.api.RSAPIInject;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternRenderHandler;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementList;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementRegistry;
import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElementRegistry;
import com.raoulvdberge.refinedstorage.api.autocrafting.registry.ICraftingTaskRegistry;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingRequestInfo;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.wireless.IWirelessGridRegistry;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeRegistry;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandlerRegistry;
import com.raoulvdberge.refinedstorage.api.storage.StorageType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskManager;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskRegistry;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskSync;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IExternalStorageProvider;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.IComparer;
import com.raoulvdberge.refinedstorage.api.util.IOneSixMigrationHelper;
import com.raoulvdberge.refinedstorage.api.util.IQuantityFormatter;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingRequestInfo;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementList;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementRegistry;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementRegistry;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.registry.CraftingTaskRegistry;
import com.raoulvdberge.refinedstorage.apiimpl.network.NetworkNodeManager;
import com.raoulvdberge.refinedstorage.apiimpl.network.NetworkNodeRegistry;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.wireless.WirelessGridRegistry;
import com.raoulvdberge.refinedstorage.apiimpl.network.readerwriter.ReaderWriterChannel;
import com.raoulvdberge.refinedstorage.apiimpl.network.readerwriter.ReaderWriterHandlerRegistry;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskFluid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskItem;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskManager;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskRegistry;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskSync;
import com.raoulvdberge.refinedstorage.apiimpl.util.Comparer;
import com.raoulvdberge.refinedstorage.apiimpl.util.OneSixMigrationHelper;
import com.raoulvdberge.refinedstorage.apiimpl.util.QuantityFormatter;
import com.raoulvdberge.refinedstorage.apiimpl.util.StackListFluid;
import com.raoulvdberge.refinedstorage.apiimpl.util.StackListItem;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class API
implements IRSAPI {
    private static final IRSAPI INSTANCE = new API();
    private IComparer comparer = new Comparer();
    private IQuantityFormatter quantityFormatter = new QuantityFormatter();
    private INetworkNodeRegistry networkNodeRegistry = new NetworkNodeRegistry();
    private ICraftingTaskRegistry craftingTaskRegistry = new CraftingTaskRegistry();
    private ICraftingMonitorElementRegistry craftingMonitorElementRegistry = new CraftingMonitorElementRegistry();
    private ICraftingPreviewElementRegistry craftingPreviewElementRegistry = new CraftingPreviewElementRegistry();
    private IReaderWriterHandlerRegistry readerWriterHandlerRegistry = new ReaderWriterHandlerRegistry();
    private IWirelessGridRegistry gridRegistry = new WirelessGridRegistry();
    private IStorageDiskRegistry storageDiskRegistry = new StorageDiskRegistry();
    private IStorageDiskSync storageDiskSync = new StorageDiskSync();
    private IOneSixMigrationHelper oneSixMigrationHelper = new OneSixMigrationHelper();
    private Map<StorageType, TreeSet<IExternalStorageProvider>> externalStorageProviders = new HashMap<StorageType, TreeSet<IExternalStorageProvider>>();
    private List<ICraftingPatternRenderHandler> patternRenderHandlers = new LinkedList<ICraftingPatternRenderHandler>();

    public static IRSAPI instance() {
        return INSTANCE;
    }

    public static void deliver(ASMDataTable asmDataTable) {
        String annotationClassName = RSAPIInject.class.getCanonicalName();
        Set asmDataSet = asmDataTable.getAll(annotationClassName);
        for (ASMDataTable.ASMData asmData : asmDataSet) {
            try {
                Class<?> clazz = Class.forName(asmData.getClassName());
                Field field = clazz.getField(asmData.getObjectName());
                if (field.getType() != IRSAPI.class) continue;
                field.set(null, INSTANCE);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Failed to set: {}" + asmData.getClassName() + "." + asmData.getObjectName(), e);
            }
        }
    }

    @Override
    @Nonnull
    public IComparer getComparer() {
        return this.comparer;
    }

    @Override
    @Nonnull
    public IQuantityFormatter getQuantityFormatter() {
        return this.quantityFormatter;
    }

    @Override
    @Nonnull
    public INetworkNodeRegistry getNetworkNodeRegistry() {
        return this.networkNodeRegistry;
    }

    @Override
    public INetworkNodeManager getNetworkNodeManager(World world) {
        if (world.field_72995_K) {
            throw new IllegalArgumentException("Attempting to access network node manager on the client");
        }
        MapStorage storage = world.getPerWorldStorage();
        NetworkNodeManager instance = (NetworkNodeManager)storage.func_75742_a(NetworkNodeManager.class, "refinedstorage_nodes");
        if (instance == null) {
            instance = new NetworkNodeManager("refinedstorage_nodes");
            storage.func_75745_a("refinedstorage_nodes", (WorldSavedData)instance);
        } else {
            instance.tryReadNodes(world);
        }
        return instance;
    }

    @Override
    @Nonnull
    public ICraftingTaskRegistry getCraftingTaskRegistry() {
        return this.craftingTaskRegistry;
    }

    @Override
    @Nonnull
    public ICraftingMonitorElementRegistry getCraftingMonitorElementRegistry() {
        return this.craftingMonitorElementRegistry;
    }

    @Override
    @Nonnull
    public ICraftingPreviewElementRegistry getCraftingPreviewElementRegistry() {
        return this.craftingPreviewElementRegistry;
    }

    @Override
    @Nonnull
    public IReaderWriterHandlerRegistry getReaderWriterHandlerRegistry() {
        return this.readerWriterHandlerRegistry;
    }

    @Override
    @Nonnull
    public IReaderWriterChannel createReaderWriterChannel(String name, INetwork network) {
        return new ReaderWriterChannel(name, network);
    }

    @Override
    @Nonnull
    public IStackList<ItemStack> createItemStackList() {
        return new StackListItem();
    }

    @Override
    @Nonnull
    public IStackList<FluidStack> createFluidStackList() {
        return new StackListFluid();
    }

    @Override
    @Nonnull
    public ICraftingMonitorElementList createCraftingMonitorElementList() {
        return new CraftingMonitorElementList();
    }

    @Override
    @Nonnull
    public IWirelessGridRegistry getWirelessGridRegistry() {
        return this.gridRegistry;
    }

    @Override
    @Nonnull
    public IStorageDiskRegistry getStorageDiskRegistry() {
        return this.storageDiskRegistry;
    }

    @Override
    @Nonnull
    public IStorageDiskManager getStorageDiskManager(World world) {
        if (world.field_72995_K) {
            throw new IllegalArgumentException("Attempting to access storage disk manager on the client");
        }
        MapStorage storage = world.func_175693_T();
        StorageDiskManager instance = (StorageDiskManager)storage.func_75742_a(StorageDiskManager.class, "refinedstorage_disks");
        if (instance == null) {
            instance = new StorageDiskManager("refinedstorage_disks");
            storage.func_75745_a("refinedstorage_disks", (WorldSavedData)instance);
        } else {
            instance.tryReadDisks(world);
        }
        return instance;
    }

    @Override
    @Nonnull
    public IStorageDiskSync getStorageDiskSync() {
        return this.storageDiskSync;
    }

    @Override
    public void addExternalStorageProvider(StorageType type, IExternalStorageProvider provider) {
        this.externalStorageProviders.computeIfAbsent(type, k -> new TreeSet((a, b) -> Integer.compare(b.getPriority(), a.getPriority()))).add(provider);
    }

    @Override
    public Set<IExternalStorageProvider> getExternalStorageProviders(StorageType type) {
        TreeSet<IExternalStorageProvider> providers = this.externalStorageProviders.get((Object)type);
        return providers == null ? Collections.emptySet() : providers;
    }

    @Override
    @Nonnull
    public IStorageDisk<ItemStack> createDefaultItemDisk(World world, int capacity) {
        return new StorageDiskItem(world, capacity);
    }

    @Override
    @Nonnull
    public IStorageDisk<FluidStack> createDefaultFluidDisk(World world, int capacity) {
        return new StorageDiskFluid(world, capacity);
    }

    @Override
    public ICraftingRequestInfo createCraftingRequestInfo(ItemStack stack) {
        return new CraftingRequestInfo(stack);
    }

    @Override
    public ICraftingRequestInfo createCraftingRequestInfo(FluidStack stack) {
        return new CraftingRequestInfo(stack);
    }

    @Override
    public ICraftingRequestInfo createCraftingRequestInfo(NBTTagCompound tag) throws CraftingTaskReadException {
        return new CraftingRequestInfo(tag);
    }

    @Override
    @Nonnull
    public IOneSixMigrationHelper getOneSixMigrationHelper() {
        return this.oneSixMigrationHelper;
    }

    @Override
    public void addPatternRenderHandler(ICraftingPatternRenderHandler renderHandler) {
        this.patternRenderHandlers.add(renderHandler);
    }

    @Override
    public List<ICraftingPatternRenderHandler> getPatternRenderHandlers() {
        return this.patternRenderHandlers;
    }

    @Override
    public void openWirelessGrid(EntityPlayer player, EnumHand hand, int networkDimension, int id) {
        player.openGui((Object)RS.INSTANCE, 12, player.func_130014_f_(), hand.ordinal(), networkDimension, id);
    }

    @Override
    public void discoverNode(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            INetworkNodeProxy nodeProxy;
            Object node;
            TileEntity tile = world.func_175625_s(pos.func_177972_a(facing));
            if (tile == null || !tile.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, facing.func_176734_d()) || (node = (nodeProxy = (INetworkNodeProxy)tile.getCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, facing.func_176734_d())).getNode()).getNetwork() == null) continue;
            node.getNetwork().getNodeGraph().invalidate(Action.PERFORM, node.getNetwork().world(), node.getNetwork().getPosition());
            return;
        }
    }

    @Override
    public int getItemStackHashCode(ItemStack stack) {
        int result = stack.func_77973_b().hashCode();
        result = 31 * result + (stack.func_77952_i() + 1);
        if (stack.func_77942_o()) {
            result = this.getHashCode(stack.func_77978_p(), result);
        }
        return result;
    }

    private int getHashCode(NBTBase tag, int result) {
        result = tag instanceof NBTTagCompound ? this.getHashCode((NBTTagCompound)tag, result) : (tag instanceof NBTTagList ? this.getHashCode((NBTTagList)tag, result) : 31 * result + tag.hashCode());
        return result;
    }

    private int getHashCode(NBTTagCompound tag, int result) {
        for (String key : tag.func_150296_c()) {
            result = 31 * result + key.hashCode();
            result = this.getHashCode(tag.func_74781_a(key), result);
        }
        return result;
    }

    private int getHashCode(NBTTagList tag, int result) {
        for (int i = 0; i < tag.func_74745_c(); ++i) {
            result = this.getHashCode(tag.func_179238_g(i), result);
        }
        return result;
    }

    @Override
    public int getFluidStackHashCode(FluidStack stack) {
        int result = stack.getFluid().hashCode();
        if (stack.tag != null) {
            result = this.getHashCode(stack.tag, result);
        }
        return result;
    }

    @Override
    public int getNetworkNodeHashCode(INetworkNode node) {
        int result = node.getPos().hashCode();
        result = 31 * result + node.getWorld().field_73011_w.getDimension();
        return result;
    }

    @Override
    public boolean isNetworkNodeEqual(INetworkNode left, Object right) {
        if (!(right instanceof INetworkNode)) {
            return false;
        }
        if (left == right) {
            return true;
        }
        INetworkNode rightNode = (INetworkNode)right;
        if (left.getWorld().field_73011_w.getDimension() != rightNode.getWorld().field_73011_w.getDimension()) {
            return false;
        }
        return left.getPos().equals((Object)rightNode.getPos());
    }
}

