/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.util;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import malte0811.industrialwires.compat.Compat;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiblockTemplateManual
implements MultiblockHandler.IMultiblock {
    public static final TemplateManager RES_LOC_TEMPLATE_MANAGER = new TemplateManager("/dev/null/should not exist", DataFixesManager.func_188279_a());
    private final ResourceLocation loc;
    @Nullable
    private Template template;
    @Nullable
    private IngredientStack[] mats = null;
    @Nullable
    private ItemStack[][][] fakeStructure = null;
    @Nullable
    private Map<ItemStack, IBlockState> realStructure = null;

    public MultiblockTemplateManual(ResourceLocation loc) {
        this.loc = loc;
    }

    private void updateTemplate() {
        if (this.template == null) {
            this.template = RES_LOC_TEMPLATE_MANAGER.func_186237_a(null, this.loc);
            BlockPos size = this.template.func_186259_a();
            this.fakeStructure = new ItemStack[size.func_177956_o()][size.func_177958_n()][size.func_177952_p()];
            for (int x = 0; x < size.func_177958_n(); ++x) {
                for (int y = 0; y < size.func_177956_o(); ++y) {
                    for (int z = 0; z < size.func_177952_p(); ++z) {
                        this.fakeStructure[y][x][z] = ItemStack.field_190927_a;
                    }
                }
            }
            this.realStructure = new IdentityHashMap<ItemStack, IBlockState>();
            List blocks = this.template.field_186270_a;
            HashSet<ItemStack> matsSet = new HashSet<ItemStack>();
            for (Template.BlockInfo info : blocks) {
                ItemStack here = Compat.stackFromInfo.apply(new ItemStack(info.field_186243_b.func_177230_c(), 1, info.field_186243_b.func_177230_c().func_176201_c(info.field_186243_b)), info);
                if (here.func_190926_b()) continue;
                this.fakeStructure[info.field_186242_a.func_177956_o()][info.field_186242_a.func_177958_n()][info.field_186242_a.func_177952_p()] = here;
                this.realStructure.put(here, info.field_186243_b);
                Optional<ItemStack> match = matsSet.stream().filter(s -> ItemStack.func_179545_c((ItemStack)here, (ItemStack)s)).findAny();
                if (match.isPresent()) {
                    match.get().func_190917_f(1);
                    continue;
                }
                matsSet.add(here);
            }
            this.mats = (IngredientStack[])matsSet.stream().map(IngredientStack::new).toArray(IngredientStack[]::new);
        }
    }

    public String getUniqueName() {
        return this.loc.toString();
    }

    public boolean isBlockTrigger(IBlockState state) {
        return false;
    }

    public boolean createStructure(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        return false;
    }

    public ItemStack[][][] getStructureManual() {
        this.updateTemplate();
        return this.fakeStructure;
    }

    public IBlockState getBlockstateFromStack(int index, ItemStack stack) {
        this.updateTemplate();
        assert (this.realStructure != null);
        return this.realStructure.getOrDefault(stack, Blocks.field_150350_a.func_176223_P());
    }

    public IngredientStack[] getTotalMaterials() {
        this.updateTemplate();
        return this.mats;
    }

    public boolean overwriteBlockRender(ItemStack stack, int iterator) {
        return false;
    }

    public float getManualScale() {
        return 12.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderFormedStructure() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderFormedStructure() {
    }
}

