/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.mech_mb;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration0;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IEObjects;
import malte0811.industrialwires.blocks.converter.MechanicalMBBlockType;
import malte0811.industrialwires.mech_mb.MechEnergy;
import malte0811.industrialwires.mech_mb.MechMBPart;
import malte0811.industrialwires.util.LocalSidedWorld;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.oredict.OreDictionary;

public class MechPartSpeedometer
extends MechMBPart
implements IEBlockInterfaces.IRedstoneOutput {
    private double speedFor15RS = 40.0;
    private int currentOutputLin = -1;
    private int currentOutputLog = -1;
    private double logFactor = 15.0 / Math.log(this.speedFor15RS + 1.0);
    @Nullable
    private MechEnergy energy;
    private static ItemStack voltMeter = ItemStack.field_190927_a;
    private static DecimalFormat format = new DecimalFormat("###.000");

    public MechPartSpeedometer() {
        if (this.areBlocksRegistered()) {
            this.original.put(BlockPos.field_177992_a, IEObjects.blockMetalDecoration0.func_176203_a(BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta()));
        }
        this.energy = null;
    }

    @Override
    public void createMEnergy(MechEnergy e) {
    }

    @Override
    public double requestMEnergy(MechEnergy e) {
        this.energy = e;
        return 0.0;
    }

    @Override
    public void insertMEnergy(double added) {
        this.update(false);
    }

    private void update(boolean changedMax) {
        if (changedMax) {
            this.logFactor = 15.0 / Math.log(this.speedFor15RS + 1.0);
        }
        if (this.energy != null) {
            int newLin = this.roundHysteresis(this.currentOutputLin, 15.0 * this.energy.getSpeed() / this.speedFor15RS);
            int newLog = this.roundHysteresis(this.currentOutputLog, Math.log(this.energy.getSpeed() + 1.0) * this.logFactor);
            if (newLin != this.currentOutputLin || newLog != this.currentOutputLog) {
                this.currentOutputLin = newLin;
                this.currentOutputLog = newLog;
                this.world.markForUpdate(BlockPos.field_177992_a);
            }
        }
    }

    private int roundHysteresis(int old, double newExact) {
        double mod = newExact % 1.0;
        double THRESHOLD = 0.1;
        int floor = (int)Math.floor(newExact);
        if (floor == old) {
            return old;
        }
        if ((double)old < newExact && mod > 0.1) {
            return floor;
        }
        if ((double)old > newExact && mod < 0.9) {
            return floor;
        }
        return old;
    }

    @Override
    public double getInertia() {
        return 60.0;
    }

    @Override
    public double getMaxSpeed() {
        return 2.0 * this.speedFor15RS;
    }

    @Override
    public void writeToNBT(NBTTagCompound out) {
        out.func_74780_a("maxSpeed", this.speedFor15RS);
    }

    @Override
    public void readFromNBT(NBTTagCompound in) {
        this.speedFor15RS = in.func_74769_h("maxSpeed");
        this.update(true);
    }

    @Override
    public ResourceLocation getRotatingBaseModel() {
        return new ResourceLocation("industrialwires", "block/mech_mb/shaft.obj");
    }

    @Override
    public boolean canForm(LocalSidedWorld w) {
        IBlockState state = w.getBlockState(BlockPos.field_177992_a);
        return state.func_177230_c() == IEObjects.blockMetalDecoration0 && state.func_177229_b((IProperty)IEObjects.blockMetalDecoration0.property) == BlockTypes_MetalDecoration0.RS_ENGINEERING;
    }

    @Override
    public short getFormPattern(int offset) {
        return 16;
    }

    @Override
    public void breakOnFailure(MechEnergy energy) {
        this.world.setBlockState(BlockPos.field_177992_a, Blocks.field_150350_a.func_176223_P());
    }

    @Override
    public MechanicalMBBlockType getType() {
        return MechanicalMBBlockType.SPEEDOMETER;
    }

    @Override
    public int interact(@Nonnull EnumFacing side, @Nonnull Vec3i offset, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull ItemStack heldItem) {
        if (voltMeter.func_190926_b()) {
            voltMeter = new ItemStack(IEObjects.itemTool, 1, 2);
        }
        if (Utils.isHammer((ItemStack)heldItem)) {
            if (!this.world.isRemote) {
                if (player.func_70093_af()) {
                    if (this.speedFor15RS > 1.0) {
                        this.speedFor15RS -= 1.0;
                    }
                } else {
                    this.speedFor15RS += 1.0;
                }
                ChatUtils.sendServerNoSpamMessages((EntityPlayer)player, (ITextComponent[])new ITextComponent[]{new TextComponentTranslation("industrialwires.chat.maxSpeed", new Object[]{this.speedFor15RS})});
                this.update(true);
            }
            return 0;
        }
        if (OreDictionary.itemMatches((ItemStack)heldItem, (ItemStack)voltMeter, (boolean)false)) {
            if (!this.world.isRemote) {
                double speed = this.energy != null ? this.energy.getSpeed() : 0.0;
                ChatUtils.sendServerNoSpamMessages((EntityPlayer)player, (ITextComponent[])new ITextComponent[]{new TextComponentTranslation("industrialwires.chat.currSpeed", new Object[]{format.format(speed), format.format(speed * 60.0 / (Math.PI * 2))})});
            }
            return 0;
        }
        return -1;
    }

    public int getStrongRSOutput(@Nonnull IBlockState state, @Nonnull EnumFacing side) {
        if (side.func_176740_k() == EnumFacing.Axis.X) {
            if (side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                return this.currentOutputLog;
            }
            return this.currentOutputLin;
        }
        return 0;
    }

    public boolean canConnectRedstone(@Nonnull IBlockState state, @Nonnull EnumFacing side) {
        return side.func_176740_k() == EnumFacing.Axis.X;
    }

    @Override
    public AxisAlignedBB getBoundingBox(BlockPos offsetPart) {
        return new AxisAlignedBB(0.0, 0.1875, 0.0, 1.0, 0.8125, 1.0);
    }
}

