/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.mech_mb;

import net.minecraft.util.math.MathHelper;

public final class MechEnergy {
    private double speed = 0.0;
    public boolean invalid = false;
    public final double weight;
    private static final int TICKS_FOR_ADJUSTMENT = 30;
    private double targetSpeed;
    private double oldSpeed = -1.0;
    private int ticksTillReached = -1;

    public MechEnergy(double weight, double speed) {
        this.weight = weight;
        this.speed = speed;
    }

    public double getEnergy() {
        return 0.5 * this.weight * this.speed * this.speed;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void addEnergy(double energy) {
        if (energy <= 0.0) {
            return;
        }
        double targetEnergy = this.getEnergy() + energy;
        this.speed = Math.sqrt(2.0 * targetEnergy / this.weight);
    }

    public void extractEnergy(double energy) {
        if (energy <= 0.0) {
            return;
        }
        double oldEnergy = this.getEnergy();
        energy = Math.min(energy, oldEnergy);
        this.speed = Math.sqrt(2.0 * (oldEnergy - energy) / this.weight);
    }

    public void decaySpeed(double decay) {
        this.speed *= decay;
        if (this.speed < 0.01) {
            this.speed = 0.0;
        }
    }

    public void setTargetSpeed(double speed) {
        this.targetSpeed = speed;
        this.oldSpeed = this.getSpeed();
        this.ticksTillReached = 30;
    }

    public boolean clientUpdate() {
        if (this.ticksTillReached >= 0) {
            this.speed = ((double)(30 - this.ticksTillReached) * this.targetSpeed + (double)this.ticksTillReached * this.oldSpeed) / 30.0;
            --this.ticksTillReached;
            return true;
        }
        this.oldSpeed = -1.0;
        return false;
    }

    public float getVolumeSlow() {
        return (1.0f - this.getSoundLambda()) * this.getTotalVolume();
    }

    public float getVolumeFast() {
        return this.getSoundLambda() * this.getTotalVolume();
    }

    public float getPitch() {
        return (float)Math.min(0.3 * Math.sqrt(this.getSpeedForSound()), 1.25);
    }

    private float getTotalVolume() {
        if (this.invalid) {
            return 0.0f;
        }
        float ret = (float)(this.weight / 20000.0 * Math.tanh(this.getSpeedForSound() / 30.0));
        ret = Math.min(ret, 1.0f);
        return ret;
    }

    private float getSoundLambda() {
        return (float)MathHelper.func_151237_a((double)(this.getSpeedForSound() / 20.0 - 0.5), (double)0.0, (double)1.0);
    }

    private double getSpeedForSound() {
        double MIN_SPEED = 5.0;
        return this.getSpeed() - 5.0;
    }
}

