/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.entities;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityBrokenPart
extends Entity {
    public static final DataSerializer<ResourceLocation> RES_LOC_SERIALIZER = new DataSerializer<ResourceLocation>(){

        public void write(@Nonnull PacketBuffer buf, @Nonnull ResourceLocation value) {
            buf.func_180714_a(value.func_110624_b());
            buf.func_180714_a(value.func_110623_a());
        }

        @Nonnull
        public ResourceLocation read(@Nonnull PacketBuffer buf) throws IOException {
            String domain = buf.func_150789_c(128);
            return new ResourceLocation(domain, buf.func_150789_c(1024));
        }

        @Nonnull
        public DataParameter<ResourceLocation> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        @Nonnull
        public ResourceLocation copyValue(@Nonnull ResourceLocation value) {
            return new ResourceLocation(value.func_110624_b(), value.func_110623_a());
        }
    };
    public static DataParameter<ResourceLocation> MARKER_TEXTURE;
    private static final double HARDNESS_MAX = 15.0;
    private static final double DESPAWN_DELAY_GROUND = 400.0;
    private static final double DESPAWN_DELAY_AIR = 1200.0;
    private static final ResourceLocation DEFAULT_TEXTURE;
    public ResourceLocation texture = DEFAULT_TEXTURE;
    private int timeUnmoved = 0;
    private int ticksOnGround;
    private int ticksInAir;

    public EntityBrokenPart(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70156_m = true;
    }

    public EntityBrokenPart(World worldIn, ResourceLocation texture) {
        this(worldIn);
        this.texture = texture;
    }

    public void func_70030_z() {
        if (this.field_70148_d && !this.field_70170_p.field_72995_K && this.texture != null) {
            this.field_70180_af.func_187227_b(MARKER_TEXTURE, (Object)this.texture);
        }
        super.func_70030_z();
        if (this.field_70170_p.field_72995_K && DEFAULT_TEXTURE.equals((Object)this.texture)) {
            this.texture = (ResourceLocation)this.field_70180_af.func_187225_a(MARKER_TEXTURE);
        }
    }

    public void func_70071_h_() {
        float movementDecay;
        this.func_70030_z();
        if (this.field_70122_E) {
            ++this.ticksOnGround;
            if ((double)this.ticksOnGround >= 400.0) {
                this.func_70106_y();
            }
        } else {
            ++this.ticksInAir;
            if ((double)this.ticksInAir >= 1200.0) {
                this.func_70106_y();
                return;
            }
            Vec3d currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d nextPos = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult mop = this.field_70170_p.func_147447_a(currentPos, nextPos, false, true, false);
            currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            nextPos = mop != null ? new Vec3d(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c) : new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (mop == null || mop.field_72308_g == null) {
                Entity entity = null;
                List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), e -> true);
                double d0 = 0.0;
                for (Entity e2 : list) {
                    double d1;
                    if (!e2.func_70067_L()) continue;
                    float f = 0.3f;
                    AxisAlignedBB axisalignedbb = e2.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
                    RayTraceResult movingobjectposition1 = axisalignedbb.func_72327_a(currentPos, nextPos);
                    if (movingobjectposition1 == null || !((d1 = currentPos.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                    entity = e2;
                    d0 = d1;
                }
                if (entity != null) {
                    mop = new RayTraceResult(entity);
                }
            }
            if (mop != null && mop.field_72308_g != null) {
                this.attackEntity(mop.field_72308_g);
            }
            float motion = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, motion) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        }
        float f = movementDecay = this.field_70122_E ? 0.5f : 0.99f;
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            movementDecay *= 0.8f;
        }
        this.field_70159_w *= (double)movementDecay;
        this.field_70181_x *= (double)movementDecay;
        this.field_70179_y *= (double)movementDecay;
        this.field_70181_x -= 0.05;
        this.breakBlocks(this.getSpeedSq());
        this.func_145775_I();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public void breakBlocks(double speedSq) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        axisalignedbb = axisalignedbb.func_72314_b(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        BlockPos.PooledMutableBlockPos min = BlockPos.PooledMutableBlockPos.func_185345_c((double)(axisalignedbb.field_72340_a - 0.1), (double)(axisalignedbb.field_72338_b - 0.1), (double)(axisalignedbb.field_72339_c - 0.1));
        BlockPos.PooledMutableBlockPos max = BlockPos.PooledMutableBlockPos.func_185345_c((double)(axisalignedbb.field_72336_d + 0.1), (double)(axisalignedbb.field_72337_e + 0.1), (double)(axisalignedbb.field_72334_f + 0.1));
        BlockPos.PooledMutableBlockPos iter = BlockPos.PooledMutableBlockPos.func_185346_s();
        double speed = -1.0;
        if (this.field_70170_p.func_175707_a((BlockPos)min, (BlockPos)max)) {
            for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
                for (int y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
                    for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                        iter.func_181079_c(x, y, z);
                        if (this.field_70170_p.func_175623_d((BlockPos)iter)) continue;
                        IBlockState state = this.field_70170_p.func_180495_p((BlockPos)iter);
                        float hardness = state.func_185887_b(this.field_70170_p, (BlockPos)iter);
                        if (speed < 0.0) {
                            speed = Math.sqrt(speedSq);
                        }
                        if (!(hardness > 0.0f) || !((double)hardness < 15.0 * speed)) continue;
                        this.field_70170_p.func_175698_g((BlockPos)iter);
                        double factor = (15.0 * speed - (double)hardness) / (15.0 * speed);
                        this.field_70159_w *= factor;
                        this.field_70181_x *= factor;
                        this.field_70179_y *= factor;
                        speed *= factor;
                    }
                }
            }
        }
        min.func_185344_t();
        max.func_185344_t();
        iter.func_185344_t();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(MARKER_TEXTURE, (Object)DEFAULT_TEXTURE);
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        this.texture = new ResourceLocation(compound.func_74779_i("texture"));
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        compound.func_74778_a("texture", this.texture.toString());
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    private void attackEntity(Entity e) {
        e.func_70097_a(DamageSource.field_82729_p, 20.0f * this.getSpeedSq());
    }

    private float getSpeedSq() {
        return (float)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    static {
        DEFAULT_TEXTURE = new ResourceLocation("blocks/stone");
    }
}

