/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.client.multiblock_io_model;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.blocks.IWProperties;
import malte0811.industrialwires.client.ClientUtilsIW;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.util.MBSideConfig;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class BakedMBIOModel
implements IBakedModel {
    private static final MBSideConfig NULL_CONFIG = new MBSideConfig((List<MBSideConfig.BlockFace>)ImmutableList.of((Object)new MBSideConfig.BlockFace(new BlockPos(0, 2, 0), EnumFacing.DOWN)));
    private static final Matrix4 ID = new Matrix4();
    static final ResourceLocation IO_LOC = new ResourceLocation("industrialwires", "blocks/io");
    static TextureAtlasSprite IO_TEX = null;
    private final IBakedModel base;
    private final TRSRTransformation transform;
    private final Cache<MBSideConfig, List<BakedQuad>> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(100L).build();
    private static final Vector3f[] NORMALS = new Vector3f[6];
    private static final Vector3f[][] VERTICES = new Vector3f[6][4];

    BakedMBIOModel(IBakedModel base, IModelState transform) {
        this.base = base;
        this.transform = TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform.apply(Optional.empty()).orElse(TRSRTransformation.identity()));
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ImmutableList ret;
        MBSideConfig tmpConfig;
        if (side != null) {
            return ImmutableList.of();
        }
        MBSideConfig config = NULL_CONFIG;
        if (state instanceof IExtendedBlockState && (tmpConfig = (MBSideConfig)((IExtendedBlockState)state).getValue(IWProperties.MB_SIDES)) != null) {
            config = tmpConfig;
        }
        if ((ret = (ImmutableList)this.cache.getIfPresent((Object)config)) == null) {
            if (IO_TEX == null) {
                IO_TEX = Minecraft.func_71410_x().func_147117_R().func_110572_b(IO_LOC.toString());
            }
            Matrix4 mat = new Matrix4(this.transform.getMatrix());
            ret = new ArrayList(this.base.func_188616_a(state, side, rand));
            for (Map.Entry<MBSideConfig.BlockFace, IEEnums.SideConfig> f : config.sides.entrySet()) {
                if (f.getKey().face == null) continue;
                Vec3d transformedPos = mat.apply(new Vec3d((Vec3i)f.getKey().offset));
                EnumFacing transformedFace = this.transform.rotate(f.getKey().face);
                Vector3f[] verts = this.getVerticesFromFace(transformedPos, transformedFace);
                RawQuad q = new RawQuad(verts[0], verts[1], verts[2], verts[3], transformedFace, IO_TEX, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, this.getNormal(transformedFace), this.getUVsForConfig(f.getValue()));
                ret.add(ClientUtilsIW.bakeQuad(q, ID, ID));
            }
            ret = ImmutableList.copyOf(ret);
            this.cache.put((Object)config.copy(), (Object)ret);
        }
        return ret;
    }

    private static Vector3f vecFromArray(float[] in) {
        return new Vector3f(in[0], in[1], in[2]);
    }

    private Vector3f[] getVerticesFromFace(Vec3d p, EnumFacing f) {
        Vector3f[] orig = VERTICES[f.ordinal()];
        Vector3f[] ret = new Vector3f[4];
        Vector3f offset = new Vector3f((float)p.field_72450_a, (float)p.field_72448_b, (float)p.field_72449_c);
        for (int i = 0; i < 4; ++i) {
            ret[i] = Vector3f.add((Vector3f)orig[i], (Vector3f)offset, null);
        }
        return ret;
    }

    private float[] getUVsForConfig(IEEnums.SideConfig sc) {
        float u = sc.ordinal() / 2 * 8;
        float v = sc.ordinal() % 2 * 8;
        return new float[]{u, v, u + 8.0f, v + 8.0f};
    }

    private Vector3f getNormal(EnumFacing face) {
        return NORMALS[face.ordinal()];
    }

    public boolean func_177555_b() {
        return this.base.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.base.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.base.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.base.func_177554_e();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.base.func_188617_f();
    }

    public void clearCache() {
        this.cache.invalidateAll();
    }

    static {
        float innerSize = 0.5f;
        float offsetInner = 0.75f;
        float[] vec = new float[3];
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            EnumFacing f = EnumFacing.field_82609_l[i];
            BakedMBIOModel.NORMALS[i] = new Vector3f((float)f.func_82601_c(), (float)f.func_96559_d(), (float)f.func_82599_e());
            int axis = f.func_176740_k().ordinal();
            vec[axis] = f.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 1.001f : -0.001f;
            float x1 = f.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 0.75f : 0.25f;
            for (int j = 0; j < 4; ++j) {
                vec[(axis + 1) % 3] = 0 < j && j < 3 ? x1 : 1.0f - x1;
                vec[(axis + 2) % 3] = j < 2 ? 0.25f : 0.75f;
                BakedMBIOModel.VERTICES[i][j] = BakedMBIOModel.vecFromArray(vec);
            }
        }
    }
}

