/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.wire;

import blusunrize.immersiveengineering.api.IEProperties;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IWConfig;
import malte0811.industrialwires.blocks.BlockIWBase;
import malte0811.industrialwires.blocks.IMetaEnum;
import malte0811.industrialwires.blocks.wire.BlockTypes_IC2_Connector;
import malte0811.industrialwires.blocks.wire.TileEntityIC2ConnectorCopper;
import malte0811.industrialwires.blocks.wire.TileEntityIC2ConnectorGlass;
import malte0811.industrialwires.blocks.wire.TileEntityIC2ConnectorGold;
import malte0811.industrialwires.blocks.wire.TileEntityIC2ConnectorHV;
import malte0811.industrialwires.blocks.wire.TileEntityIC2ConnectorTin;
import malte0811.industrialwires.util.ConversionUtil;
import malte0811.industrialwires.wires.MixedWireType;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIC2Connector
extends BlockIWBase
implements IMetaEnum {
    public static final PropertyEnum<BlockTypes_IC2_Connector> TYPE = PropertyEnum.func_177709_a((String)"type", BlockTypes_IC2_Connector.class);
    public static final String NAME = "ic2_connector";

    public BlockIC2Connector() {
        super(Material.field_151573_f, NAME);
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
        this.field_149786_r = 0;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityIC2ConnectorTin connector;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityIC2ConnectorTin && world.func_175623_d(pos.func_177972_a((connector = (TileEntityIC2ConnectorTin)te).getFacing()))) {
            this.func_176226_b(connector.func_145831_w(), pos, world.func_180495_p(pos), 0);
            connector.func_145831_w().func_175698_g(pos);
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < TYPE.func_177700_c().size(); ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        BlockStateContainer base = super.func_180661_e();
        IUnlistedProperty[] unlisted = base instanceof ExtendedBlockState ? ((ExtendedBlockState)base).getUnlistedProperties().toArray(new IUnlistedProperty[0]) : new IUnlistedProperty[]{};
        unlisted = Arrays.copyOf(unlisted, unlisted.length + 1);
        unlisted[unlisted.length - 1] = IEProperties.CONNECTIONS;
        return new ExtendedBlockState((Block)this, base.func_177623_d().toArray(new IProperty[0]), unlisted);
    }

    protected IProperty<?>[] getProperties() {
        return new IProperty[]{TYPE, IEProperties.FACING_ALL};
    }

    @Override
    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = super.func_176221_a(state, worldIn, pos);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityIC2ConnectorTin) {
            state.func_177226_a((IProperty)IEProperties.FACING_ALL, (Comparable)((TileEntityIC2ConnectorTin)te).getFacing());
        }
        return state;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a(TYPE, (Comparable)((Object)BlockTypes_IC2_Connector.values()[meta]));
    }

    public boolean isSideSolid(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        TileEntityIC2ConnectorTin base = this.getBaseTE((BlockTypes_IC2_Connector)((Object)state.func_177229_b(TYPE)));
        if (base != null) {
            base.setFacing((EnumFacing)state.func_177229_b((IProperty)IEProperties.FACING_ALL));
        }
        return base;
    }

    private TileEntityIC2ConnectorTin getBaseTE(BlockTypes_IC2_Connector type) {
        switch (type) {
            case TIN_CONN: {
                return new TileEntityIC2ConnectorTin(false);
            }
            case TIN_RELAY: {
                return new TileEntityIC2ConnectorTin(true);
            }
            case COPPER_CONN: {
                return new TileEntityIC2ConnectorCopper(false);
            }
            case COPPER_RELAY: {
                return new TileEntityIC2ConnectorCopper(true);
            }
            case GOLD_CONN: {
                return new TileEntityIC2ConnectorGold(false);
            }
            case GOLD_RELAY: {
                return new TileEntityIC2ConnectorGold(true);
            }
            case HV_CONN: {
                return new TileEntityIC2ConnectorHV(false);
            }
            case HV_RELAY: {
                return new TileEntityIC2ConnectorHV(true);
            }
            case GLASS_CONN: {
                return new TileEntityIC2ConnectorGlass(false);
            }
            case GLASS_RELAY: {
                return new TileEntityIC2ConnectorGlass(true);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        if (!stack.func_190926_b() && stack.func_77960_j() % 2 == 0) {
            int type = stack.func_77960_j() / 2;
            tooltip.add(I18n.func_135052_a((String)"industrialwires.tooltip.power_tier", (Object[])new Object[]{type % 5 + 1}));
            MixedWireType wire = MixedWireType.ALL[type];
            tooltip.add(I18n.func_135052_a((String)"industrialwires.tooltip.energy_per_tick", (Object[])new Object[]{wire.getIORate() * ConversionUtil.euPerJoule(), wire.getIORate() * ConversionUtil.ifPerJoule() * IWConfig.wireRatio}));
        }
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.SOLID;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public Object[] getValues() {
        return BlockTypes_IC2_Connector.values();
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockTypes_IC2_Connector)((Object)state.func_177229_b(TYPE))).ordinal();
    }
}

