/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.hv;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import com.elytradev.mirage.lighting.IColoredLight;
import com.elytradev.mirage.lighting.Light;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IWConfig;
import malte0811.industrialwires.IWDamageSources;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.IBlockBoundsIW;
import malte0811.industrialwires.blocks.IHasDummyBlocksIW;
import malte0811.industrialwires.blocks.ISyncReceiver;
import malte0811.industrialwires.compat.Compat;
import malte0811.industrialwires.network.MessageTileSyncIW;
import malte0811.industrialwires.util.Beziers;
import malte0811.industrialwires.util.ConversionUtil;
import malte0811.industrialwires.util.JouleEnergyStorage;
import malte0811.industrialwires.util.MiscUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(modid="ic2", iface="ic2.api.energy.tile.IEnergySink"), @Optional.Interface(modid="mirage", iface="com.elytradev.mirage.lighting.IColoredLight")})
public class TileEntityJacobsLadder
extends TileEntityIEBase
implements ITickable,
IHasDummyBlocksIW,
ISyncReceiver,
IEnergySink,
IBlockBoundsIW,
IEBlockInterfaces.IDirectionalTile,
IColoredLight,
IEBlockInterfaces.IPlayerInteraction {
    public EnumFacing facing = EnumFacing.NORTH;
    private JouleEnergyStorage energy;
    public LadderSize size;
    public Vec3d[] controls;
    private Vec3d[][] controlControls;
    public Vec3d[] controlMovement;
    private double t = 0.0;
    private int dummy = 0;
    public int timeTillActive = -1;
    private double tStep = 0.0;
    private double consumtionJoule;
    private int soundPhase;
    private Vec3d soundPos;
    public double salt;
    private static final float[] saltColor = new float[]{1.0f, 0.74509805f, 0.19607843f};
    private static final float[] airColor = new float[]{1.0f, 0.85f, 1.0f};
    private static final int factor = 20;
    private static final double smallMin = Math.exp(-0.5);
    private static final double normalMin = Math.exp(-5.0);
    private static final double hugeMin = Math.exp(-15.0);

    TileEntityJacobsLadder(LadderSize s) {
        this.size = s;
        this.initControl();
    }

    public TileEntityJacobsLadder() {
        this.size = LadderSize.HUGE;
        this.initControl();
    }

    private void initControl() {
        this.controls = new Vec3d[this.size.arcPoints];
        this.controlControls = new Vec3d[this.size.arcPoints - 2][this.size.movementPoints];
        this.controlMovement = new Vec3d[this.size.arcPoints];
        int sizeId = this.size.ordinal();
        this.consumtionJoule = IWConfig.HVStuff.jacobsUsageWatt[sizeId];
        this.energy = new JouleEnergyStorage(20.0 * this.consumtionJoule, 40.0 * this.consumtionJoule);
    }

    public void onLoad() {
        super.onLoad();
        Compat.loadIC2Tile.accept((TileEntity)this);
    }

    public void func_73660_a() {
        ApiUtils.checkForNeedlessTicking((TileEntity)this);
        if (this.isDummy()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if ((this.controlControls[0][0] == null || this.timeTillActive == -1 || this.t >= 1.0) && this.energy.getEnergyStoredJ() >= 2.0 * this.consumtionJoule) {
                for (int j = 0; j < this.size.movementPoints; ++j) {
                    double y = (double)j * (this.size.height + this.size.extraHeight) / (double)(this.size.movementPoints - 1) + this.size.innerPointOffset;
                    double width = this.widthFromHeight(y);
                    for (int i = 0; i < this.size.arcPoints - 2; ++i) {
                        double z = this.size.zMax * 2.0 * (this.field_145850_b.field_73012_v.nextDouble() - 0.5);
                        double xMin = width * (double)i / (double)(this.size.arcPoints - 2) - width / 2.0 + this.size.bottomDistance / 2.0;
                        double xDiff = width / (double)(this.size.arcPoints - 2);
                        double x = this.field_145850_b.field_73012_v.nextDouble() * xDiff + xMin;
                        this.controlControls[i][j] = new Vec3d(x, y, z);
                    }
                }
                this.t = 0.0;
                this.timeTillActive = this.size.delay;
                this.tStep = 1.0 / (double)((int)(0.875 * (double)this.size.tickToTop + (double)this.field_145850_b.field_73012_v.nextInt(this.size.tickToTop / 4)));
                IndustrialWires.packetHandler.sendToAll((IMessage)new MessageTileSyncIW((TileEntity)this, this.writeArcStarter()));
            } else if (this.timeTillActive == 0 && this.t < 1.0) {
                double extracted = this.energy.extract(this.consumtionJoule, 1.0, true);
                if (extracted >= this.consumtionJoule) {
                    this.energy.extract(this.consumtionJoule, 1.0, false);
                } else {
                    this.timeTillActive = -1 - this.size.delay;
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74757_a("cancel", true);
                    IndustrialWires.packetHandler.sendToAll((IMessage)new MessageTileSyncIW((TileEntity)this, nbt));
                }
            } else if (this.timeTillActive < -1) {
                ++this.timeTillActive;
            }
        } else if (this.timeTillActive == 0 && this.t < 1.0) {
            int i;
            for (i = 0; i < this.size.arcPoints; ++i) {
                this.controls[i] = this.controls[i].func_178787_e(this.controlMovement[i]);
            }
            for (i = 1; i < this.size.arcPoints - 1; ++i) {
                this.controlMovement[i] = Beziers.getPoint(this.t, this.controlControls[i - 1]).func_178788_d(this.controls[i]);
            }
            if (this.soundPhase < 0) {
                IndustrialWires.proxy.playJacobsLadderSound(this, 0, this.soundPos);
                this.soundPhase = 0;
            }
            if (this.t >= 7.0 * this.tStep && this.soundPhase == 0) {
                IndustrialWires.proxy.playJacobsLadderSound(this, 1, this.soundPos);
                this.soundPhase = 1;
            } else if (this.t >= 1.0 - 4.0 * this.tStep && this.soundPhase == 1) {
                IndustrialWires.proxy.playJacobsLadderSound(this, 2, this.soundPos);
                this.soundPhase = 2;
            }
        } else if (this.t > 1.0) {
            this.timeTillActive = -1;
        }
        if (this.timeTillActive > 0) {
            --this.timeTillActive;
        } else if (this.timeTillActive == 0 && this.t < 1.0) {
            this.t += this.tStep;
            if (this.salt > 0.0) {
                this.salt -= 0.0025;
            } else if (this.salt < 0.0) {
                this.salt = 0.0;
            }
        }
    }

    private void initArc(int delay) {
        if (this.controlMovement == null) {
            this.initControl();
        }
        this.controls[0] = new Vec3d(0.0, 0.0, 0.0);
        this.controls[this.size.arcPoints - 1] = new Vec3d(this.size.bottomDistance, 0.0, 0.0);
        this.controlMovement[0] = new Vec3d(-(this.size.topDistance - this.size.bottomDistance) / (double)(2 * this.size.tickToTop), this.size.height / (double)this.size.tickToTop, 0.0);
        this.controlMovement[this.size.arcPoints - 1] = new Vec3d((this.size.topDistance - this.size.bottomDistance) / (double)(2 * this.size.tickToTop), this.size.height / (double)this.size.tickToTop, 0.0);
        this.t = 0.0;
        for (int i = 1; i < this.size.arcPoints - 1; ++i) {
            this.controls[i] = Beziers.getPoint(0.0, this.controlControls[i - 1]);
            this.controlMovement[i] = Beziers.getPoint(this.tStep, this.controlControls[i - 1]).func_178788_d(this.controls[i]);
        }
        double soundX = (double)this.field_174879_c.func_177958_n() + 0.5;
        double soundY = (double)this.field_174879_c.func_177956_o() + 0.5 * (double)this.size.dummyCount + this.size.heightOffset;
        double soundZ = (double)this.field_174879_c.func_177952_p() + 0.5;
        this.soundPos = new Vec3d(soundX, soundY, soundZ);
        this.soundPhase = -1;
        this.timeTillActive = delay;
    }

    private double widthFromHeight(double h) {
        return this.size.bottomDistance + h * (this.size.topDistance - this.size.bottomDistance) / this.size.height;
    }

    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        LadderSize oldSize = this.size;
        this.size = LadderSize.values()[nbt.func_74762_e("size")];
        if (this.size != oldSize) {
            this.initControl();
        }
        this.dummy = nbt.func_74762_e("dummy");
        this.energy.readFromNBT(nbt.func_74775_l("energy"));
        this.facing = EnumFacing.field_176754_o[nbt.func_74762_e("facing")];
        this.salt = nbt.func_74769_h("salt");
    }

    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("size", this.size.ordinal());
        nbt.func_74768_a("dummy", this.dummy);
        this.energy.writeToNbt(nbt, "energy");
        nbt.func_74768_a("facing", this.facing.func_176736_b());
        nbt.func_74780_a("salt", this.salt);
    }

    private NBTTagCompound writeArcStarter() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList ctrlCtrl = this.write2DVecArray(this.controlControls);
        nbt.func_74782_a("ctrlCtrl", (NBTBase)ctrlCtrl);
        nbt.func_74768_a("timeTillActive", this.timeTillActive);
        nbt.func_74780_a("tStep", this.tStep);
        nbt.func_74757_a("start", true);
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    private void readArcStarter(NBTTagCompound nbt) {
        this.controlControls = this.read2DVecArray(nbt.func_150295_c("ctrlCtrl", 9));
        this.tStep = nbt.func_74769_h("tStep");
        Minecraft.func_71410_x().func_152344_a(() -> this.initArc(nbt.func_74762_e("timeTillActive")));
    }

    private Vec3d[][] read2DVecArray(NBTTagList nbt) {
        Vec3d[][] ret = new Vec3d[nbt.func_74745_c()][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.readVecArray((NBTTagList)nbt.func_179238_g(i));
        }
        return ret;
    }

    private Vec3d[] readVecArray(NBTTagList nbt) {
        Vec3d[] ret = new Vec3d[nbt.func_74745_c()];
        for (int i = 0; i < ret.length; ++i) {
            NBTTagCompound vec = nbt.func_150305_b(i);
            ret[i] = new Vec3d(vec.func_74769_h("x"), vec.func_74769_h("y"), vec.func_74769_h("z"));
        }
        return ret;
    }

    private NBTTagList write2DVecArray(Vec3d[][] array) {
        NBTTagList ret = new NBTTagList();
        for (Vec3d[] subArray : array) {
            ret.func_74742_a((NBTBase)this.writeVecArray(subArray));
        }
        return ret;
    }

    private NBTTagList writeVecArray(Vec3d[] array) {
        NBTTagList ret = new NBTTagList();
        for (Vec3d point : array) {
            NBTTagCompound vec = new NBTTagCompound();
            vec.func_74780_a("x", point.field_72450_a);
            vec.func_74780_a("y", point.field_72448_b);
            vec.func_74780_a("z", point.field_72449_c);
            ret.func_74742_a((NBTBase)vec);
        }
        return ret;
    }

    @Override
    public boolean isDummy() {
        return this.dummy != 0;
    }

    @Override
    public void placeDummies(IBlockState state) {
        for (int i = 1; i <= this.size.dummyCount; ++i) {
            BlockPos pos2 = this.field_174879_c.func_177967_a(EnumFacing.UP, i);
            this.field_145850_b.func_175656_a(pos2, state);
            TileEntity te = this.field_145850_b.func_175625_s(pos2);
            if (!(te instanceof TileEntityJacobsLadder)) continue;
            ((TileEntityJacobsLadder)te).size = this.size;
            ((TileEntityJacobsLadder)te).dummy = i;
            ((TileEntityJacobsLadder)te).facing = this.facing;
        }
    }

    @Override
    public void breakDummies() {
        for (int i = 0; i <= this.size.dummyCount; ++i) {
            if (i == this.dummy || !(this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(EnumFacing.UP, i - this.dummy)) instanceof TileEntityJacobsLadder)) continue;
            this.field_145850_b.func_175698_g(this.field_174879_c.func_177967_a(EnumFacing.UP, i - this.dummy));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSync(NBTTagCompound nbt) {
        if (nbt.func_74764_b("salt")) {
            this.salt = nbt.func_74769_h("salt");
        }
        if (nbt.func_74767_n("cancel")) {
            this.timeTillActive = -1;
            IndustrialWires.proxy.playJacobsLadderSound(this, -1, this.soundPos);
        } else if (nbt.func_74767_n("start")) {
            this.readArcStarter(nbt);
        }
    }

    private boolean isActive() {
        if (this.isDummy()) {
            TileEntity master = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(this.dummy));
            return master instanceof TileEntityJacobsLadder && ((TileEntityJacobsLadder)master).isActive();
        }
        return this.timeTillActive == 0 && this.t < 1.0;
    }

    public void onEntityTouch(Entity e) {
        TileEntity master;
        if (this.isDummy() && !this.field_145850_b.field_72995_K && (master = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(this.dummy))) instanceof TileEntityJacobsLadder && ((TileEntityJacobsLadder)master).isActive()) {
            this.hurtEntity(e);
        }
    }

    private void hurtEntity(Entity e) {
        e.func_70097_a(IWDamageSources.dmg_jacobs, IWConfig.HVStuff.jacobsBaseDmg * (float)(this.size.ordinal() + 1));
    }

    public boolean interact(@Nonnull EnumFacing side, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull ItemStack heldItem, float hitX, float hitY, float hitZ) {
        TileEntityJacobsLadder masterTE;
        TileEntityJacobsLadder tileEntityJacobsLadder = masterTE = this.dummy == 0 ? this : this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(this.dummy));
        if (masterTE instanceof TileEntityJacobsLadder) {
            TileEntityJacobsLadder master = masterTE;
            if (master.isActive()) {
                if (!this.field_145850_b.field_72995_K) {
                    this.hurtEntity((Entity)player);
                }
                return true;
            }
            if (!heldItem.func_190926_b() && ApiUtils.compareToOreName((ItemStack)heldItem, (String)"itemSalt")) {
                return master.salt(player, hand, heldItem);
            }
        }
        return false;
    }

    private boolean salt(EntityPlayer player, EnumHand hand, ItemStack held) {
        if (this.salt < 3.0) {
            if (!this.field_145850_b.field_72995_K) {
                this.salt += 1.0;
                if (!player.func_184812_l_()) {
                    held.func_190918_g(1);
                    if (held.func_190916_E() <= 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                }
                NBTTagCompound update = new NBTTagCompound();
                update.func_74780_a("salt", this.salt);
                this.func_70296_d();
                IndustrialWires.packetHandler.sendToAll((IMessage)new MessageTileSyncIW((TileEntity)this, update));
            }
            return true;
        }
        return false;
    }

    public boolean rotate(World world, BlockPos pos) {
        if (this.isActive()) {
            return false;
        }
        if (!world.field_72995_K) {
            EnumFacing targetDir = this.facing.func_176732_a(EnumFacing.Axis.Y);
            for (int i = -this.dummy; i < this.size.dummyCount - this.dummy + 1; ++i) {
                BlockPos currPos = pos.func_177981_b(i);
                TileEntity te = world.func_175625_s(currPos);
                if (!(te instanceof TileEntityJacobsLadder)) continue;
                TileEntityJacobsLadder teJacobs = (TileEntityJacobsLadder)te;
                teJacobs.facing = targetDir;
                teJacobs.func_70296_d();
                IBlockState state = world.func_180495_p(currPos).func_185899_b((IBlockAccess)world, currPos);
                world.func_184138_a(currPos, state, state, 3);
                world.func_175641_c(currPos, state.func_177230_c(), 255, 0);
                world.func_175685_c(currPos, state.func_177230_c(), true);
            }
        }
        return true;
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return this.energy.getRequested(ConversionUtil.euPerJoule());
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing dir, double amount, double voltage) {
        return amount - this.energy.insert(amount, ConversionUtil.joulesPerEu(), true);
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing enumFacing) {
        return !this.isDummy() && enumFacing == this.facing;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing from) {
        return !this.isDummy() && from == this.facing && capability == CapabilityEnergy.ENERGY;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasCapability(capability, facing) && capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energy);
        }
        return null;
    }

    public void onChunkUnload() {
        if (IndustrialWires.hasIC2) {
            Compat.unloadIC2Tile.accept((TileEntity)this);
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        if (IndustrialWires.hasIC2) {
            Compat.unloadIC2Tile.accept((TileEntity)this);
        }
        if (this.field_145850_b.field_72995_K) {
            IndustrialWires.proxy.playJacobsLadderSound(this, -1, this.soundPos);
        }
        super.func_145843_s();
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        Vec3d max;
        Vec3d min;
        if (!this.isDummy()) {
            return Block.field_185505_j;
        }
        double distX = (1.0 - this.size.topDistance) / 2.0;
        double distZ = 0.5 - 0.0625 * (double)(this.size.ordinal() + 1);
        double h = Math.min(1.0, 1.0 + this.size.height - (double)this.dummy);
        if (this.facing.func_176740_k() == EnumFacing.Axis.Z) {
            min = new Vec3d(distX, 0.0, distZ);
            max = new Vec3d(1.0 - distX, h, 1.0 - distZ);
        } else {
            min = new Vec3d(distZ, 0.0, distX);
            max = new Vec3d(1.0 - distZ, h, 1.0 - distX);
        }
        return new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
    }

    @Nonnull
    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(@Nonnull EnumFacing facing) {
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 2;
    }

    public boolean mirrorFacingOnPlacement(@Nonnull EntityLivingBase placer) {
        return true;
    }

    public boolean canHammerRotate(@Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EntityLivingBase entity) {
        return false;
    }

    public boolean canRotate(@Nonnull EnumFacing axis) {
        return false;
    }

    public static float[] getColor(double t, double salt, LadderSize size) {
        salt = Math.min(salt, 1.0);
        double saltyness = 0.0;
        double t2 = t - 0.5;
        switch (size) {
            case SMALL: {
                saltyness = salt * (1.0 - 0.9 * (Math.exp(-Math.abs(t2)) - smallMin));
                break;
            }
            case NORMAL: {
                saltyness = salt * (1.0 - 0.9 * (Math.exp(-20.0 * t2 * t2) - normalMin));
                break;
            }
            case HUGE: {
                saltyness = salt * (1.0 - 0.9 * (Math.exp(-Math.abs(20.0 * t2 * t2 * t2)) - hugeMin));
            }
        }
        return MiscUtils.interpolate(saltyness, saltColor, 1.0 - saltyness, airColor);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="mirage")
    public Light getColoredLight() {
        if (this.timeTillActive == 0) {
            float[] color = TileEntityJacobsLadder.getColor(0.0, this.salt, this.size);
            return Light.builder().pos((double)this.field_174879_c.func_177958_n() + 0.5, Beziers.getPoint((double)0.5, (Vec3d[])this.controls).field_72448_b + (double)this.field_174879_c.func_177956_o() + this.size.bottomDistance + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5).color(color[0], color[1], color[2], 1.0f).radius(this.size.soundVolume / 3.0f).build();
        }
        return null;
    }

    public static enum LadderSize implements IStringSerializable
    {
        SMALL(4, 4, 0.5, 0.375, 0.15, 20, 0.05, 0.2, 0.05, 1.0, 1, 5, 8, 0.03725, 1.0f),
        NORMAL(4, 4, 0.95, 0.75, 0.2, 25, 0.15, 0.3, 0.15, 1.0, 1, 5, 9, 0.075, 2.0f),
        HUGE(4, 5, 1.8, 1.0, 0.25, 30, 0.2, 0.5, 0.3, 1.0, 2, 5, 10, 0.125, 3.0f);

        public final int arcPoints;
        public final int movementPoints;
        public final double height;
        public final double topDistance;
        public final double bottomDistance;
        public final int tickToTop;
        public final double zMax;
        public final double extraHeight;
        public final double innerPointOffset;
        public final double heightOffset;
        public final int delay;
        public final int renderPoints;
        public final int dummyCount;
        public final double renderDiameter;
        public final float soundVolume;

        private LadderSize(int arcP, int movP, double height, double topD, double bottomD, int ttTop, double zMax, double extraH, double iOff, double hOff, int dummies, int delay, int points, double renderDia, float volume) {
            this.arcPoints = arcP;
            this.movementPoints = movP;
            this.height = height;
            this.topDistance = topD;
            this.bottomDistance = bottomD;
            this.tickToTop = ttTop;
            this.zMax = zMax;
            this.extraHeight = extraH;
            this.innerPointOffset = iOff;
            this.heightOffset = hOff;
            this.dummyCount = dummies;
            this.delay = delay;
            this.renderPoints = points;
            this.renderDiameter = renderDia;
            this.soundVolume = volume;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

