/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.controlpanel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.IBlockBoundsIW;
import malte0811.industrialwires.blocks.INetGUI;
import malte0811.industrialwires.blocks.TileEntityIWBase;
import malte0811.industrialwires.blocks.controlpanel.BlockTypes_Panel;
import malte0811.industrialwires.blocks.controlpanel.TileEntityPanel;
import malte0811.industrialwires.controlpanel.MessageType;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import malte0811.industrialwires.items.ItemPanelComponent;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityPanelCreator
extends TileEntityIWBase
implements INetGUI,
IBlockBoundsIW {
    public List<PanelComponent> components = new ArrayList<PanelComponent>();
    @Nonnull
    public ItemStack inv = ItemStack.field_190927_a;
    private static final AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);

    @Override
    public void readNBT(NBTTagCompound nbt, boolean updatePacket) {
        NBTTagList l = nbt.func_150295_c("components", 10);
        PanelUtils.readListFromNBT(l, this.components);
        NBTTagCompound invTag = nbt.func_150297_b("inventory", 9) ? nbt.func_150295_c("inventory", 10).func_150305_b(0) : nbt.func_74775_l("inventory");
        this.inv = new ItemStack(invTag);
    }

    @Override
    public void writeNBT(NBTTagCompound nbt, boolean updatePacket) {
        this.writeToItemNBT(nbt, false);
        nbt.func_74782_a("inventory", (NBTBase)this.inv.serializeNBT());
    }

    public void writeToItemNBT(NBTTagCompound nbt, boolean toItem) {
        NBTTagList comps = new NBTTagList();
        for (PanelComponent p : this.components) {
            NBTTagCompound nbtInner = new NBTTagCompound();
            p.writeToNBT(nbtInner, toItem);
            comps.func_74742_a((NBTBase)nbtInner);
        }
        nbt.func_74782_a("components", (NBTBase)comps);
        nbt.func_74776_a("height", PanelUtils.getHeight(this.inv));
        nbt.func_74776_a("angle", PanelUtils.getAngle(this.inv));
    }

    @Override
    public void onChange(NBTTagCompound nbt, EntityPlayer p) {
        int type = nbt.func_74762_e("type");
        switch (MessageType.values()[type]) {
            case ADD: {
                ItemStack curr = p.field_71071_by.func_70445_o();
                PanelComponent pc = ItemPanelComponent.componentFromStack(curr);
                if (pc != null) {
                    pc.setX(nbt.func_74760_g("x"));
                    pc.setY(nbt.func_74760_g("y"));
                    this.components.add(pc);
                    if (curr.func_190926_b()) break;
                    curr.func_190918_g(1);
                    if (curr.func_190916_E() <= 0) {
                        p.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    }
                    p.field_71071_by.func_70296_d();
                    break;
                }
                IndustrialWires.logger.info("(IndustrialWires) Failed to load panel component send by " + p.getDisplayNameString());
                break;
            }
            case REMOVE: {
                int id = nbt.func_74762_e("id");
                if (id < 0 || id >= this.components.size() || !p.field_71071_by.func_70445_o().func_190926_b()) break;
                PanelComponent removed = this.components.get(id);
                ItemStack remItem = ItemPanelComponent.stackFromComponent(removed);
                p.field_71071_by.func_70437_b(remItem);
                p.field_71071_by.func_70296_d();
                this.components.remove(id);
                break;
            }
            case CREATE_PANEL: {
                if (!ItemStack.func_179545_c((ItemStack)PanelUtils.getPanelBase(), (ItemStack)this.inv) || this.components.isEmpty()) break;
                float height = PanelUtils.getHeight(this.inv);
                float angle = PanelUtils.getAngle(this.inv);
                boolean valid = true;
                for (PanelComponent comp : this.components) {
                    if (comp.isValidPos(this.components, height, angle)) continue;
                    valid = false;
                    break;
                }
                if (!valid) break;
                NBTTagCompound panelNBT = new NBTTagCompound();
                this.writeToItemNBT(panelNBT, true);
                ItemStack panel = new ItemStack((Block)IndustrialWires.panel, 1, BlockTypes_Panel.TOP.ordinal());
                panel.func_77982_d(panelNBT);
                this.inv = panel;
                this.components.clear();
                break;
            }
            case REMOVE_ALL: {
                Iterator<PanelComponent> it = this.components.iterator();
                while (it.hasNext()) {
                    PanelComponent next = it.next();
                    ItemStack nextStack = ItemPanelComponent.stackFromComponent(next);
                    if (!nextStack.func_190926_b()) {
                        if (!p.field_71071_by.func_70441_a(nextStack)) continue;
                        it.remove();
                        continue;
                    }
                    it.remove();
                }
                break;
            }
            case DISASSEMBLE: {
                if (this.components.size() != 0 || this.inv.func_77973_b() != PanelUtils.PANEL_ITEM) break;
                TileEntityPanel te = new TileEntityPanel();
                te.readFromItemNBT(this.inv.func_77978_p());
                this.components = new ArrayList<PanelComponent>(te.getComponents());
                this.inv = ItemStack.field_190927_a;
            }
        }
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return aabb;
    }
}

