/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.client.effect.texture.TextureSpritePlane;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectRegistry;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectStatus;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemTunedCrystalBase;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.structure.array.PatternBlockArray;
import hellfirepvp.astralsorcery.common.structure.change.ChangeSubscriber;
import hellfirepvp.astralsorcery.common.structure.match.StructureMatcherPatternArray;
import hellfirepvp.astralsorcery.common.tile.IMultiblockDependantTile;
import hellfirepvp.astralsorcery.common.tile.IStructureAreaOfInfluence;
import hellfirepvp.astralsorcery.common.tile.TileRitualLink;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import hellfirepvp.astralsorcery.common.util.CrystalCalculations;
import hellfirepvp.astralsorcery.common.util.ILocatable;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.PatternMatchHelper;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.SkyCollectionHelper;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileRitualPedestal
extends TileReceiverBaseInventory
implements IMultiblockDependantTile,
IStructureAreaOfInfluence {
    public static final int MAX_EFFECT_TICK = 63;
    private TransmissionReceiverRitualPedestal cachePedestal = null;
    private Object spritePlane = null;
    private List<BlockPos> offsetMirrorPositions = new LinkedList<BlockPos>();
    private ChangeSubscriber<StructureMatcherPatternArray> structureMatch = null;
    private boolean dirty = false;
    private boolean doesSeeSky = false;
    private boolean hasMultiblock = false;
    private BlockPos ritualLink = null;
    private int effectWorkTick = 0;
    private boolean working = false;
    private UUID ownerUUID = null;

    public TileRitualPedestal() {
        super(1, new EnumFacing[0]);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if ((this.ticksExisted & 0xF) == 0) {
                this.updateSkyState(this.field_145850_b.func_175678_i(this.func_174877_v()));
                this.updateLinkTile();
            }
            this.updateMultiblockState();
            if (this.dirty || !this.getInventoryHandler().getStackInSlot(0).func_190926_b()) {
                this.dirty = false;
                TransmissionReceiverRitualPedestal recNode = this.getUpdateCache();
                if (recNode != null) {
                    recNode.updateSkyState(this.doesSeeSky);
                    recNode.updateMultiblockState(this.hasMultiblock);
                    recNode.updateLink(this.field_145850_b, this.ritualLink);
                    recNode.markDirty(this.field_145850_b);
                    if (!this.getInventoryHandler().getStackInSlot(0).func_190926_b() && recNode.getCrystal().func_190926_b()) {
                        recNode.setChannelingCrystal(this.getInventoryHandler().getStackInSlot(0), this.field_145850_b);
                    }
                }
                this.markForUpdate();
            }
        }
        if (this.working) {
            if (this.effectWorkTick < 63) {
                ++this.effectWorkTick;
            }
        } else if (this.effectWorkTick > 0) {
            --this.effectWorkTick;
        }
        if (this.field_145850_b.field_72995_K && this.working) {
            IWeakConstellation ch;
            ItemStack crystal;
            EffectLightbeam lightbeam;
            Vector3 from;
            float alphaDaytime = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(this.field_145850_b);
            boolean isDay = (double)(alphaDaytime *= 0.8f) <= 1.0E-4;
            int tick = this.getEffectWorkTick();
            float percRunning = (float)tick / 63.0f;
            int chance = 15 + (int)((1.0f - percRunning) * 50.0f);
            if (rand.nextInt(chance) == 0) {
                from = new Vector3(this).add(0.5, 0.05, 0.5);
                MiscUtils.applyRandomOffset(from, rand, 0.05f);
                lightbeam = EffectHandler.getInstance().lightbeam(from.clone().addY(6.0), from, 1.5);
                lightbeam.setAlphaMultiplier(0.5f + 0.5f * alphaDaytime);
                lightbeam.setMaxAge(64);
            }
            if (this.ritualLink != null && rand.nextBoolean()) {
                Vector3 at = new Vector3(this).add(0.0, 0.1, 0.0);
                at.add((double)rand.nextFloat() * 0.5 + 0.25, 0.0, (double)rand.nextFloat() * 0.5 + 0.25);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
                p.setAlphaMultiplier(0.7f).setColor(Color.WHITE);
                p.setMaxAge((int)(30.0f + rand.nextFloat() * 50.0f));
                p.gravity(0.09).scale(0.3f + rand.nextFloat() * 0.1f);
            }
            if (this.shouldDoAdditionalEffects() && !isDay && rand.nextInt(chance * 2) == 0) {
                from = new Vector3(this).add(0.5, 0.1, 0.5);
                MiscUtils.applyRandomOffset(from, rand, 2.0f);
                from.setY((double)this.func_174877_v().func_177956_o() - 0.6 + (double)(1.0f * rand.nextFloat() * (float)(rand.nextBoolean() ? 1 : -1)));
                lightbeam = EffectHandler.getInstance().lightbeam(from.clone().addY(5 + rand.nextInt(3)), from, 1.3f);
                lightbeam.setAlphaMultiplier(alphaDaytime);
                if (this.getDisplayConstellation() != null) {
                    lightbeam.setColorOverlay(this.getDisplayConstellation().getConstellationColor());
                }
                lightbeam.setMaxAge(64);
            }
            if (!(crystal = this.getInventoryHandler().getStackInSlot(0)).func_190926_b() && crystal.func_77973_b() instanceof ItemTunedCrystalBase && (ch = ItemTunedCrystalBase.getMainConstellation(crystal)) != null) {
                CrystalProperties prop;
                ConstellationEffect ce = ConstellationEffectRegistry.clientRenderInstance(ch);
                if (ce != null) {
                    if (this.ritualLink != null) {
                        ce.playClientEffect(this.field_145850_b, this.ritualLink, this, percRunning, this.shouldDoAdditionalEffects());
                    }
                    ce.playClientEffect(this.field_145850_b, this.func_174877_v(), this, percRunning, this.shouldDoAdditionalEffects());
                }
                if ((prop = CrystalProperties.getCrystalProperties(crystal)) != null && prop.getFracturation() > 0 && rand.nextFloat() < (float)prop.getFracturation() / 100.0f) {
                    for (int i = 0; i < 3; ++i) {
                        Vector3 at = new Vector3(this).add(0.5, 1.35, 0.5);
                        at.add((double)rand.nextFloat() * 0.6 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.6 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.6 * (double)(rand.nextBoolean() ? 1 : -1));
                        Vector3 mot = new Vector3((double)rand.nextFloat() * 0.02 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.02 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.02 * (double)(rand.nextBoolean() ? 1 : -1));
                        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
                        p.motion(mot.getX(), mot.getY(), mot.getZ());
                        p.setAlphaMultiplier(1.0f).setColor(ch.getConstellationColor()).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
                        p.setMaxAge((int)(16.0f + rand.nextFloat() * 15.0f));
                        p.gravity(0.004).scale(0.15f + rand.nextFloat() * 0.05f);
                    }
                    if (rand.nextInt(3) == 0) {
                        IWeakConstellation c = this.getRitualConstellation();
                        Color col = null;
                        if (c != null && c.getConstellationColor() != null) {
                            col = c.getConstellationColor();
                        }
                        if (!this.offsetMirrorPositions.isEmpty()) {
                            BlockPos to = this.offsetMirrorPositions.get(rand.nextInt(this.offsetMirrorPositions.size()));
                            AstralSorcery.proxy.fireLightning(this.func_145831_w(), new Vector3(this).add(0.5, 1.25, 0.5), new Vector3(to).add((Vec3i)this.func_174877_v()).add(0.5, 0.5, 0.5), col);
                        } else {
                            AstralSorcery.proxy.fireLightning(this.func_145831_w(), new Vector3(this).add(0.5, 1.25, 0.5), new Vector3(this).add(0.5, 3.5 + (double)rand.nextFloat() * 2.5, 0.5), col);
                        }
                    }
                }
            }
            for (BlockPos expMirror : this.offsetMirrorPositions) {
                if (this.ticksExisted % 32 != 0) continue;
                Vector3 source = new Vector3(this).add(0.5, 0.75, 0.5);
                Vector3 to = new Vector3(this).add((Vec3i)expMirror).add(0.5, 0.5, 0.5);
                EffectHandler.getInstance().lightbeam(to, source, 0.8);
                if (this.ritualLink == null) continue;
                source = new Vector3(this).add(0.5, 5.5, 0.5);
                EffectLightbeam beam = EffectHandler.getInstance().lightbeam(to, source, 0.8);
                beam.setColorOverlay(Color.getHSBColor(rand.nextFloat() * 360.0f, 1.0f, 1.0f));
            }
        }
    }

    private void updateLinkTile() {
        boolean hasLinkNow;
        boolean hasLink = this.ritualLink != null;
        BlockPos link = this.func_174877_v().func_177982_a(0, 5, 0);
        TileRitualLink linkTile = MiscUtils.getTileAt((IBlockAccess)this.field_145850_b, link, TileRitualLink.class, true);
        if (linkTile != null) {
            this.ritualLink = linkTile.getLinkedTo();
            hasLinkNow = this.ritualLink != null;
        } else {
            hasLinkNow = false;
            this.ritualLink = null;
        }
        if (hasLink != hasLinkNow) {
            this.markForUpdate();
            this.flagDirty();
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    public boolean hasMultiblock() {
        return this.hasMultiblock;
    }

    public ItemStack placeCrystalIntoPedestal(ItemStack crystal) {
        this.getInventoryHandler().setStackInSlot(0, ItemUtils.copyStackWithSize(crystal, Math.min(crystal.func_190916_E(), 1)));
        TransmissionReceiverRitualPedestal recNode = this.getUpdateCache();
        if (recNode != null) {
            this.markForUpdate();
            recNode.setChannelingCrystal(crystal, this.field_145850_b);
        }
        return ItemUtils.copyStackWithSize(crystal, Math.max(0, crystal.func_190916_E() - 1));
    }

    public ItemStack getCurrentPedestalCrystal() {
        TransmissionReceiverRitualPedestal recNode = this.getUpdateCache();
        if (recNode != null) {
            return recNode.getCrystal();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @Nullable
    public PatternBlockArray getRequiredStructure() {
        return MultiBlockArrays.patternRitualPedestal;
    }

    @Override
    @Nonnull
    public BlockPos getLocationPos() {
        return this.func_174877_v();
    }

    @Override
    public double getRadius() {
        if (!this.providesEffect()) {
            return 0.0;
        }
        IWeakConstellation cst = this.getRitualConstellation();
        if (cst == null) {
            return 0.0;
        }
        ConstellationEffect ce = ConstellationEffectRegistry.clientRenderInstance(cst);
        if (ce == null) {
            return 0.0;
        }
        ConstellationEffectProperties prop = ce.provideProperties(Math.max(this.offsetMirrorPositions.size(), 0));
        if (prop != null && this.getRitualTrait() != null) {
            prop.modify(this.getRitualTrait());
        }
        return prop == null ? 0.0 : prop.getSize();
    }

    @Override
    public boolean providesEffect() {
        return this.working && !this.func_145837_r();
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Color getEffectRenderColor() {
        if (!this.providesEffect()) {
            return null;
        }
        IWeakConstellation cst = this.getRitualConstellation();
        if (cst == null) {
            return null;
        }
        return cst.getConstellationColor();
    }

    @Override
    public int getDimensionId() {
        return this.func_145831_w().field_73011_w.getDimension();
    }

    private void updateMultiblockState() {
        boolean found;
        boolean update;
        if (this.structureMatch == null) {
            this.structureMatch = PatternMatchHelper.getOrCreateMatcher(this.func_145831_w(), this.func_174877_v(), this.getRequiredStructure());
        }
        boolean bl = update = this.hasMultiblock != (found = this.structureMatch.matches(this.func_145831_w()));
        if (update) {
            this.hasMultiblock = found;
            this.markForUpdate();
            this.flagDirty();
        }
    }

    public int getEffectWorkTick() {
        return this.effectWorkTick;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IWeakConstellation getDisplayConstellation() {
        if (this.offsetMirrorPositions.size() != 5) {
            return null;
        }
        return this.getRitualConstellation();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldDoAdditionalEffects() {
        return this.working && this.offsetMirrorPositions.size() > 0;
    }

    @Nullable
    public IWeakConstellation getRitualConstellation() {
        ItemStack crystal = this.getInventoryHandler().getStackInSlot(0);
        if (!crystal.func_190926_b() && crystal.func_77973_b() instanceof ItemTunedCrystalBase) {
            return ItemTunedCrystalBase.getMainConstellation(crystal);
        }
        return null;
    }

    @Nullable
    public IMinorConstellation getRitualTrait() {
        ItemStack crystal = this.getInventoryHandler().getStackInSlot(0);
        if (!crystal.func_190926_b() && crystal.func_77973_b() instanceof ItemTunedCrystalBase) {
            return ItemTunedCrystalBase.getTrait(crystal);
        }
        return null;
    }

    @Nullable
    public TransmissionReceiverRitualPedestal getUpdateCache() {
        if (this.cachePedestal == null) {
            this.cachePedestal = (TransmissionReceiverRitualPedestal)this.tryGetNode();
        }
        if (this.cachePedestal != null && !this.cachePedestal.getLocationPos().equals((Object)this.func_174877_v())) {
            this.cachePedestal = null;
        }
        return this.cachePedestal;
    }

    protected void updateSkyState(boolean seesSky) {
        boolean update = this.doesSeeSky != seesSky;
        this.doesSeeSky = seesSky;
        if (update) {
            this.markForUpdate();
            this.flagDirty();
        }
    }

    public void onLoad() {
        TransmissionReceiverRitualPedestal ped;
        if (!this.field_145850_b.field_72995_K && (ped = this.getUpdateCache()) != null) {
            this.offsetMirrorPositions.clear();
            this.offsetMirrorPositions.addAll(ped.offsetMirrors.keySet());
            this.flagDirty();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public TextureSpritePlane getHaloEffectSprite() {
        TextureSpritePlane spr = (TextureSpritePlane)this.spritePlane;
        if (spr == null || spr.canRemove() || spr.isRemoved()) {
            spr = EffectHandler.getInstance().textureSpritePlane(SpriteLibrary.spriteHalo1, Vector3.RotAxis.Y_AXIS.clone());
            spr.setPosition(new Vector3(this).add(0.5, 0.06, 0.5));
            spr.setAlphaOverDistance(true);
            spr.setNoRotation(45.0f);
            spr.setRefreshFunc(() -> {
                if (this.func_145837_r() || !this.working) {
                    return false;
                }
                if (this.func_145831_w().field_73011_w == null || Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71441_e.field_73011_w == null) {
                    return false;
                }
                return this.func_145831_w().field_73011_w.getDimension() == Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
            });
            spr.setScale(6.5f);
            this.spritePlane = spr;
        }
        return spr;
    }

    private void updatePositions(Collection<BlockPos> offsetMirrors) {
        this.offsetMirrorPositions.clear();
        this.offsetMirrorPositions.addAll(offsetMirrors);
        this.markForUpdate();
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.working = compound.func_74767_n("working");
        this.ownerUUID = compound.func_74764_b("ownerMost") ? compound.func_186857_a("owner") : UUID.randomUUID();
        this.doesSeeSky = compound.func_74767_n("seesSky");
        this.hasMultiblock = compound.func_74767_n("hasMultiblock");
        this.ritualLink = compound.func_74764_b("ritualLinkPos") ? NBTHelper.readBlockPosFromNBT(compound.func_74775_l("ritualLinkPos")) : null;
        this.offsetMirrorPositions.clear();
        NBTTagList listPos = compound.func_150295_c("positions", 10);
        for (int i = 0; i < listPos.func_74745_c(); ++i) {
            this.offsetMirrorPositions.add(NBTHelper.readBlockPosFromNBT(listPos.func_150305_b(i)));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("working", this.working);
        if (this.ownerUUID != null) {
            compound.func_186854_a("owner", this.ownerUUID);
        }
        compound.func_74757_a("hasMultiblock", this.hasMultiblock);
        compound.func_74757_a("seesSky", this.doesSeeSky);
        if (this.ritualLink != null) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(this.ritualLink, tag);
            compound.func_74782_a("ritualLinkPos", (NBTBase)tag);
        }
        NBTTagList listPositions = new NBTTagList();
        for (BlockPos pos : this.offsetMirrorPositions) {
            NBTTagCompound cmp = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(pos, cmp);
            listPositions.func_74742_a((NBTBase)cmp);
        }
        compound.func_74782_a("positions", (NBTBase)listPositions);
    }

    public void flagDirty() {
        this.dirty = true;
    }

    @Override
    @Nullable
    public String getUnLocalizedDisplayName() {
        return "tile.blockritualpedestal.name";
    }

    @Override
    @Nonnull
    public ITransmissionReceiver provideEndpoint(BlockPos at) {
        return new TransmissionReceiverRitualPedestal(at, this.doesSeeSky);
    }

    public void setOwner(UUID uniqueID) {
        this.ownerUUID = uniqueID;
        this.markForUpdate();
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Nullable
    public EntityPlayer getOwningPlayerInWorld(World world) {
        UUID uuid = this.getOwnerUUID();
        return uuid == null ? null : world.func_152378_a(uuid);
    }

    public static class PedestalReceiverProvider
    implements TransmissionClassRegistry.TransmissionProvider {
        @Override
        public TransmissionReceiverRitualPedestal provideEmptyNode() {
            return new TransmissionReceiverRitualPedestal(null, false);
        }

        @Override
        public String getIdentifier() {
            return "astralsorcery:TransmissionReceiverRitualPedestal";
        }
    }

    public static class TransmissionReceiverRitualPedestal
    extends SimpleTransmissionReceiver {
        private static final int MAX_MIRROR_COUNT = 5;
        private static final int[] secToNext = new int[]{10, 10, 6, 10, 10};
        private static final int[] chanceToNext = new int[]{2, 2, 2, 2, 2};
        private static final BlockPos[] possibleOffsets = new BlockPos[]{new BlockPos(4, 2, 0), new BlockPos(4, 2, 1), new BlockPos(3, 2, 2), new BlockPos(2, 2, 3), new BlockPos(1, 2, 4), new BlockPos(0, 2, 4), new BlockPos(-1, 2, 4), new BlockPos(-2, 2, 3), new BlockPos(-3, 2, 2), new BlockPos(-4, 2, 1), new BlockPos(-4, 2, 0), new BlockPos(-4, 2, -1), new BlockPos(-3, 2, -2), new BlockPos(-2, 2, -3), new BlockPos(-1, 2, -4), new BlockPos(0, 2, -4), new BlockPos(1, 2, -4), new BlockPos(2, 2, -3), new BlockPos(3, 2, -2), new BlockPos(4, 2, -1)};
        private int ticksTicking = 0;
        private boolean doesSeeSky;
        private boolean hasMultiblock;
        private BlockPos ritualLinkTo = null;
        private IWeakConstellation channeling;
        private IMinorConstellation trait;
        private CrystalProperties properties;
        private int channeled = 0;
        private ItemStack crystal = ItemStack.field_190927_a;
        private ConstellationEffect ce;
        private Map<BlockPos, Boolean> offsetMirrors = new HashMap<BlockPos, Boolean>();
        private double collectionChannelBuffer = 0.0;
        private boolean doesWorkBuffer = false;
        private float posDistribution = -1.0f;
        private int idleBuffer = 0;

        public TransmissionReceiverRitualPedestal(BlockPos thisPos, boolean doesSeeSky) {
            super(thisPos);
            this.doesSeeSky = doesSeeSky;
        }

        @Override
        public void update(World world) {
            ++this.ticksTicking;
            if (!this.crystal.func_190926_b() && this.crystal.func_77973_b() instanceof ItemTunedCrystalBase) {
                CrystalProperties properties = CrystalProperties.getCrystalProperties(this.crystal);
                IWeakConstellation tuned = ItemTunedCrystalBase.getMainConstellation(this.crystal);
                IMinorConstellation trait = ItemTunedCrystalBase.getTrait(this.crystal);
                this.updateCrystalProperties(world, properties, tuned, trait);
            } else {
                this.updateCrystalProperties(world, null, null, null);
            }
            if (this.channeling != null && this.properties != null && this.hasMultiblock) {
                TileRitualPedestal pedestal;
                if (this.ce == null) {
                    this.ce = this.channeling.getRitualEffect(this.getRitualOrigin());
                }
                if (this.ticksTicking % 20 == 0) {
                    WorldNetworkHandler handle = WorldNetworkHandler.getNetworkHandler(world);
                    List<BlockPos> toNodes = this.getSources();
                    for (BlockPos pos : new LinkedList<BlockPos>(this.offsetMirrors.keySet())) {
                        BlockPos act = pos.func_177971_a((Vec3i)this.getLocationPos());
                        if (!toNodes.contains(act)) {
                            this.offsetMirrors.put(pos, false);
                            continue;
                        }
                        IPrismTransmissionNode node = handle.getTransmissionNode(act);
                        if (node == null) continue;
                        boolean found = false;
                        for (NodeConnection<IPrismTransmissionNode> n : node.queryNext(handle)) {
                            if (!n.getTo().equals((Object)this.getLocationPos())) continue;
                            this.offsetMirrors.put(pos, n.canConnect());
                            found = true;
                        }
                        if (found) continue;
                        this.offsetMirrors.put(pos, false);
                    }
                }
                if (this.ticksTicking % 60 == 0 && (pedestal = this.getTileAtPos(world, TileRitualPedestal.class)) != null && pedestal.offsetMirrorPositions.size() != this.offsetMirrors.size()) {
                    this.updateMirrorPositions(world);
                }
                if (this.doesSeeSky) {
                    double perc = 0.2 + 0.8 * (double)ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(world);
                    WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler(world);
                    if (this.posDistribution == -1.0f) {
                        this.posDistribution = SkyCollectionHelper.getSkyNoiseDistribution(world, this.getLocationPos());
                    }
                    if (handle != null) {
                        perc *= (double)CrystalCalculations.getCollectionAmt(this.properties, handle.getCurrentDistribution(this.channeling, in -> Float.valueOf(0.2f + 0.8f * in.floatValue())).floatValue());
                        perc *= 1.0 + 0.5 * (double)this.posDistribution;
                    }
                    this.collectionChannelBuffer += perc / 2.0;
                }
                if (this.collectionChannelBuffer > 0.0) {
                    this.idleBuffer = 0;
                    this.doMainEffect(world, this.ce, this.trait);
                    if (this.tryIncrementChannelingTimer()) {
                        ++this.channeled;
                    }
                    this.flagAsWorking(world);
                } else if (this.idleBuffer > 2) {
                    this.flagAsInactive(world);
                    this.ce = null;
                } else {
                    ++this.idleBuffer;
                }
            } else if (this.idleBuffer > 2) {
                this.flagAsInactive(world);
                this.ce = null;
            } else {
                ++this.idleBuffer;
            }
        }

        private void doMainEffect(World world, ConstellationEffect ce, @Nullable IMinorConstellation trait) {
            ConstellationEffectProperties prop = ce.provideProperties(this.getCollectedBackmirrors());
            if (trait != null) {
                prop = prop.modify(trait);
            }
            double maxDrain = 14.0;
            maxDrain /= CrystalCalculations.getMaxRitualReduction(this.properties);
            this.collectionChannelBuffer *= prop.getPotency();
            int executeTimes = MathHelper.func_76128_c((double)(this.collectionChannelBuffer / (maxDrain /= (double)Math.max(1, this.getCollectedBackmirrors() - 1))));
            int freeCap = MathHelper.func_76128_c((double)((double)CrystalCalculations.getChannelingCapacity(this.properties) * prop.getFracturationLowerBoundaryMultiplier()));
            double addFractureChance = (double)(CrystalCalculations.getFractureChance(executeTimes, freeCap) * CrystalCalculations.getCstFractureModifier(this.channeling)) * prop.getFracturationRate();
            int part = Math.max(1, executeTimes - freeCap);
            if (ce instanceof ConstellationEffectStatus && executeTimes > 0) {
                this.collectionChannelBuffer = 0.0;
                BlockPos to = this.getLocationPos();
                if (this.ritualLinkTo != null) {
                    to = this.ritualLinkTo;
                }
                if (((ConstellationEffectStatus)((Object)ce)).runEffect(world, to, this.getCollectedBackmirrors(), prop, trait)) {
                    for (int i = 0; i < part; ++i) {
                        if (!((double)rand.nextFloat() < addFractureChance * prop.getEffectAmplifier() / (double)part)) continue;
                        this.fractureCrystal(world);
                    }
                    this.markDirty(world);
                }
                return;
            }
            executeTimes = MathHelper.func_76128_c((double)((double)executeTimes * prop.getEffectAmplifier()));
            for (int i = 0; i <= executeTimes; ++i) {
                if (!(this.collectionChannelBuffer >= maxDrain)) continue;
                this.collectionChannelBuffer -= maxDrain;
                float perc = 1.0f;
                BlockPos to = this.getLocationPos();
                if (this.ritualLinkTo != null) {
                    to = this.ritualLinkTo;
                }
                if (!ce.playEffect(world, to, perc, prop, trait)) continue;
                if ((double)rand.nextFloat() < addFractureChance * prop.getEffectAmplifier() / (double)part) {
                    this.fractureCrystal(world);
                }
                this.markDirty(world);
            }
        }

        private void fractureCrystal(World world) {
            CrystalProperties prop;
            if (!this.crystal.func_190926_b() && (prop = CrystalProperties.getCrystalProperties(this.crystal)) != null) {
                prop = new CrystalProperties(prop.getSize(), prop.getPurity(), prop.getCollectiveCapability(), prop.getFracturation() + 1, prop.getSizeOverride());
                System.out.println(prop.getFracturation());
                if (prop.getFracturation() >= 100) {
                    SoundHelper.playSoundAround(SoundEvents.field_187561_bM, world, (Vec3i)this.getLocationPos(), 7.5f, 1.4f);
                    Vector3 at = new Vector3(this.getLocationPos()).add(0.5, 1.5, 0.5);
                    PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CELESTIAL_CRYSTAL_BURST, at);
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, (Vec3i)this.getLocationPos(), 32.0));
                    this.crystal = ItemStack.field_190927_a;
                } else {
                    CrystalProperties.applyCrystalProperties(this.crystal, prop);
                }
                this.markDirty(world);
            }
        }

        private int getCollectedBackmirrors() {
            int amt = 1;
            for (boolean f : this.offsetMirrors.values()) {
                if (!f) continue;
                ++amt;
            }
            return amt;
        }

        private void flagAsInactive(World world) {
            TileRitualPedestal ped;
            if (this.doesWorkBuffer && (ped = this.getTileAtPos(world, TileRitualPedestal.class)) != null) {
                this.doesWorkBuffer = false;
                this.channeled = 0;
                ped.working = false;
                ped.markForUpdate();
                this.clearAllMirrorPositions(world);
            }
        }

        private void flagAsWorking(World world) {
            TileRitualPedestal ped;
            if (!this.doesWorkBuffer && (ped = this.getTileAtPos(world, TileRitualPedestal.class)) != null) {
                this.doesWorkBuffer = true;
                ped.working = true;
                ped.markForUpdate();
            }
        }

        @Override
        public void onStarlightReceive(World world, boolean isChunkLoaded, IWeakConstellation type, double amount) {
            if (this.channeling != null && this.hasMultiblock && this.channeling.equals(type)) {
                this.collectionChannelBuffer += amount;
                this.tryGainMirrorPos(world);
            }
        }

        private boolean tryIncrementChannelingTimer() {
            if (this.offsetMirrors.size() < 0 || this.offsetMirrors.size() >= 5) {
                return false;
            }
            if (this.getCollectedBackmirrors() - 1 < this.offsetMirrors.size()) {
                return false;
            }
            int step = secToNext[this.offsetMirrors.size()];
            return this.channeled <= step;
        }

        private void tryGainMirrorPos(World world) {
            if (this.offsetMirrors.size() < 0 || this.offsetMirrors.size() >= 5) {
                return;
            }
            int mirrors = this.offsetMirrors.size();
            if (this.getCollectedBackmirrors() - 1 < mirrors) {
                return;
            }
            int step = secToNext[mirrors];
            if (this.channeled > step && world.field_73012_v.nextInt(chanceToNext[mirrors]) == 0) {
                this.findPossibleMirror(world);
            }
        }

        private void findPossibleMirror(World world) {
            long seed = 3451968351053166105L;
            seed |= this.getLocationPos().func_177986_g() * 31L;
            Random r = new Random(seed |= (long)(this.channeling.getUnlocalizedName().hashCode() * 31));
            for (int i = 0; i < this.getCollectedBackmirrors(); ++i) {
                r.nextInt(possibleOffsets.length);
            }
            BlockPos offset = null;
            boolean isValid = false;
            int c = 100;
            block1: while (!isValid && c > 0) {
                --c;
                offset = possibleOffsets[r.nextInt(possibleOffsets.length)];
                RaytraceAssist ray = new RaytraceAssist(this.getLocationPos(), this.getLocationPos().func_177971_a((Vec3i)offset));
                Vector3 from = new Vector3(0.5, 0.7, 0.5);
                Vector3 newDir = new Vector3(offset).add(0.5, 0.5, 0.5).subtract(from);
                for (BlockPos p : this.offsetMirrors.keySet()) {
                    Vector3 toDir = new Vector3(p).add(0.5, 0.5, 0.5).subtract(from);
                    if (!(Math.toDegrees(toDir.angle(newDir)) <= 30.0) && !(offset.func_177951_i((Vec3i)p) <= 3.0) && ray.isClear(world)) continue;
                    continue block1;
                }
                isValid = true;
            }
            if (isValid) {
                this.addMirrorPosition(world, offset);
            }
        }

        public void addMirrorPosition(World world, BlockPos offset) {
            this.offsetMirrors.put(offset, false);
            this.updateMirrorPositions(world);
            this.markDirty(world);
        }

        public void clearAllMirrorPositions(World world) {
            this.offsetMirrors.clear();
            this.updateMirrorPositions(world);
            this.markDirty(world);
        }

        @Override
        public boolean needsUpdate() {
            return true;
        }

        public void updateMirrorPositions(World world) {
            TileRitualPedestal ped = this.getTileAtPos(world, TileRitualPedestal.class);
            if (ped != null) {
                ped.updatePositions(this.offsetMirrors.keySet());
            }
        }

        private ILocatable getRitualOrigin() {
            if (this.ritualLinkTo == null) {
                return this;
            }
            return ILocatable.fromPos(this.ritualLinkTo);
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            super.readFromNBT(compound);
            this.doesSeeSky = compound.func_74767_n("doesSeeSky");
            this.hasMultiblock = compound.func_74767_n("hasMultiblock");
            this.channeled = compound.func_74762_e("channeled");
            this.properties = CrystalProperties.readFromNBT(compound);
            IConstellation c = IConstellation.readFromNBT(compound, IConstellation.getDefaultSaveKey() + "Normal");
            if (c != null && !(c instanceof IWeakConstellation)) {
                AstralSorcery.log.warn("Tried to load RitualPedestal from NBT with a non-Major constellation as effect. Ignoring constellation...");
                AstralSorcery.log.warn("Block affected is at " + this.getLocationPos());
            } else {
                this.channeling = c == null ? null : (IWeakConstellation)c;
            }
            c = IConstellation.readFromNBT(compound, IConstellation.getDefaultSaveKey() + "Trait");
            if (c != null && !(c instanceof IMinorConstellation)) {
                AstralSorcery.log.warn("Tried to load RitualPedestal from NBT with a non-Minor constellation as trait. Ignoring constellation...");
                AstralSorcery.log.warn("Block affected is at " + this.getLocationPos());
            } else {
                this.trait = c == null ? null : (IMinorConstellation)c;
            }
            this.offsetMirrors.clear();
            NBTTagList listPos = compound.func_150295_c("positions", 10);
            for (int i = 0; i < listPos.func_74745_c(); ++i) {
                this.offsetMirrors.put(NBTHelper.readBlockPosFromNBT(listPos.func_150305_b(i)), false);
            }
            this.crystal = compound.func_74764_b("crystal") ? new ItemStack(compound.func_74775_l("crystal")) : ItemStack.field_190927_a;
            this.ritualLinkTo = compound.func_74764_b("ritualLinkPos") ? NBTHelper.readBlockPosFromNBT(compound.func_74775_l("ritualLinkPos")) : null;
            if (this.channeling != null) {
                this.ce = this.channeling.getRitualEffect(this.getRitualOrigin());
                if (compound.func_74764_b("effect") && this.ce != null) {
                    NBTTagCompound cmp = compound.func_74775_l("effect");
                    this.ce.readFromNBT(cmp);
                }
            }
        }

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            NBTTagCompound tag;
            super.writeToNBT(compound);
            compound.func_74757_a("doesSeeSky", this.doesSeeSky);
            compound.func_74757_a("hasMultiblock", this.hasMultiblock);
            compound.func_74768_a("channeled", this.channeled);
            NBTTagList listPositions = new NBTTagList();
            for (BlockPos pos : this.offsetMirrors.keySet()) {
                NBTTagCompound cmp = new NBTTagCompound();
                NBTHelper.writeBlockPosToNBT(pos, cmp);
                listPositions.func_74742_a((NBTBase)cmp);
            }
            compound.func_74782_a("positions", (NBTBase)listPositions);
            if (this.properties != null) {
                this.properties.writeToNBT(compound);
            }
            if (this.channeling != null) {
                this.channeling.writeToNBT(compound, IConstellation.getDefaultSaveKey() + "Normal");
            }
            if (!this.crystal.func_190926_b()) {
                NBTTagCompound cmp = new NBTTagCompound();
                this.crystal.func_77955_b(cmp);
                compound.func_74782_a("crystal", (NBTBase)cmp);
            }
            if (this.trait != null) {
                this.trait.writeToNBT(compound, IConstellation.getDefaultSaveKey() + "Trait");
            }
            if (this.ritualLinkTo != null) {
                tag = new NBTTagCompound();
                NBTHelper.writeBlockPosToNBT(this.ritualLinkTo, tag);
                compound.func_74782_a("ritualLinkPos", (NBTBase)tag);
            }
            if (this.ce != null) {
                tag = new NBTTagCompound();
                this.ce.writeToNBT(tag);
                compound.func_74782_a("effect", (NBTBase)tag);
            }
        }

        @Override
        public TransmissionClassRegistry.TransmissionProvider getProvider() {
            return new PedestalReceiverProvider();
        }

        public void updateSkyState(boolean doesSeeSky) {
            this.doesSeeSky = doesSeeSky;
        }

        public void updateMultiblockState(boolean hasMultiblock) {
            this.hasMultiblock = hasMultiblock;
        }

        public void updateCrystalProperties(World world, CrystalProperties properties, IWeakConstellation channeling, IMinorConstellation trait) {
            IWeakConstellation prev = this.channeling;
            this.properties = properties;
            this.channeling = channeling;
            this.trait = trait;
            if (this.channeling != prev) {
                this.clearAllMirrorPositions(world);
            }
            this.markDirty(world);
        }

        public void updateLink(@Nonnull World world, @Nullable BlockPos ritualLink) {
            BlockPos prev = this.ritualLinkTo;
            this.ritualLinkTo = ritualLink;
            if (prev == null && this.ritualLinkTo == null) {
                return;
            }
            if (prev == null || !prev.equals((Object)this.ritualLinkTo)) {
                if (this.channeling != null) {
                    this.ce = this.channeling.getRitualEffect(this.getRitualOrigin());
                }
                this.markDirty(world);
            }
        }

        public void setChannelingCrystal(ItemStack crystal, World world) {
            this.crystal = ItemUtils.copyStackWithSize(crystal, Math.min(crystal.func_190916_E(), 1));
            this.markDirty(world);
        }

        public ItemStack getCrystal() {
            return this.crystal;
        }
    }
}

