/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.util.PositionedLoopSound;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.common.block.network.BlockAltar;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.crafting.IGatedRecipe;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.AltarRecipeRegistry;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.entities.EntityFlare;
import hellfirepvp.astralsorcery.common.item.base.IWandInteract;
import hellfirepvp.astralsorcery.common.item.base.ItemConstellationFocus;
import hellfirepvp.astralsorcery.common.item.block.ItemBlockAltar;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.structure.array.PatternBlockArray;
import hellfirepvp.astralsorcery.common.structure.change.ChangeSubscriber;
import hellfirepvp.astralsorcery.common.structure.match.StructureMatcherPatternArray;
import hellfirepvp.astralsorcery.common.tile.IMultiblockDependantTile;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.PatternMatchHelper;
import hellfirepvp.astralsorcery.common.util.Provider;
import hellfirepvp.astralsorcery.common.util.SkyCollectionHelper;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileAltar
extends TileReceiverBaseInventory
implements IWandInteract,
IMultiblockDependantTile {
    private static final Random rand = new Random();
    private float posDistribution = -1.0f;
    private ActiveCraftingTask craftingTask = null;
    private Object clientCraftSound = null;
    private AltarLevel level = AltarLevel.DISCOVERY;
    private ChangeSubscriber<StructureMatcherPatternArray> structureMatch = null;
    private boolean multiblockMatches = false;
    private ItemStack focusItem = ItemStack.field_190927_a;
    private boolean doesSeeSky = false;
    private int starlightStored = 0;

    public TileAltar() {
        super(25);
    }

    public TileAltar(AltarLevel level) {
        super(25, EnumFacing.UP);
        this.level = level;
    }

    @Override
    protected TileReceiverBaseInventory.ItemHandlerTile createNewItemHandler() {
        return new TileReceiverBaseInventory.ItemHandlerTileFiltered(this){

            @Override
            public boolean canInsertItem(int slot, ItemStack toAdd, @Nonnull ItemStack existing) {
                if (!super.canInsertItem(slot, toAdd, existing)) {
                    return false;
                }
                AltarLevel al = TileAltar.this.getAltarLevel();
                if (al == null) {
                    al = AltarLevel.DISCOVERY;
                }
                int allowed = al.getAccessibleInventorySize();
                return slot >= 0 && slot < allowed;
            }
        };
    }

    public void receiveStarlight(@Nullable IWeakConstellation type, double amount) {
        if (amount <= 0.001) {
            return;
        }
        this.starlightStored = Math.min(this.getMaxStarlightStorage(), (int)((double)this.starlightStored + amount * 200.0));
        this.markForUpdate();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if ((this.ticksExisted & 0xF) == 0) {
            this.updateSkyState(this.field_145850_b.func_175678_i(this.func_174877_v()));
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean needUpdate = false;
            this.matchStructure();
            needUpdate = this.starlightPassive(needUpdate);
            needUpdate = this.doTryCraft(needUpdate);
            if (needUpdate) {
                this.markForUpdate();
            }
        } else {
            if (this.getActiveCraftingTask() != null) {
                this.doCraftEffects();
                this.doCraftSound();
            }
            if (this.getAltarLevel() != null && this.getAltarLevel().ordinal() >= AltarLevel.TRAIT_CRAFT.ordinal() && this.getMultiblockState()) {
                this.playAltarEffects();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playAltarEffects() {
        if (Minecraft.func_71375_t() && rand.nextBoolean()) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 4.4, (double)this.func_174877_v().func_177952_p() + 0.5);
            p.motion(rand.nextFloat() * 0.03f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.03f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.03f * (float)(rand.nextBoolean() ? 1 : -1));
            p.scale(0.15f).setColor(Color.WHITE).setMaxAge(25);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doCraftSound() {
        if (Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER) > 0.0f) {
            if (this.clientCraftSound == null || ((PositionedLoopSound)((Object)this.clientCraftSound)).hasStoppedPlaying()) {
                this.clientCraftSound = SoundHelper.playSoundLoopClient(Sounds.attunement, new Vector3(this), 0.25f, 1.0f, () -> this.func_145837_r() || Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER) <= 0.0f || this.craftingTask == null);
            }
        } else {
            this.clientCraftSound = null;
        }
    }

    @Nullable
    public IConstellation getFocusedConstellation() {
        if (!this.focusItem.func_190926_b() && this.focusItem.func_77973_b() instanceof ItemConstellationFocus) {
            return ((ItemConstellationFocus)this.focusItem.func_77973_b()).getFocusConstellation(this.focusItem);
        }
        return null;
    }

    @Nonnull
    public ItemStack getFocusItem() {
        return this.focusItem;
    }

    public void setFocusStack(@Nonnull ItemStack stack) {
        this.focusItem = stack;
        this.markForUpdate();
    }

    @Override
    public void onBreak() {
        super.onBreak();
        if (!this.field_145850_b.field_72995_K && !this.focusItem.func_190926_b()) {
            ItemUtils.dropItemNaturally(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.focusItem);
            this.focusItem = ItemStack.field_190927_a;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = super.getRenderBoundingBox().func_72321_a(0.0, 5.0, 0.0);
        if (this.level != null && this.level.ordinal() >= AltarLevel.TRAIT_CRAFT.ordinal()) {
            box = box.func_72314_b(3.0, 0.0, 3.0);
        }
        return box;
    }

    @SideOnly(value=Side.CLIENT)
    private void doCraftEffects() {
        this.craftingTask.getRecipeToCraft().onCraftClientTick(this, this.craftingTask.getState(), ClientScheduler.getClientTick(), rand);
    }

    private void matchStructure() {
        boolean matches;
        PatternBlockArray structure = this.getRequiredStructure();
        if (structure != null && this.structureMatch == null) {
            this.structureMatch = PatternMatchHelper.getOrCreateMatcher(this.func_145831_w(), this.func_174877_v(), structure);
        }
        boolean bl = matches = structure == null || this.structureMatch.matches(this.func_145831_w());
        if (matches != this.multiblockMatches) {
            this.multiblockMatches = matches;
            this.markForUpdate();
        }
    }

    private boolean doTryCraft(boolean needUpdate) {
        if (this.craftingTask == null) {
            return needUpdate;
        }
        AbstractAltarRecipe altarRecipe = this.craftingTask.getRecipeToCraft();
        if (!this.doesRecipeMatch(altarRecipe, true)) {
            this.abortCrafting();
            return true;
        }
        if (!altarRecipe.fulfillesStarlightRequirement(this)) {
            if (this.craftingTask.shouldPersist(this)) {
                this.craftingTask.setState(ActiveCraftingTask.CraftingState.PAUSED);
                return true;
            }
            this.abortCrafting();
            return true;
        }
        if (this.ticksExisted % 5 == 0 && this.matchDownMultiblocks(altarRecipe.getNeededLevel()) == null) {
            this.abortCrafting();
            return true;
        }
        if (this.craftingTask.isFinished()) {
            this.finishCrafting();
            return true;
        }
        if (!this.craftingTask.tick(this)) {
            this.craftingTask.setState(ActiveCraftingTask.CraftingState.WAITING);
            return true;
        }
        ActiveCraftingTask.CraftingState prev = this.craftingTask.getState();
        this.craftingTask.setState(ActiveCraftingTask.CraftingState.ACTIVE);
        this.craftingTask.getRecipeToCraft().onCraftServerTick(this, ActiveCraftingTask.CraftingState.ACTIVE, this.craftingTask.getTicksCrafting(), this.craftingTask.getTotalCraftingTime(), rand);
        return prev != this.craftingTask.getState() || needUpdate;
    }

    private void finishCrafting() {
        ShapeMap current;
        if (this.craftingTask == null) {
            return;
        }
        AbstractAltarRecipe recipe = this.craftingTask.getRecipeToCraft();
        ItemStack out = recipe.getOutput(current = this.copyGetCurrentCraftingGrid(), this);
        if (!out.func_190926_b()) {
            out = ItemUtils.copyStackWithSize(out, out.func_190916_E());
        }
        ForgeHooks.setCraftingPlayer((EntityPlayer)this.craftingTask.tryGetCraftingPlayerServer());
        recipe.handleInputConsumption(this, this.craftingTask, this.getInventoryHandler());
        ForgeHooks.setCraftingPlayer(null);
        if (!out.func_190926_b() && !(out.func_77973_b() instanceof ItemBlockAltar) && out.func_190916_E() > 0) {
            ItemUtils.dropItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.3, (double)this.field_174879_c.func_177952_p() + 0.5, out).func_174873_u();
        }
        this.starlightStored = Math.max(0, this.starlightStored - recipe.getPassiveStarlightRequired());
        if (!recipe.allowsForChaining() || !this.doesRecipeMatch(recipe, false) || this.matchDownMultiblocks(recipe.getNeededLevel()) == null) {
            ItemStack match;
            if (this.getAltarLevel().ordinal() >= AltarLevel.CONSTELLATION_CRAFT.ordinal()) {
                Vector3 pos = new Vector3(this.func_174877_v()).add(0.5, 0.0, 0.5);
                PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CRAFT_FINISH_BURST, pos.getX(), pos.getY() + 0.05, pos.getZ());
                PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(this.func_145831_w(), (Vec3i)this.func_174877_v(), 32.0));
            }
            this.craftingTask.getRecipeToCraft().onCraftServerFinish(this, rand);
            if (!recipe.getOutputForMatching().func_190926_b() && (match = recipe.getOutputForMatching()).func_77973_b() instanceof ItemBlockAltar) {
                AltarLevel to = AltarLevel.values()[MathHelper.func_76125_a((int)match.func_77952_i(), (int)0, (int)(AltarLevel.values().length - 1))];
                this.tryForceLevelUp(to, true);
            }
            ResearchManager.informCraftingAltarCompletion(this, this.craftingTask);
            SoundHelper.playSoundAround((SoundEvent)Sounds.craftFinish, this.field_145850_b, (Vec3i)this.func_174877_v(), 1.0f, 1.7f);
            EntityFlare.spawnAmbient(this.field_145850_b, new Vector3(this).add(-3.0f + rand.nextFloat() * 7.0f, 0.6, -3.0f + rand.nextFloat() * 7.0f));
            this.craftingTask = null;
        }
        this.markForUpdate();
    }

    public ShapeMap copyGetCurrentCraftingGrid() {
        ShapeMap current = new ShapeMap();
        for (int i = 0; i < 9; ++i) {
            ShapedRecipeSlot slot = ShapedRecipeSlot.values()[i];
            ItemStack stack = this.getInventoryHandler().getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            current.put(slot, new ItemHandle(ItemUtils.copyStackWithSize(stack, 1)));
        }
        return current;
    }

    public boolean tryForceLevelUp(AltarLevel to, boolean doLevelUp) {
        int curr = this.getAltarLevel().ordinal();
        if (curr >= to.ordinal()) {
            return false;
        }
        if (this.getAltarLevel().next() != to) {
            return false;
        }
        if (!doLevelUp) {
            return true;
        }
        return this.levelUnsafe(this.getAltarLevel().next());
    }

    private boolean levelUnsafe(AltarLevel to) {
        this.level = to;
        this.multiblockMatches = false;
        this.structureMatch = null;
        return this.field_145850_b.func_175656_a(this.func_174877_v(), BlocksAS.blockAltar.func_176223_P().func_177226_a(BlockAltar.ALTAR_TYPE, (Comparable)((Object)this.level.getCorrespondingAltarType())));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private void abortCrafting() {
        this.craftingTask = null;
        this.markForUpdate();
    }

    private boolean starlightPassive(boolean needUpdate) {
        int yLevel;
        if (this.starlightStored > 0) {
            needUpdate = true;
        }
        this.starlightStored = (int)((double)this.starlightStored * 0.95);
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler(this.func_145831_w());
        if (this.doesSeeSky() && handle != null && (yLevel = this.func_174877_v().func_177956_o()) > 40) {
            float collect = 160.0f;
            float dstr = yLevel > 120 ? 1.0f + (float)((yLevel - 120) / 210) : (float)(yLevel - 20) / 100.0f;
            if (this.posDistribution == -1.0f) {
                this.posDistribution = SkyCollectionHelper.getSkyNoiseDistribution(this.field_145850_b, this.field_174879_c);
            }
            collect *= dstr;
            collect = (float)((double)collect * (0.6 + 0.4 * (double)this.posDistribution));
            collect = (float)((double)collect * (0.2 + 0.8 * (double)ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(this.func_145831_w())));
            this.starlightStored = Math.min(this.getMaxStarlightStorage(), (int)((float)this.starlightStored + collect));
            return true;
        }
        return needUpdate;
    }

    @Nullable
    public ActiveCraftingTask getActiveCraftingTask() {
        return this.craftingTask;
    }

    public boolean getMultiblockState() {
        return this.multiblockMatches;
    }

    @Override
    @Nullable
    public PatternBlockArray getRequiredStructure() {
        return this.getAltarLevel().getPattern();
    }

    @Override
    @Nonnull
    public BlockPos getLocationPos() {
        return this.func_174877_v();
    }

    public float getAmbientStarlightPercent() {
        return (float)this.starlightStored / (float)this.getMaxStarlightStorage();
    }

    public int getStarlightStored() {
        return this.starlightStored;
    }

    public int getMaxStarlightStorage() {
        return this.getAltarLevel().getStarlightMaxStorage();
    }

    public boolean doesRecipeMatch(AbstractAltarRecipe recipe, boolean ignoreStarlightRequirement) {
        ItemStack match;
        if (!recipe.getOutputForMatching().func_190926_b() && (match = recipe.getOutputForMatching()).func_77973_b() instanceof ItemBlockAltar) {
            AltarLevel to = AltarLevel.values()[MathHelper.func_76125_a((int)match.func_77952_i(), (int)0, (int)(AltarLevel.values().length - 1))];
            if (this.getAltarLevel().ordinal() >= to.ordinal()) {
                return false;
            }
        }
        return recipe.matches(this, this.getInventoryHandler(), ignoreStarlightRequirement);
    }

    @Override
    public void onInteract(World world, BlockPos pos, EntityPlayer player, EnumFacing side, boolean sneaking) {
        if (!world.field_72995_K) {
            AbstractAltarRecipe altarRecipe;
            if (!(this.getActiveCraftingTask() == null || this.matchDownMultiblocks((altarRecipe = this.craftingTask.getRecipeToCraft()).getNeededLevel()) != null && this.doesRecipeMatch(altarRecipe, false))) {
                this.abortCrafting();
                return;
            }
            this.findRecipe(player);
        }
    }

    @Nullable
    public AltarLevel matchDownMultiblocks(AltarLevel levelDownTo) {
        for (int i = this.getAltarLevel().ordinal(); i >= levelDownTo.ordinal(); --i) {
            AltarLevel al = AltarLevel.values()[i];
            PatternBlockArray pattern = al.getPattern();
            if (pattern != null && !pattern.matches(this.func_145831_w(), this.func_174877_v())) continue;
            return al;
        }
        return null;
    }

    private void findRecipe(EntityPlayer crafter) {
        if (this.craftingTask != null) {
            return;
        }
        AbstractAltarRecipe recipe = AltarRecipeRegistry.findMatchingRecipe(this, false);
        if (recipe instanceof IGatedRecipe && !((IGatedRecipe)((Object)recipe)).hasProgressionServer(crafter)) {
            return;
        }
        if (recipe != null) {
            int divisor = Math.max(0, this.getAltarLevel().ordinal() - recipe.getNeededLevel().ordinal());
            divisor = (int)Math.round(Math.pow(2.0, divisor));
            this.craftingTask = new ActiveCraftingTask(recipe, divisor, crafter.func_110124_au());
            this.markForUpdate();
        }
    }

    protected void updateSkyState(boolean seesSky) {
        boolean update = this.doesSeeSky != seesSky;
        this.doesSeeSky = seesSky;
        if (update) {
            this.markForUpdate();
        }
    }

    public boolean doesSeeSky() {
        return this.doesSeeSky;
    }

    public AltarLevel getAltarLevel() {
        return this.level;
    }

    public int getCraftingRecipeWidth() {
        return 3;
    }

    public int getCraftingRecipeHeight() {
        return 3;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.level = AltarLevel.values()[compound.func_74762_e("level")];
        this.starlightStored = compound.func_74762_e("starlight");
        this.multiblockMatches = compound.func_74767_n("multiblockMatches");
        this.craftingTask = compound.func_74764_b("craftingTask") ? ActiveCraftingTask.deserialize(compound.func_74775_l("craftingTask"), this.craftingTask) : null;
        this.focusItem = ItemStack.field_190927_a;
        if (compound.func_74764_b("focusItem")) {
            this.focusItem = new ItemStack(compound.func_74775_l("focusItem"));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("level", this.level.ordinal());
        compound.func_74768_a("starlight", this.starlightStored);
        compound.func_74757_a("multiblockMatches", this.multiblockMatches);
        if (!this.focusItem.func_190926_b()) {
            NBTTagCompound focusTag = new NBTTagCompound();
            this.focusItem.func_77955_b(focusTag);
            compound.func_74782_a("focusItem", (NBTBase)focusTag);
        }
        if (this.craftingTask != null) {
            compound.func_74782_a("craftingTask", (NBTBase)this.craftingTask.serialize());
        }
    }

    @Override
    @Nullable
    public String getUnLocalizedDisplayName() {
        return "tile.blockaltar.general.name";
    }

    @Override
    @Nonnull
    public ITransmissionReceiver provideEndpoint(BlockPos at) {
        return new TransmissionReceiverAltar(at);
    }

    public void onPlace(AltarLevel level) {
        this.level = level;
        this.markForUpdate();
    }

    @SideOnly(value=Side.CLIENT)
    public static void finishBurst(PktParticleEvent event) {
        EffectHandler.getInstance().textureSpritePlane(SpriteLibrary.spriteCraftBurst, Vector3.RotAxis.Y_AXIS.clone()).setPosition(event.getVec()).setScale(5 + rand.nextInt(2)).setNoRotation(rand.nextInt(360));
    }

    public static class AltarReceiverProvider
    implements TransmissionClassRegistry.TransmissionProvider {
        @Override
        public TransmissionReceiverAltar provideEmptyNode() {
            return new TransmissionReceiverAltar(null);
        }

        @Override
        public String getIdentifier() {
            return "astralsorcery:TransmissionReceiverAltar";
        }
    }

    public static class TransmissionReceiverAltar
    extends SimpleTransmissionReceiver {
        public TransmissionReceiverAltar(BlockPos thisPos) {
            super(thisPos);
        }

        @Override
        public void onStarlightReceive(World world, boolean isChunkLoaded, IWeakConstellation type, double amount) {
            TileAltar ta;
            if (isChunkLoaded && (ta = MiscUtils.getTileAt((IBlockAccess)world, this.getLocationPos(), TileAltar.class, false)) != null) {
                ta.receiveStarlight(type, amount);
            }
        }

        @Override
        public TransmissionClassRegistry.TransmissionProvider getProvider() {
            return new AltarReceiverProvider();
        }
    }

    public static enum AltarLevel {
        DISCOVERY(9, () -> null),
        ATTUNEMENT(13, () -> MultiBlockArrays.patternAltarAttunement),
        CONSTELLATION_CRAFT(21, () -> MultiBlockArrays.patternAltarConstellation),
        TRAIT_CRAFT(25, () -> MultiBlockArrays.patternAltarTrait),
        BRILLIANCE(25, () -> null);

        private final int maxStarlightStorage;
        private final int accessibleInventorySize;
        private final Provider<PatternBlockArray> patternProvider;

        private AltarLevel(int invSize, Provider<PatternBlockArray> patternProvider) {
            this.patternProvider = patternProvider;
            this.accessibleInventorySize = invSize;
            this.maxStarlightStorage = (int)(1000.0 * Math.pow(2.0, this.ordinal()));
        }

        public BlockAltar.AltarType getCorrespondingAltarType() {
            return BlockAltar.AltarType.values()[this.ordinal()];
        }

        @Nullable
        public PatternBlockArray getPattern() {
            return this.patternProvider.provide();
        }

        public int getStarlightMaxStorage() {
            return this.maxStarlightStorage;
        }

        public int getAccessibleInventorySize() {
            return this.accessibleInventorySize;
        }

        public BlockAltar.AltarType getType() {
            return BlockAltar.AltarType.values()[this.ordinal()];
        }

        public AltarLevel next() {
            if (this == BRILLIANCE) {
                return this;
            }
            return AltarLevel.values()[this.ordinal() + 1];
        }
    }
}

