/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event;

import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeTypeRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeType;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.util.ILocatable;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class APIRegistryEvent {

    public static class PerkPostRemove
    extends Event {
        private boolean removed;
        private final AbstractPerk perk;

        public PerkPostRemove(AbstractPerk perk) {
            this.perk = perk;
        }

        public AbstractPerk getPerk() {
            return this.perk;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public void setRemoved(boolean removed) {
            this.removed = removed;
        }
    }

    public static class PerkDisable
    extends Event {
        private boolean perkDisabled;
        private final AbstractPerk perk;
        private final EntityPlayer player;
        private final Side side;

        public PerkDisable(AbstractPerk perk, EntityPlayer player, Side side) {
            this.perk = perk;
            this.player = player;
            this.side = side;
        }

        public AbstractPerk getPerk() {
            return this.perk;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }

        public Side getSide() {
            return this.side;
        }

        public boolean isPerkDisabled() {
            return this.perkDisabled;
        }

        public void setPerkDisabled(boolean perkDisabled) {
            this.perkDisabled = perkDisabled;
        }
    }

    public static class PerkRegister
    extends Event {
        public PerkTree.PointConnector registerPerk(AbstractPerk perk) {
            return PerkTree.PERK_TREE.registerPerk(perk);
        }
    }

    public static class PerkAttributeTypeRegister
    extends Event {
        public void registerAttribute(PerkAttributeType type) {
            AttributeTypeRegistry.registerPerkType(type);
        }

        public void setAttributeLimit(PerkAttributeType type, float lowerBound, float upperBound) {
            AttributeTypeRegistry.limitPerkType(type, lowerBound, upperBound);
        }
    }

    public static class ConstellationRegister
    extends Event {
        public void registerConstellation(IConstellation c) {
            ConstellationRegistry.registerConstellation(c);
        }
    }

    public static class ConstellationEffectRegister
    extends Event {
        public void registerEffect(IMajorConstellation c, Function<ILocatable, ConstellationEffect> effectInstanceProvider) {
            ConstellationEffectRegistry.registerFromAPI(c, effectInstanceProvider);
        }
    }
}

