/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.constellation;

import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.constellation.ConstellationPerk;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;

public class PerkGelu
extends ConstellationPerk {
    public PerkGelu(int x, int y) {
        super("cst_gelu", Constellations.gelu, x, y);
        this.setCategory(CATEGORY_FOCUS);
        this.addModifier(new PerkAttributeModifier("astralsorcery.perkeffect", PerkAttributeModifier.Mode.ADDED_MULTIPLY, 0.03f){

            @Override
            protected void initModifier() {
                super.initModifier();
                this.setAbsolute();
            }

            @Override
            public float getValue(EntityPlayer player, PlayerProgress progress) {
                return this.getFlatValue() * (float)progress.getAvailablePerkPoints(player);
            }

            @Override
            public boolean hasDisplayString() {
                return false;
            }
        });
        this.addConverter(new PerkConverter(){

            @Override
            @Nonnull
            public PerkAttributeModifier convertModifier(EntityPlayer player, PlayerProgress progress, PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
                if (modifier.getAttributeType().equals("astralsorcery.perkeffect") && owningPerk != null && !owningPerk.equals(PerkGelu.this)) {
                    return modifier.convertModifier("astralsorcery.perkeffect", PerkAttributeModifier.Mode.STACKING_MULTIPLY, 0.0f);
                }
                return modifier;
            }
        });
    }

    @Override
    public boolean mayUnlockPerk(PlayerProgress progress, EntityPlayer player) {
        return super.mayUnlockPerk(progress, player) && !MiscUtils.contains(progress.getAppliedPerks(), perk -> perk.getCategory().equals(CATEGORY_FOCUS));
    }
}

