/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkLevelManager;
import hellfirepvp.astralsorcery.common.constellation.perk.PlayerAttributeMap;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.constellation.perk.types.IConverterProvider;
import hellfirepvp.astralsorcery.common.constellation.perk.types.ICooldownPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.types.IPlayerTickPerk;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktSyncPerkActivity;
import hellfirepvp.astralsorcery.common.util.data.TimeoutListContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PerkEffectHelper
implements ITickHandler {
    public static TimeoutListContainer<PlayerWrapperContainer, ResourceLocation> perkCooldowns = new TimeoutListContainer<PlayerWrapperContainer, ResourceLocation>(new PerkTimeoutHandler(), TickEvent.Type.SERVER);
    public static TimeoutListContainer<PlayerWrapperContainer, ResourceLocation> perkCooldownsClient = new TimeoutListContainer<PlayerWrapperContainer, ResourceLocation>(new PerkTimeoutHandler(), TickEvent.Type.CLIENT);
    public static final PerkEffectHelper EVENT_INSTANCE = new PerkEffectHelper();

    private PerkEffectHelper() {
    }

    @SubscribeEvent
    public void onDisconnect(FMLNetworkEvent.ServerDisconnectionFromClientEvent event) {
        AstralSorcery.proxy.scheduleDelayed(() -> this.handlePerkModification((EntityPlayer)((NetHandlerPlayServer)event.getHandler()).field_147369_b, Side.SERVER, true));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @SideOnly(value=Side.CLIENT)
    public void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        AstralSorcery.proxy.scheduleClientside(() -> this.lambda$onDisconnect$1((EntityPlayer)player));
    }

    @SubscribeEvent
    public void onConnect(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        AstralSorcery.proxy.scheduleDelayed(() -> this.handlePerkModification((EntityPlayer)((NetHandlerPlayServer)event.getHandler()).field_147369_b, Side.SERVER, false));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        AstralSorcery.proxy.scheduleClientside(new Runnable(){

            @Override
            public void run() {
                if (Minecraft.func_71410_x().field_71439_g != null && ResearchManager.clientInitialized) {
                    PerkEffectHelper.this.handlePerkModification((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT, false);
                } else {
                    AstralSorcery.proxy.scheduleClientside(this);
                }
            }
        });
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.getOriginal();
        EntityPlayer newPlayer = event.getEntityPlayer();
        this.handlePerkModification(oldPlayer, oldPlayer.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER, true);
        this.handlePerkModification(newPlayer, newPlayer.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER, false);
        PlayerWrapperContainer container = new PlayerWrapperContainer(oldPlayer);
        if (perkCooldowns.hasList(container)) {
            perkCooldowns.removeList(container);
        }
        if (perkCooldownsClient.hasList(container)) {
            perkCooldownsClient.removeList(container);
        }
        if (newPlayer instanceof EntityPlayerMP) {
            PacketChannel.CHANNEL.sendTo((IMessage)new PktSyncPerkActivity(PktSyncPerkActivity.Type.UNLOCKALL), (EntityPlayerMP)newPlayer);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void expRemoval(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            Side side;
            Side side2 = side = event.getEntityLiving().field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER;
            if (side != Side.SERVER) {
                return;
            }
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            PlayerProgress prog = ResearchManager.getProgress(player, side);
            if (prog != null) {
                float removePerDeath;
                long exp = MathHelper.func_76124_d((double)prog.getPerkExp());
                int level = prog.getPerkLevel(player);
                long expThisLevel = PerkLevelManager.INSTANCE.getExpForLevel(level - 1, player);
                long expNextLevel = PerkLevelManager.INSTANCE.getExpForLevel(level, player);
                int remove = MathHelper.func_76141_d((float)((float)(expNextLevel - expThisLevel) * (removePerDeath = 0.25f)));
                exp = exp - (long)remove < expThisLevel ? expThisLevel : (exp -= (long)remove);
                ResearchManager.setExp(player, exp);
            }
        }
    }

    private void handlePerkModification(EntityPlayer player, Side side, boolean remove) {
        PlayerProgress progress = ResearchManager.getProgress(player, side);
        if (progress != null) {
            for (AbstractPerk perk : progress.getAppliedPerks()) {
                if (remove) {
                    this.handlePerkRemoval(perk, player, side);
                    continue;
                }
                this.handlePerkApplication(perk, player, side);
            }
        }
    }

    public void notifyPerkChange(EntityPlayer player, Side side, AbstractPerk perk, boolean remove) {
        PlayerProgress progress = ResearchManager.getProgress(player, side);
        if (progress != null) {
            if (remove) {
                this.handlePerkRemoval(perk, player, side);
            } else {
                this.handlePerkApplication(perk, player, side);
            }
        }
    }

    private void handlePerkApplication(AbstractPerk perk, EntityPlayer player, Side side) {
        Collection<Object> converters = Lists.newArrayList();
        if (perk instanceof IConverterProvider) {
            converters = ((IConverterProvider)((Object)perk)).provideConverters(player, side);
        }
        this.batchApplyConverters(player, side, converters, perk);
    }

    private void handlePerkRemoval(AbstractPerk perk, EntityPlayer player, Side side) {
        Collection<Object> converters = Lists.newArrayList();
        if (perk instanceof IConverterProvider) {
            converters = ((IConverterProvider)((Object)perk)).provideConverters(player, side);
        }
        this.batchRemoveConverters(player, side, converters, perk);
    }

    @SideOnly(value=Side.CLIENT)
    public void notifyPerkDataChangeClient(EntityPlayer player, AbstractPerk perk, NBTTagCompound oldData, NBTTagCompound newData) {
        ResearchManager.getProgress(player, Side.CLIENT).setPerkData(perk, oldData);
        this.notifyPerkChange(player, Side.CLIENT, perk, true);
        ResearchManager.getProgress(player, Side.CLIENT).setPerkData(perk, newData);
        this.notifyPerkChange(player, Side.CLIENT, perk, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void clearAllPerksClient(EntityPlayer player) {
        PlayerAttributeMap attr = PerkAttributeHelper.getOrCreateMap(player, Side.CLIENT);
        ArrayList<AbstractPerk> copyPerks = new ArrayList<AbstractPerk>(attr.getCacheAppliedPerks());
        for (AbstractPerk perk : copyPerks) {
            this.handlePerkRemoval(perk, player, Side.CLIENT);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void reapplyAllPerksClient(EntityPlayer player) {
        this.handlePerkModification(player, Side.CLIENT, false);
        PlayerWrapperContainer container = new PlayerWrapperContainer(player);
        if (perkCooldowns.hasList(container)) {
            perkCooldowns.removeList(container);
        }
        if (perkCooldownsClient.hasList(container)) {
            perkCooldownsClient.removeList(container);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void refreshAllPerksClient(EntityPlayer player) {
        this.clearAllPerksClient(player);
        this.reapplyAllPerksClient(player);
    }

    public void applyGlobalConverters(EntityPlayer player, Side side, PerkConverter ... converters) {
        this.applyGlobalConverters(player, side, Arrays.asList(converters));
    }

    public void applyGlobalConverters(EntityPlayer player, Side side, List<PerkConverter> converters) {
        this.batchApplyConverters(player, side, converters, null);
    }

    public void removeGlobalConverters(EntityPlayer player, Side side, PerkConverter ... converters) {
        this.removeGlobalConverters(player, side, Arrays.asList(converters));
    }

    public void removeGlobalConverters(EntityPlayer player, Side side, List<PerkConverter> converters) {
        this.batchRemoveConverters(player, side, converters, null);
    }

    private synchronized void batchApplyConverters(EntityPlayer player, Side side, Collection<PerkConverter> converters, @Nullable AbstractPerk onlyAdd) {
        Thread tr = Thread.currentThread();
        if (!"Client thread".equalsIgnoreCase(tr.getName()) && !"Server thread".equalsIgnoreCase(tr.getName())) {
            AstralSorcery.log.error("Called perk modification outside synced thread!");
            throw new RuntimeException("Debug - Modified perks outside the main thread(s)");
        }
        PlayerProgress prog = ResearchManager.getProgress(player, side);
        if (prog != null) {
            PlayerAttributeMap attributeMap = PerkAttributeHelper.getOrCreateMap(player, side);
            List<AbstractPerk> perks = new LinkedList<AbstractPerk>(prog.getAppliedPerks());
            perks = perks.stream().filter(attributeMap::isPerkApplied).collect(Collectors.toList());
            perks.forEach(perk -> perk.removePerk(player, side));
            if (onlyAdd == null || !prog.isPerkSealed(onlyAdd)) {
                converters.forEach(c -> attributeMap.applyConverter(player, (PerkConverter)c));
            }
            if (onlyAdd != null && !prog.isPerkSealed(onlyAdd) && !perks.contains(onlyAdd)) {
                perks.add(onlyAdd);
            }
            perks.forEach(perk -> perk.applyPerk(player, side));
        }
    }

    private synchronized void batchRemoveConverters(EntityPlayer player, Side side, Collection<PerkConverter> converters, @Nullable AbstractPerk onlyRemove) {
        Thread tr = Thread.currentThread();
        if (!"Client thread".equalsIgnoreCase(tr.getName()) && !"Server thread".equalsIgnoreCase(tr.getName())) {
            AstralSorcery.log.error("Called perk modification outside synced thread!");
            throw new RuntimeException("Debug - Modified perks outside the main thread(s)");
        }
        PlayerProgress prog = ResearchManager.getProgress(player, side);
        if (prog != null) {
            PlayerAttributeMap attributeMap = PerkAttributeHelper.getOrCreateMap(player, side);
            LinkedList<AbstractPerk> perks = new LinkedList<AbstractPerk>(attributeMap.getCacheAppliedPerks());
            perks.forEach(perk -> perk.removePerk(player, side));
            converters.forEach(c -> attributeMap.removeConverter(player, (PerkConverter)c));
            if (onlyRemove != null) {
                perks.remove(onlyRemove);
            }
            perks.forEach(perk -> perk.applyPerk(player, side));
        }
    }

    public final boolean isCooldownActiveForPlayer(EntityPlayer player, AbstractPerk perk) {
        if (!(perk instanceof ICooldownPerk)) {
            return false;
        }
        TimeoutListContainer<PlayerWrapperContainer, ResourceLocation> container = player.func_130014_f_().field_72995_K ? perkCooldownsClient : perkCooldowns;
        PlayerWrapperContainer ct = new PlayerWrapperContainer(player);
        return container.hasList(ct) && container.getOrCreateList(ct).contains(perk.getRegistryName());
    }

    public final void setCooldownActiveForPlayer(EntityPlayer player, AbstractPerk perk, int cooldownTicks) {
        if (!(perk instanceof ICooldownPerk)) {
            return;
        }
        TimeoutListContainer<PlayerWrapperContainer, ResourceLocation> container = player.func_130014_f_().field_72995_K ? perkCooldownsClient : perkCooldowns;
        PlayerWrapperContainer ct = new PlayerWrapperContainer(player);
        container.getOrCreateList(ct).setOrAddTimeout(cooldownTicks, perk.getRegistryName());
    }

    public final void forceSetCooldownForPlayer(EntityPlayer player, AbstractPerk perk, int cooldownTicks) {
        PlayerWrapperContainer ct;
        if (!(perk instanceof ICooldownPerk)) {
            return;
        }
        TimeoutListContainer<PlayerWrapperContainer, ResourceLocation> container = player.func_130014_f_().field_72995_K ? perkCooldownsClient : perkCooldowns;
        if (!container.getOrCreateList(ct = new PlayerWrapperContainer(player)).setTimeout(cooldownTicks, perk.getRegistryName())) {
            this.setCooldownActiveForPlayer(player, perk, cooldownTicks);
        }
    }

    public final int getActiveCooldownForPlayer(EntityPlayer player, AbstractPerk perk) {
        PlayerWrapperContainer ct;
        if (!(perk instanceof ICooldownPerk)) {
            return -1;
        }
        TimeoutListContainer<PlayerWrapperContainer, ResourceLocation> container = player.func_130014_f_().field_72995_K ? perkCooldownsClient : perkCooldowns;
        if (!container.hasList(ct = new PlayerWrapperContainer(player))) {
            return -1;
        }
        return container.getOrCreateList(ct).getTimeout(perk.getRegistryName());
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        EntityPlayer ticked = (EntityPlayer)context[0];
        Side side = (Side)context[1];
        PlayerProgress prog = ResearchManager.getProgress(ticked, side);
        if (prog != null) {
            for (AbstractPerk perk : prog.getAppliedPerks()) {
                if (!(perk instanceof IPlayerTickPerk) || !prog.hasPerkEffect(perk)) continue;
                ((IPlayerTickPerk)((Object)perk)).onPlayerTick(ticked, side);
            }
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "PlayerPerkHandler";
    }

    private /* synthetic */ void lambda$onDisconnect$1(EntityPlayer player) {
        this.handlePerkModification(player, Side.CLIENT, true);
    }

    public static class PlayerWrapperContainer {
        @Nonnull
        public final EntityPlayer player;

        public PlayerWrapperContainer(@Nonnull EntityPlayer player) {
            this.player = player;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PlayerWrapperContainer)) {
                return false;
            }
            return ((PlayerWrapperContainer)obj).player.func_110124_au().equals(this.player.func_110124_au());
        }

        public int hashCode() {
            return this.player.func_110124_au().hashCode();
        }
    }

    public static class PerkTimeoutHandler
    implements TimeoutListContainer.ContainerTimeoutDelegate<PlayerWrapperContainer, ResourceLocation> {
        @Override
        public void onContainerTimeout(PlayerWrapperContainer plWrapper, ResourceLocation key) {
            AbstractPerk perk = PerkTree.PERK_TREE.getPerk(key);
            if (perk != null && perk instanceof ICooldownPerk) {
                ((ICooldownPerk)((Object)perk)).handleCooldownTimeout(plWrapper.player);
            }
        }
    }
}

