/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.feature;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiShulkerBox;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.logging.log4j.Level;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.api.IChestButtonCallback;
import vazkii.quark.base.client.ModKeybinds;
import vazkii.quark.base.handler.DropoffHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.network.message.MessageDropoff;
import vazkii.quark.base.network.message.MessageRestock;
import vazkii.quark.management.client.gui.GuiButtonChest;
import vazkii.quark.management.client.gui.GuiButtonShulker;
import vazkii.quark.management.feature.InventorySorting;

public class ChestButtons
extends Feature {
    ButtonInfo deposit;
    ButtonInfo smartDeposit;
    ButtonInfo restock;
    ButtonInfo extract;
    ButtonInfo sort;
    ButtonInfo sortPlayer;
    boolean debugClassnames;
    List<String> classnames;
    static List<GuiButtonChest> chestButtons = new ArrayList<GuiButtonChest>();

    @Override
    public void setupConfig() {
        this.deposit = this.loadButtonInfo("deposit", "", -18, -50);
        this.smartDeposit = this.loadButtonInfo("smart_deposit", "", -18, -30);
        this.restock = this.loadButtonInfo("restock", "", -18, 45);
        this.extract = this.loadButtonInfo("extract", "", -18, 25);
        this.sort = this.loadButtonInfo("sort", "The Sort button is only available if the Inventory Sorting feature is enable", -18, -70);
        this.sortPlayer = this.loadButtonInfo("sort_player", "The Sort button is only available if the Inventory Sorting feature is enable", -18, 5);
        this.debugClassnames = this.loadPropBool("Debug Classnames", "Set this to true to print out the names of all GUIs you open to the log. This is used to fill in the \"Forced GUIs\" list.", false);
        String[] classnamesArr = this.loadPropStringList("Forced GUIs", "GUIs in which the chest buttons should be forced to show up. Use the \"Debug Classnames\" option to find the names.", new String[0]);
        this.classnames = new ArrayList<String>(Arrays.asList(classnamesArr));
    }

    private ButtonInfo loadButtonInfo(String name, String comment, int xShift, int yShift) {
        ButtonInfo info = new ButtonInfo();
        String category = this.configCategory + "." + name;
        info.enabled = ModuleLoader.config.getBoolean("Enabled", category, true, comment);
        info.xShift = ModuleLoader.config.getInt("X Position", category, xShift, Integer.MIN_VALUE, Integer.MAX_VALUE, "");
        info.yShift = ModuleLoader.config.getInt("Y Position", category, yShift, Integer.MIN_VALUE, Integer.MAX_VALUE, "");
        return info;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        ModKeybinds.initChestKeys();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiContainer) {
            boolean accept;
            GuiContainer guiInv = (GuiContainer)event.getGui();
            Container container = guiInv.field_147002_h;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (this.debugClassnames) {
                FMLLog.log((Level)Level.INFO, (String)"[Quark] Opening GUI %s", (Object[])new Object[]{guiInv.getClass().getName()});
            }
            boolean bl = accept = guiInv instanceof IChestButtonCallback || guiInv instanceof GuiChest || guiInv instanceof GuiShulkerBox || this.classnames.contains(guiInv.getClass().getName());
            if (!accept) {
                for (Slot s : container.field_75151_b) {
                    if (s instanceof SlotItemHandler && DropoffHandler.isValidChest((EntityPlayer)player, ((SlotItemHandler)s).getItemHandler())) {
                        accept = true;
                        break;
                    }
                    IInventory inv = s.field_75224_c;
                    if (inv == null || !DropoffHandler.isValidChest((EntityPlayer)player, inv)) continue;
                    accept = true;
                    break;
                }
            }
            if (!accept) {
                return;
            }
            chestButtons.clear();
            int guiLeft = guiInv.getGuiLeft();
            int guiTop = guiInv.getGuiTop();
            for (Slot s : container.field_75151_b) {
                if (s.field_75224_c != player.field_71071_by || s.getSlotIndex() != 9) continue;
                ChestButtons.addButtonAndKeybind(event, this.extract, GuiButtonChest.Action.EXTRACT, guiInv, 13210, guiLeft, guiTop, s, ModKeybinds.chestExtractKey);
                ChestButtons.addButtonAndKeybind(event, this.restock, GuiButtonChest.Action.RESTOCK, guiInv, 13211, guiLeft, guiTop, s, ModKeybinds.chestRestockKey);
                ChestButtons.addButtonAndKeybind(event, this.deposit, GuiButtonChest.Action.DEPOSIT, guiInv, 13212, guiLeft, guiTop, s, ModKeybinds.chestDropoffKey);
                ChestButtons.addButtonAndKeybind(event, this.smartDeposit, GuiButtonChest.Action.SMART_DEPOSIT, guiInv, 13213, guiLeft, guiTop, s, ModKeybinds.chestMergeKey);
                if (!ModuleLoader.isFeatureEnabled(InventorySorting.class)) break;
                ChestButtons.addButtonAndKeybind(event, this.sort, GuiButtonChest.Action.SORT, guiInv, 13214, guiLeft, guiTop, s, ModKeybinds.chestSortKey);
                ChestButtons.addButtonAndKeybind(event, this.sortPlayer, GuiButtonChest.Action.SORT_PLAYER, guiInv, 13215, guiLeft, guiTop, s, ModKeybinds.playerSortKey);
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addButtonAndKeybind(GuiScreenEvent.InitGuiEvent.Post event, ButtonInfo info, GuiButtonChest.Action action, GuiContainer guiInv, int index, int guiLeft, int guiTop, Slot s, KeyBinding kb) {
        if (info.enabled) {
            ChestButtons.addButtonAndKeybind(event, action, guiInv, index, info.xShift, s.field_75221_f + info.yShift, s, kb);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addButtonAndKeybind(GuiScreenEvent.InitGuiEvent.Post event, GuiButtonChest.Action action, GuiContainer guiInv, int index, int x, int y, Slot s, KeyBinding kb) {
        ChestButtons.addButtonAndKeybind(event, action, guiInv, index, x, y, s, kb, null);
    }

    @SideOnly(value=Side.CLIENT)
    public static <T extends GuiScreen> void addButtonAndKeybind(GuiScreenEvent.InitGuiEvent.Post event, GuiButtonChest.Action action, GuiContainer guiInv, int index, int x, int y, Slot s, KeyBinding kb, Predicate<T> pred) {
        ContainerChest chest;
        IInventory chestInv;
        int left = guiInv.getGuiLeft();
        int top = guiInv.getGuiTop();
        GuiButtonChest button = guiInv instanceof GuiShulkerBox ? new GuiButtonShulker((GuiShulkerBox)guiInv, action, index, x, y, left, top) : new GuiButtonChest<GuiContainer>(guiInv, action, index, x, y, left, top, pred);
        if (guiInv instanceof IChestButtonCallback && !((IChestButtonCallback)guiInv).onAddChestButton(button, action.ordinal())) {
            return;
        }
        if (guiInv.field_147002_h instanceof ContainerChest && (chestInv = (chest = (ContainerChest)guiInv.field_147002_h).func_85151_d()).func_70005_c_().equals(Blocks.field_150477_bB.func_149732_F())) {
            button.setEnder(true);
        }
        chestButtons.add(button);
        event.getButtonList().add(button);
        if (kb != null) {
            ModKeybinds.keybindButton(kb, button);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void performAction(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getButton() instanceof GuiButtonChest) {
            GuiButtonChest buttonChest = (GuiButtonChest)event.getButton();
            GuiButtonChest.Action action = buttonChest.action;
            switch (action) {
                case SMART_DEPOSIT: {
                    NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageDropoff(true, true));
                    event.setCanceled(true);
                    break;
                }
                case DEPOSIT: {
                    NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageDropoff(false, true));
                    event.setCanceled(true);
                    break;
                }
                case EXTRACT: {
                    NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageRestock(false));
                    event.setCanceled(true);
                    break;
                }
                case RESTOCK: {
                    NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageRestock(true));
                    event.setCanceled(true);
                }
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    private static class ButtonInfo {
        boolean enabled;
        int xShift;
        int yShift;

        private ButtonInfo() {
        }
    }
}

