/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.lib.LibMisc;
import vazkii.quark.base.module.Feature;

public class VisualStatDisplay
extends Feature {
    public static final ImmutableSet<String> VALID_ATTRIBUTES = ImmutableSet.of((Object)"generic.attackDamage", (Object)"generic.attackSpeed", (Object)"generic.armor", (Object)"generic.armorToughness");

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void makeTooltip(ItemTooltipEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = event.getItemStack();
        if (!GuiScreen.func_146272_n() && this.isAttributeStrippable(stack)) {
            List tooltip = event.getToolTip();
            String allDesc = "";
            boolean clearedAny = false;
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                Multimap slotAttributes = stack.func_111283_C(slot);
                if (!slotAttributes.isEmpty()) {
                    String slotDesc = I18n.func_74838_a((String)("item.modifiers." + slot.func_188450_d()));
                    int index = tooltip.indexOf(slotDesc) - 1;
                    if (index < 0) continue;
                    tooltip.remove(index);
                    tooltip.remove(index);
                }
                block1: for (String s : slotAttributes.keys()) {
                    if (VALID_ATTRIBUTES.contains((Object)s)) {
                        allDesc = allDesc + ItemStack.field_111284_a.format(this.getAttribute(event.getEntityPlayer(), stack, (Multimap<String, AttributeModifier>)slotAttributes, s));
                    }
                    String pattern = ".* ?\\+?\\d+ " + I18n.func_74838_a((String)("attribute.name." + s)) + "$";
                    for (int i = 1; i < tooltip.size(); ++i) {
                        if (!((String)tooltip.get(i)).matches(pattern)) continue;
                        tooltip.remove(i);
                        clearedAny = true;
                        continue block1;
                    }
                }
            }
            if (clearedAny) {
                int len = mc.field_71466_p.func_78256_a(allDesc) + 32;
                String spaces = "";
                while (mc.field_71466_p.func_78256_a(spaces) < len) {
                    spaces = spaces + " ";
                }
                tooltip.add(1, spaces);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderTooltip(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (!GuiScreen.func_146272_n() && stack != null && this.isAttributeStrippable(stack)) {
            Item item = stack.func_77973_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft mc = Minecraft.func_71410_x();
            int x = event.getX() + 0;
            int y = event.getY() + 10;
            for (int i = 1; i < event.getLines().size(); ++i) {
                String s = (String)event.getLines().get(i);
                if (!TextFormatting.func_110646_a((String)s).trim().isEmpty()) continue;
                y += 10 * (i - 1) + 1;
                break;
            }
            Multimap slotAttributes = null;
            if (item instanceof ItemSword || item instanceof ItemTool || item instanceof ItemHoe) {
                double speed;
                slotAttributes = stack.func_111283_C(EntityEquipmentSlot.MAINHAND);
                double damage = this.getAttribute((EntityPlayer)mc.field_71439_g, stack, (Multimap<String, AttributeModifier>)slotAttributes, "generic.attackDamage");
                if (damage > 0.0) {
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    mc.func_110434_K().func_110577_a(LibMisc.GENERAL_ICONS_RESOURCE);
                    Gui.func_146110_a((int)x, (int)y, (float)238.0f, (float)0.0f, (int)9, (int)9, (float)256.0f, (float)256.0f);
                    String dmgStr = ItemStack.field_111284_a.format(damage);
                    mc.field_71466_p.func_175063_a(dmgStr, (float)(x + 12), (float)(y + 1), 0xFFFFFF);
                    x += mc.field_71466_p.func_78256_a(dmgStr) + 20;
                }
                if ((speed = this.getAttribute((EntityPlayer)mc.field_71439_g, stack, (Multimap<String, AttributeModifier>)slotAttributes, "generic.attackSpeed")) > 0.0) {
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    mc.func_110434_K().func_110577_a(LibMisc.GENERAL_ICONS_RESOURCE);
                    Gui.func_146110_a((int)x, (int)y, (float)247.0f, (float)0.0f, (int)9, (int)9, (float)256.0f, (float)256.0f);
                    String spdStr = ItemStack.field_111284_a.format(speed);
                    mc.field_71466_p.func_175063_a(spdStr, (float)(x + 12), (float)(y + 1), 0xFFFFFF);
                    x += mc.field_71466_p.func_78256_a(spdStr) + 20;
                }
            } else if (item instanceof ItemArmor) {
                double toughness;
                ItemArmor armor = (ItemArmor)item;
                EntityEquipmentSlot slot = armor.func_185083_B_();
                slotAttributes = stack.func_111283_C(slot);
                double armorLevel = this.getAttribute((EntityPlayer)mc.field_71439_g, stack, (Multimap<String, AttributeModifier>)slotAttributes, "generic.armor");
                if (armorLevel > 0.0) {
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    mc.func_110434_K().func_110577_a(LibMisc.GENERAL_ICONS_RESOURCE);
                    Gui.func_146110_a((int)x, (int)y, (float)229.0f, (float)0.0f, (int)9, (int)9, (float)256.0f, (float)256.0f);
                    String armorStr = ItemStack.field_111284_a.format(armorLevel);
                    mc.field_71466_p.func_175063_a(armorStr, (float)(x + 12), (float)(y + 1), 0xFFFFFF);
                    x += mc.field_71466_p.func_78256_a(armorStr) + 20;
                }
                if ((toughness = this.getAttribute((EntityPlayer)mc.field_71439_g, stack, (Multimap<String, AttributeModifier>)slotAttributes, "generic.armorToughness")) > 0.0) {
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    mc.func_110434_K().func_110577_a(LibMisc.GENERAL_ICONS_RESOURCE);
                    Gui.func_146110_a((int)x, (int)y, (float)220.0f, (float)0.0f, (int)9, (int)9, (float)256.0f, (float)256.0f);
                    String toughnessStr = ItemStack.field_111284_a.format(toughness);
                    mc.field_71466_p.func_175063_a(toughnessStr, (float)(x + 12), (float)(y + 1), 0xFFFFFF);
                    x += mc.field_71466_p.func_78256_a(toughnessStr) + 20;
                }
            }
            if (slotAttributes != null) {
                for (String s : slotAttributes.keySet()) {
                    if (VALID_ATTRIBUTES.contains((Object)s)) continue;
                    mc.field_71466_p.func_175063_a(TextFormatting.YELLOW + "[+]", (float)x, (float)(y + 1), 0xFFFFFF);
                    break;
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    private boolean isAttributeStrippable(ItemStack stack) {
        Item item = stack.func_77973_b();
        boolean tool = !stack.func_190926_b() && (item instanceof ItemTool || item instanceof ItemSword || item instanceof ItemArmor || item instanceof ItemHoe);
        return tool && (!stack.func_77942_o() || (stack.func_77978_p().func_74762_e("HideFlags") & 2) == 0);
    }

    private double getAttribute(EntityPlayer player, ItemStack stack, Multimap<String, AttributeModifier> map, String key) {
        if (player == null) {
            return 0.0;
        }
        Collection collection = map.get((Object)key);
        if (collection.isEmpty()) {
            return 0.0;
        }
        AttributeModifier attributemodifier = (AttributeModifier)collection.iterator().next();
        double d0 = attributemodifier.func_111164_d();
        boolean flag = false;
        if (key.equals("generic.attackDamage")) {
            d0 += player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
            d0 += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
        } else if (key.equals("generic.attackSpeed")) {
            d0 += player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
        }
        return d0;
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }
}

