/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.abstraction;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import elec332.core.abstraction.DefaultInstances;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IItem {
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    default public ItemStack getDefaultInstance(Item item) {
        return this.getFallback().getDefaultInstance(item);
    }

    default public void addPropertyOverride(ResourceLocation key, IItemPropertyGetter getter) {
        this.getFallback().addPropertyOverride(key, getter);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    default public IItemPropertyGetter getPropertyGetter(ResourceLocation key) {
        return this.getFallback().getPropertyGetter(key);
    }

    default public boolean updateItemStackNBT(NBTTagCompound tag) {
        return this.getFallback().updateItemStackNBT(tag);
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean hasCustomProperties() {
        return this.getFallback().hasCustomProperties();
    }

    default public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.getFallback().onItemUse(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    default public float getStrengthVsBlock(ItemStack stack, IBlockState state) {
        return this.getFallback().getStrengthVsBlock(stack, state);
    }

    default public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        return this.getFallback().onItemRightClick(world, player, hand);
    }

    default public ItemStack onItemUseFinish(ItemStack stack, World world, EntityLivingBase entityLiving) {
        return this.getFallback().onItemUseFinish(stack, world, entityLiving);
    }

    default public int getMetadata(int damage) {
        return this.getFallback().getMetadata(damage);
    }

    default public boolean getHasSubtypes() {
        return this.getFallback().getHasSubtypes();
    }

    default public IItem setHasSubtypes(boolean hasSubtypes) {
        this.getFallback().setHasSubtypes(hasSubtypes);
        return this;
    }

    default public IItem setMaxDamage(int maxDamage) {
        this.getFallback().setMaxDamage(maxDamage);
        return this;
    }

    default public boolean isDamageable() {
        return this.getFallback().isDamageable();
    }

    default public boolean hitEntity(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return this.getFallback().hitEntity(stack, target, attacker);
    }

    default public boolean onBlockDestroyed(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return this.getFallback().onBlockDestroyed(stack, world, state, pos, entityLiving);
    }

    default public boolean canHarvestBlock(IBlockState state) {
        return this.getFallback().canHarvestBlock(state);
    }

    default public boolean itemInteractionForEntity(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        return this.getFallback().itemInteractionForEntity(stack, player, target, hand);
    }

    default public IItem setFull3D() {
        this.getFallback().setFull3D();
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean isFull3D() {
        return this.getFallback().isFull3D();
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean shouldRotateAroundWhenRendering() {
        return this.getFallback().shouldRotateAroundWhenRendering();
    }

    default public IItem setUnlocalizedName(String unlocalizedName) {
        this.getFallback().setUnlocalizedName(unlocalizedName);
        return this;
    }

    default public String getUnlocalizedNameInefficiently(ItemStack stack) {
        return this.getFallback().getUnlocalizedNameInefficiently(stack);
    }

    default public String getUnlocalizedName() {
        return this.getFallback().getUnlocalizedName();
    }

    default public String getUnlocalizedName(ItemStack stack) {
        return this.getFallback().getUnlocalizedName(stack);
    }

    default public IItem setContainerItem(Item containerItem) {
        this.getFallback().setContainerItem(containerItem);
        return this;
    }

    default public boolean getShareTag() {
        return this.getFallback().getShareTag();
    }

    @Nullable
    default public Item getContainerItem() {
        return this.getFallback().getContainerItem();
    }

    default public void onUpdate(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        this.getFallback().onUpdate(stack, world, entity, itemSlot, isSelected);
    }

    default public void onCreated(ItemStack stack, World world, EntityPlayer player) {
        this.getFallback().onCreated(stack, world, player);
    }

    default public boolean isMap() {
        return this.getFallback().isMap();
    }

    default public EnumAction getItemUseAction(ItemStack stack) {
        return this.getFallback().getItemUseAction(stack);
    }

    default public int getMaxItemUseDuration(ItemStack stack) {
        return this.getFallback().getMaxItemUseDuration(stack);
    }

    default public void onPlayerStoppedUsing(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        this.getFallback().onPlayerStoppedUsing(stack, world, entityLiving, timeLeft);
    }

    @SideOnly(value=Side.CLIENT)
    default public void addInformation(ItemStack stack, World world, List<String> tooltip, boolean advanced) {
        this.getFallback().addInformation(stack, world, tooltip, advanced);
    }

    default public String getItemStackDisplayName(ItemStack stack) {
        return this.getFallback().getItemStackDisplayName(stack);
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean hasEffect(ItemStack stack) {
        return this.getFallback().hasEffect(stack);
    }

    default public EnumRarity getRarity(ItemStack stack) {
        return this.getFallback().getRarity(stack);
    }

    default public boolean isEnchantable(ItemStack stack) {
        return this.getFallback().isEnchantable(stack);
    }

    default public RayTraceResult rayTrace(World world, EntityPlayer playerIn, boolean useLiquids) {
        return this.getFallback().rayTrace(world, playerIn, useLiquids);
    }

    @SideOnly(value=Side.CLIENT)
    default public void getSubItems(Item item, CreativeTabs tab, List<ItemStack> subItems) {
        this.getFallback().getSubItems(item, tab, subItems);
    }

    default public IItem setCreativeTab(CreativeTabs tab) {
        this.getFallback().setCreativeTab(tab);
        return this;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    default public CreativeTabs getCreativeTab() {
        return this.getFallback().getCreativeTab();
    }

    default public boolean canItemEditBlocks() {
        return this.getFallback().canItemEditBlocks();
    }

    default public boolean getIsRepairable(ItemStack toRepair, ItemStack repair) {
        return this.getFallback().getIsRepairable(toRepair, repair);
    }

    default public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return this.getFallback().getAttributeModifiers(slot, stack);
    }

    default public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return this.getFallback().onDroppedByPlayer(item, player);
    }

    default public String getHighlightTip(ItemStack item, String displayName) {
        return this.getFallback().getHighlightTip(item, displayName);
    }

    default public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return this.getFallback().onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    default public boolean isRepairable() {
        return this.getFallback().isRepairable();
    }

    default public IItem setNoRepair() {
        this.getFallback().setNoRepair();
        return this;
    }

    default public IItem setMaxStackSize(int maxStackSize) {
        this.getFallback().setMaxDamage(maxStackSize);
        return this;
    }

    @Nullable
    default public NBTTagCompound getNBTShareTag(ItemStack stack) {
        return this.getFallback().getNBTShareTag(stack);
    }

    default public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return this.getFallback().onBlockStartBreak(itemstack, pos, player);
    }

    default public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        this.getFallback().onUsingTick(stack, player, count);
    }

    default public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return this.getFallback().onLeftClickEntity(stack, player, entity);
    }

    default public ItemStack getContainerItem(ItemStack itemStack) {
        return this.getFallback().getContainerItem(itemStack);
    }

    default public boolean hasContainerItem(ItemStack stack) {
        return this.getFallback().hasContainerItem(stack);
    }

    default public int getEntityLifespan(ItemStack itemStack, World world) {
        return this.getFallback().getEntityLifespan(itemStack, world);
    }

    default public boolean hasCustomEntity(ItemStack stack) {
        return this.getFallback().hasCustomEntity(stack);
    }

    @Nullable
    default public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return this.getFallback().createEntity(world, location, itemstack);
    }

    default public boolean onEntityItemUpdate(EntityItem entityItem) {
        return this.getFallback().onEntityItemUpdate(entityItem);
    }

    default public CreativeTabs[] getCreativeTabs() {
        return this.getFallback().getCreativeTabs();
    }

    default public float getSmeltingExperience(ItemStack item) {
        return this.getFallback().getSmeltingExperience(item);
    }

    default public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return this.getFallback().doesSneakBypassUse(stack, world, pos, player);
    }

    default public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        this.getFallback().onArmorTick(world, player, itemStack);
    }

    default public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return this.getFallback().isValidArmor(stack, armorType, entity);
    }

    default public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return this.getFallback().isBookEnchantable(stack, book);
    }

    @Nullable
    default public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return this.getFallback().getArmorTexture(stack, entity, slot, type);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    default public FontRenderer getFontRenderer(ItemStack stack) {
        return this.getFallback().getFontRenderer(stack);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    default public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return this.getFallback().getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    default public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return this.getFallback().onEntitySwing(entityLiving, stack);
    }

    @SideOnly(value=Side.CLIENT)
    default public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, ScaledResolution resolution, float partialTicks) {
        this.getFallback().renderHelmetOverlay(stack, player, resolution, partialTicks);
    }

    default public int getDamage(ItemStack stack) {
        return this.getFallback().getDamage(stack);
    }

    default public int getMetadata(ItemStack stack) {
        return this.getFallback().getMetadata(stack);
    }

    default public boolean showDurabilityBar(ItemStack stack) {
        return this.getFallback().showDurabilityBar(stack);
    }

    default public double getDurabilityForDisplay(ItemStack stack) {
        return this.getFallback().getDurabilityForDisplay(stack);
    }

    default public int getRGBDurabilityForDisplay(ItemStack stack) {
        return this.getFallback().getRGBDurabilityForDisplay(stack);
    }

    default public int getMaxDamage(ItemStack stack) {
        return this.getFallback().getMaxDamage(stack);
    }

    default public boolean isDamaged(ItemStack stack) {
        return this.getFallback().isDamaged(stack);
    }

    default public void setDamage(ItemStack stack, int damage) {
        this.getFallback().setDamage(stack, damage);
    }

    default public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.getFallback().canHarvestBlock(state, stack);
    }

    default public int getItemStackLimit(ItemStack stack) {
        return this.getFallback().getItemStackLimit(stack);
    }

    default public void setHarvestLevel(String toolClass, int level) {
        this.getFallback().setHarvestLevel(toolClass, level);
    }

    default public Set<String> getToolClasses(ItemStack stack) {
        return this.getFallback().getToolClasses(stack);
    }

    default public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        return this.getFallback().getHarvestLevel(stack, toolClass, player, blockState);
    }

    default public int getItemEnchantability(ItemStack stack) {
        return this.getFallback().getItemEnchantability(stack);
    }

    default public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.getFallback().canApplyAtEnchantingTable(stack, enchantment);
    }

    default public boolean isBeaconPayment(ItemStack stack) {
        return this.getFallback().isBeaconPayment(stack);
    }

    default public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return this.getFallback().shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    default public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return this.getFallback().shouldCauseBlockBreakReset(oldStack, newStack);
    }

    @Nullable
    default public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return this.getFallback().initCapabilities(stack, nbt);
    }

    default public ImmutableMap<String, ITimeValue> getAnimationParameters(ItemStack stack, World world, EntityLivingBase entity) {
        return this.getFallback().getAnimationParameters(stack, world, entity);
    }

    default public IItem getFallback() {
        return DefaultInstances.DEFAULT_ITEM;
    }
}

