/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.compiler.TypeRegistry;
import stanhebben.zenscript.type.ZenType;

public class ZenTypeUtil {
    public static final ITypeRegistry EMPTY_REGISTRY = new TypeRegistry();
    private static final Map<String, String> SIGNATURE_MAP = new HashMap<String, String>();

    public static String signature(Class<?> cls) {
        if (SIGNATURE_MAP.containsKey(cls.getName())) {
            return SIGNATURE_MAP.get(cls.getName());
        }
        if (cls.isArray()) {
            return "[" + ZenTypeUtil.signature(cls.getComponentType());
        }
        String signature = "L" + ZenTypeUtil.internal(cls) + ";";
        SIGNATURE_MAP.put(cls.getName(), signature);
        return signature;
    }

    public static String internal(Class<?> cls) {
        return cls.getName().replace('.', '/');
    }

    public static String descriptor(Method method) {
        StringBuilder output = new StringBuilder();
        output.append('(');
        for (Class<?> param : method.getParameterTypes()) {
            output.append(ZenTypeUtil.signature(param));
        }
        output.append(')').append(ZenTypeUtil.signature(method.getReturnType()));
        return output.toString();
    }

    public static ZenType checkPrimitive(ZenType type) {
        if (type.toJavaClass().isPrimitive()) {
            if (type == ZenType.INT) {
                return ZenType.INTOBJECT;
            }
            if (type == ZenType.BOOL) {
                return ZenType.BOOLOBJECT;
            }
            if (type == ZenType.BYTE) {
                return ZenType.BYTEOBJECT;
            }
            if (type == ZenType.SHORT) {
                return ZenType.SHORTOBJECT;
            }
            if (type == ZenType.DOUBLE) {
                return ZenType.DOUBLEOBJECT;
            }
            if (type == ZenType.FLOAT) {
                return ZenType.FLOATOBJECT;
            }
            if (type == ZenType.LONG) {
                return ZenType.LONGOBJECT;
            }
        }
        return type;
    }

    static {
        SIGNATURE_MAP.put(Boolean.TYPE.getName(), "Z");
        SIGNATURE_MAP.put(Byte.TYPE.getName(), "B");
        SIGNATURE_MAP.put(Short.TYPE.getName(), "S");
        SIGNATURE_MAP.put(Integer.TYPE.getName(), "I");
        SIGNATURE_MAP.put(Long.TYPE.getName(), "J");
        SIGNATURE_MAP.put(Float.TYPE.getName(), "F");
        SIGNATURE_MAP.put(Double.TYPE.getName(), "D");
        SIGNATURE_MAP.put(Character.TYPE.getName(), "C");
        SIGNATURE_MAP.put(Void.TYPE.getName(), "V");
    }
}

