/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.proxy;

import java.io.File;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.proxy.AbstractCommonProxy;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WrenchChecker;
import mcjty.rftoolspower.ForgeEventHandlers;
import mcjty.rftoolspower.blocks.ModBlocks;
import mcjty.rftoolspower.config.Config;
import mcjty.rftoolspower.items.ModItems;
import mcjty.rftoolspower.network.RFToolsPowerMessages;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.Level;

public abstract class CommonProxy
extends AbstractCommonProxy {
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        this.mainConfig = new Configuration(new File(this.modConfigDir.getPath() + File.separator + "rftools", "rftoolspower.cfg"));
        this.readMainConfig();
        SimpleNetworkWrapper network = PacketHandler.registerMessages((String)"rftoolspower", (String)"rftoolspower");
        RFToolsPowerMessages.registerNetworkMessages(network);
        ModItems.init();
        ModBlocks.init();
    }

    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            cfg.load();
            cfg.addCustomCategoryComment("general", "General settings");
            Config.init(cfg);
        }
        catch (Exception e1) {
            Logging.getLogger().log(Level.ERROR, "Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (this.mainConfig.hasChanged()) {
                this.mainConfig.save();
            }
        }
    }

    public void init(FMLInitializationEvent e) {
        super.init(e);
    }

    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        this.mainConfig = null;
        WrenchChecker.init();
    }
}

