/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.texture;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import twilightforest.TwilightForestMod;
import twilightforest.client.texture.GradientNode;

public class GradientMappedTexture
extends TextureAtlasSprite {
    private final ResourceLocation textureDependency;
    private boolean shouldStretchMinimumMaximum;
    private final GradientNode[] GRADIENT_MAP;
    private float minimumValue;
    private float maximumValue;

    public GradientMappedTexture(ResourceLocation textureDependency, ResourceLocation spriteName, boolean shouldStretchMinimumMaximum, GradientNode[] gradient_map) {
        super(spriteName.toString());
        this.textureDependency = textureDependency;
        this.GRADIENT_MAP = gradient_map;
        this.shouldStretchMinimumMaximum = shouldStretchMinimumMaximum;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        int[][] texture;
        int j;
        int i;
        TextureAtlasSprite sprite = textureGetter.apply(this.textureDependency);
        this.func_94217_a(sprite);
        this.field_110982_k = sprite.field_110982_k;
        this.field_110976_a = Lists.newArrayList();
        int minimumValue = 255;
        int maximumValue = 0;
        for (i = 0; i < sprite.func_110970_k(); ++i) {
            int[][] textureFrom = (int[][])sprite.func_147965_a(i).clone();
            int[][] textureTo = new int[textureFrom.length][];
            for (j = 0; j < textureFrom.length; ++j) {
                textureTo[j] = new int[textureFrom[j].length];
                System.arraycopy(textureFrom[j], 0, textureTo[j], 0, textureFrom[j].length);
            }
            if (this.shouldStretchMinimumMaximum) {
                for (int pixel : textureTo[0]) {
                    if ((pixel >> 24 & 0xFF) == 0) continue;
                    minimumValue = Math.min(minimumValue, GradientMappedTexture.getPerceptualBrightness(pixel));
                    maximumValue = Math.max(maximumValue, GradientMappedTexture.getPerceptualBrightness(pixel));
                }
            }
            this.field_110976_a.add(i, textureTo);
        }
        if (this.shouldStretchMinimumMaximum) {
            if (minimumValue > maximumValue) {
                this.minimumValue = (float)maximumValue / 255.0f;
                this.maximumValue = (float)minimumValue / 255.0f;
            } else {
                this.minimumValue = (float)minimumValue / 255.0f;
                this.maximumValue = (float)maximumValue / 255.0f;
            }
            for (i = 0; i < this.field_110976_a.size(); ++i) {
                texture = (int[][])this.field_110976_a.get(i);
                for (int j2 = 0; j2 < texture[0].length; ++j2) {
                    texture[0][j2] = GradientMappedTexture.getGradient(texture[0][j2], this.GRADIENT_MAP, this.minimumValue, this.maximumValue);
                }
            }
            TwilightForestMod.LOGGER.debug("Autogenerated " + this.func_94215_i() + " from " + this.textureDependency + " with min value of " + this.minimumValue + " and max value " + this.maximumValue);
        } else {
            for (i = 0; i < this.field_110976_a.size(); ++i) {
                texture = (int[][])this.field_110976_a.get(i);
                for (int l = 0; l < texture.length; ++l) {
                    for (j = 0; j < texture[l].length; ++j) {
                        texture[l][j] = GradientMappedTexture.getGradient(texture[l][j], this.GRADIENT_MAP, 0.0f, 1.0f);
                    }
                }
            }
            TwilightForestMod.LOGGER.debug("Autogenerated " + this.func_94215_i() + " from " + this.textureDependency);
        }
        return false;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of((Object)this.textureDependency);
    }

    private static int getPerceptualBrightness(int col) {
        return GradientMappedTexture.getPerceptualBrightness((double)GradientMappedTexture.red(col) / 255.0, (double)GradientMappedTexture.green(col) / 255.0, (double)GradientMappedTexture.blue(col) / 255.0);
    }

    private static int getPerceptualBrightness(double r, double g, double b) {
        return (int)(Math.sqrt(0.241 * r * r + 0.691 * g * g + 0.068 * b * b) * 255.0);
    }

    public static int getGradient(int packedColor, GradientNode[] gradientMap, float minimumValue, float maximumValue) {
        int a = packedColor >> 24 & 0xFF;
        if (a == 0) {
            return packedColor;
        }
        int rTo = 0;
        int gTo = 0;
        int bTo = 0;
        float gray = GradientMappedTexture.getBalancedValue((float)GradientMappedTexture.getPerceptualBrightness(packedColor) / 255.0f, minimumValue, maximumValue);
        if (gray <= gradientMap[0].node) {
            rTo = GradientMappedTexture.red(gradientMap[0].color);
            gTo = GradientMappedTexture.green(gradientMap[0].color);
            bTo = GradientMappedTexture.blue(gradientMap[0].color);
        } else if (gray >= gradientMap[gradientMap.length - 1].node) {
            int i = gradientMap[gradientMap.length - 1].color;
            rTo = GradientMappedTexture.red(i);
            gTo = GradientMappedTexture.green(i);
            bTo = GradientMappedTexture.blue(i);
        } else {
            for (int i = 0; i < gradientMap.length - 1; ++i) {
                if (gray == gradientMap[i].node) {
                    rTo = GradientMappedTexture.red(gradientMap[i].color);
                    gTo = GradientMappedTexture.green(gradientMap[i].color);
                    bTo = GradientMappedTexture.blue(gradientMap[i].color);
                    continue;
                }
                if (!(gray >= gradientMap[i].node) || !(gray <= gradientMap[i + 1].node)) continue;
                return GradientMappedTexture.getColorFromBetweenNodes(GradientMappedTexture.getBalancedValue(gray, gradientMap[i].node, gradientMap[i + 1].node), gradientMap[i].color, gradientMap[i + 1].color, a);
            }
        }
        return GradientMappedTexture.getColorFromARGB(rTo, gTo, bTo, a);
    }

    public static int getColorFromBetweenNodes(float placement, int color1, int color2, int alpha) {
        int r1 = GradientMappedTexture.red(color1);
        int g1 = GradientMappedTexture.green(color1);
        int b1 = GradientMappedTexture.blue(color1);
        int r2 = GradientMappedTexture.red(color2);
        int g2 = GradientMappedTexture.green(color2);
        int b2 = GradientMappedTexture.blue(color2);
        return GradientMappedTexture.getColorFromARGB(GradientMappedTexture.pickIntInBetween(placement, r1, r2), GradientMappedTexture.pickIntInBetween(placement, g1, g2), GradientMappedTexture.pickIntInBetween(placement, b1, b2), alpha);
    }

    public static int pickIntInBetween(float placement, float v1, float v2) {
        return (int)MathHelper.func_76129_c((float)(v1 * v1 * (1.0f - placement) + v2 * v2 * placement));
    }

    public static float getBalancedValue(float valueIn, float minimumValue, float maximumValue) {
        return (valueIn - minimumValue) / (maximumValue - minimumValue);
    }

    static int red(int pixel) {
        return pixel >> 16 & 0xFF;
    }

    static int green(int pixel) {
        return pixel >> 8 & 0xFF;
    }

    static int blue(int pixel) {
        return pixel & 0xFF;
    }

    static int getColorFromARGB(int r, int g, int b, int a) {
        return (((a << 8) + r << 8) + g << 8) + b;
    }
}

