/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor.tileentity;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedDouble;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedString;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.brandonscore.utils.HolidayHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.reactor.ProcessExplosion;
import com.brandon3055.draconicevolution.blocks.reactor.ReactorEffectHandler;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorEnergyInjector;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorStabilizer;
import com.brandon3055.draconicevolution.client.gui.GuiReactor;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileReactorCore
extends TileBCBase
implements ITickable {
    public int frameMoveContactPoints = 0;
    public boolean isFrameMoving = false;
    public boolean moveBlocksProvided = false;
    public static final int COMPONENT_MAX_DISTANCE = 8;
    public final ManagedVec3I[] componentPositions = new ManagedVec3I[6];
    private final ManagedEnum<EnumFacing.Axis> stabilizerAxis = (ManagedEnum)this.register("stabilizerAxis", (IManagedData)new ManagedEnum((Enum)EnumFacing.Axis.Y)).saveToTile().syncViaTile().finish();
    public final ManagedBool structureValid = (ManagedBool)this.register("structureValid", (IManagedData)new ManagedBool(false)).saveToTile().syncViaTile().finish();
    public final ManagedString structureError = (ManagedString)this.register("structureError", (IManagedData)new ManagedString("")).saveToTile().syncViaTile().finish();
    private int tick = 0;
    private Map<BlockPos, Integer> blockIntrusions = new HashMap<BlockPos, Integer>();
    public final ManagedEnum<ReactorState> reactorState = (ManagedEnum)this.register("reactorState", (IManagedData)new ManagedEnum((Enum)ReactorState.INVALID)).saveToTile().syncViaTile().finish();
    public final ManagedDouble reactableFuel = (ManagedDouble)this.register("reactableFuel", (IManagedData)new ManagedDouble(0.0)).saveToTile().saveToItem().syncViaTile().finish();
    public final ManagedDouble convertedFuel = (ManagedDouble)this.register("convertedFuel", (IManagedData)new ManagedDouble(0.0)).saveToTile().saveToItem().syncViaTile().finish();
    public final ManagedDouble temperature = (ManagedDouble)this.register("temperature", (IManagedData)new ManagedDouble(20.0)).saveToTile().syncViaTile().finish();
    public static final double MAX_TEMPERATURE = 10000.0;
    public final ManagedDouble shieldCharge = (ManagedDouble)this.register("shieldCharge", (IManagedData)new ManagedDouble(0.0)).saveToTile().syncViaTile().finish();
    public final ManagedDouble maxShieldCharge = (ManagedDouble)this.register("maxShieldCharge", (IManagedData)new ManagedDouble(0.0)).saveToTile().syncViaTile().finish();
    public final ManagedInt saturation = (ManagedInt)this.register("saturation", (IManagedData)new ManagedInt(0)).saveToTile().syncViaContainer().finish();
    public final ManagedInt maxSaturation = (ManagedInt)this.register("maxSaturation", (IManagedData)new ManagedInt(0)).saveToTile().syncViaContainer().finish();
    public final ManagedDouble tempDrainFactor = (ManagedDouble)this.register("tempDrainFactor", (IManagedData)new ManagedDouble(0.0)).saveToTile().syncViaContainer().finish();
    public final ManagedDouble generationRate = (ManagedDouble)this.register("generationRate", (IManagedData)new ManagedDouble(0.0)).saveToTile().syncViaContainer().finish();
    public final ManagedInt fieldDrain = (ManagedInt)this.register("fieldDrain", (IManagedData)new ManagedInt(0)).saveToTile().syncViaContainer().finish();
    public final ManagedDouble fieldInputRate = (ManagedDouble)this.register("fieldInputRate", (IManagedData)new ManagedDouble(0.0)).saveToTile().syncViaContainer().finish();
    public final ManagedDouble fuelUseRate = (ManagedDouble)this.register("fuelUseRate", (IManagedData)new ManagedDouble(0.0)).saveToTile().syncViaContainer().finish();
    public final ManagedBool startupInitialized = (ManagedBool)this.register("startupInitialized", (IManagedData)new ManagedBool(false)).saveToTile().syncViaContainer().finish();
    public final ManagedBool failSafeMode = (ManagedBool)this.register("failSafeMode", (IManagedData)new ManagedBool(false)).saveToTile().syncViaTile().finish();
    private ProcessExplosion explosionProcess = null;
    public final ManagedInt explosionCountdown = (ManagedInt)this.register("explosionCountdown", (IManagedData)new ManagedInt(-1)).saveToTile().syncViaContainer().finish();
    private int minExplosionDelay = 0;
    public float coreAnimation = 0.0f;
    public float shieldAnimation = 0.0f;
    public float shieldAnimationState = 0.0f;
    public final ManagedDouble shaderAnimationState = (ManagedDouble)this.register("shaderAnimationState", (IManagedData)new ManagedDouble(0.0)).saveToTile().syncViaTile().finish();
    public final ManagedDouble animExtractState = (ManagedDouble)this.register("animExtractState", (IManagedData)new ManagedDouble(0.0)).saveToTile().syncViaTile().finish();
    private final ReactorEffectHandler effectHandler;
    private static final byte ID_CHARGE = 0;
    private static final byte ID_ACTIVATE = 1;
    private static final byte ID_SHUTDOWN = 2;
    private static final byte ID_FAIL_SAFE = 3;
    public boolean inView = false;
    public int viewTicks = 0;
    public Roller roller = null;

    public TileReactorCore() {
        for (int i = 0; i < this.componentPositions.length; ++i) {
            this.componentPositions[i] = (ManagedVec3I)this.register("componentPosition" + i, (IManagedData)new ManagedVec3I(new Vec3I(0, 0, 0))).saveToTile().syncViaTile().finish();
        }
        this.effectHandler = DraconicEvolution.proxy.createReactorFXHandler(this);
    }

    public void func_73660_a() {
        super.update();
        this.updateCoreLogic();
        this.frameMoveContactPoints = 0;
        this.isFrameMoving = false;
        this.moveBlocksProvided = false;
        if (this.field_145850_b.field_72995_K && this.effectHandler != null) {
            this.effectHandler.updateEffects();
            if (HolidayHelper.isAprilFools()) {
                if (this.inView) {
                    ++this.viewTicks;
                    if (this.viewTicks > 100 && this.roller == null) {
                        if (this.field_145850_b.field_73012_v.nextInt(25) == 0) {
                            this.roller = new Roller(Vec3D.getCenter((TileEntity)this), this.field_145850_b, this.getCoreDiameter());
                        } else {
                            this.viewTicks = 0;
                        }
                    }
                } else {
                    if (this.viewTicks > 0 && this.roller != null && this.roller.age > 100) {
                        this.roller = null;
                    }
                    this.viewTicks = 0;
                }
                if (this.roller != null) {
                    this.roller.update();
                }
            }
        }
        ++this.tick;
    }

    private void updateCoreLogic() {
        if (this.field_145850_b.field_72995_K) {
            this.checkPlayerCollision();
            this.coreAnimation = (float)((double)this.coreAnimation + this.shaderAnimationState.value);
            if (this.maxShieldCharge.value == 0.0) {
                this.shieldAnimation = 0.0f;
                this.shaderAnimationState.value = 0.0f;
            } else {
                this.shieldAnimationState = MathHelper.clip((float)((float)(this.shieldCharge.value / this.maxShieldCharge.value) * 10.0f), (float)0.0f, (float)1.0f);
                this.shieldAnimation += this.shieldAnimationState;
            }
            if (this.reactorState.value == ReactorState.BEYOND_HOPE) {
                this.shieldAnimationState = this.field_145850_b.field_73012_v.nextInt(10) == 0 ? 0.0f : 1.0f;
                this.shieldAnimation += this.shieldAnimationState;
            }
            return;
        }
        this.shaderAnimationState.value = Math.min(1.0, (this.temperature.value - 20.0) / 1000.0);
        this.animExtractState.value = 0.0;
        switch ((ReactorState)this.reactorState.value) {
            case INVALID: {
                this.updateOfflineState();
                break;
            }
            case COLD: {
                this.updateOfflineState();
                break;
            }
            case WARMING_UP: {
                this.initializeStartup();
                this.checkBlockIntrusions();
                break;
            }
            case RUNNING: {
                this.updateOnlineState();
                this.checkBlockIntrusions();
                if (this.failSafeMode.value && this.temperature.value < 2500.0 && (double)this.saturation.value / (double)this.maxSaturation.value >= 0.99) {
                    LogHelper.dev("Reactor: Initiating Fail-Safe Shutdown!");
                    this.shutdownReactor();
                }
                double sat = 1.0 - (double)this.saturation.value / (double)this.maxSaturation.value;
                this.animExtractState.value = Math.min(1.0, sat * 10.0);
                break;
            }
            case STOPPING: {
                this.updateOnlineState();
                this.checkBlockIntrusions();
                if (!(this.temperature.value <= 2000.0)) break;
                this.reactorState.value = ReactorState.COOLING;
                break;
            }
            case COOLING: {
                this.updateOfflineState();
                if (!(this.temperature.value <= 100.0)) break;
                this.reactorState.value = ReactorState.COLD;
                break;
            }
            case BEYOND_HOPE: {
                this.checkBlockIntrusions();
                this.updateCriticalState();
            }
        }
    }

    private void updateOfflineState() {
        if (this.temperature.value > 20.0) {
            this.temperature.value -= 0.5;
        }
        if (this.shieldCharge.value > 0.0) {
            this.shieldCharge.value -= this.maxShieldCharge.value * 5.0E-4;
        } else if (this.shieldCharge.value < 0.0) {
            this.shieldCharge.value = 0.0;
        }
        if (this.saturation.value > 0) {
            this.saturation.value = (int)((double)this.saturation.value - (double)this.maxSaturation.value * 1.0E-6);
        } else if (this.saturation.value < 0) {
            this.saturation.value = 0;
        }
    }

    private void initializeStartup() {
        if (!this.startupInitialized.value) {
            double totalFuel = this.reactableFuel.value + this.convertedFuel.value;
            this.maxShieldCharge.value = totalFuel * 96.45061728395062 * 100.0;
            this.maxSaturation.value = (int)(totalFuel * 96.45061728395062 * 1000.0);
            if (this.saturation.value > this.maxSaturation.value) {
                this.saturation.value = this.maxSaturation.value;
            }
            if (this.shieldCharge.value > this.maxShieldCharge.value) {
                this.shieldCharge.value = this.maxShieldCharge.value;
            }
            this.startupInitialized.value = true;
        }
    }

    private void updateOnlineState() {
        double coreSat = (double)this.saturation.value / (double)this.maxSaturation.value;
        double negCSat = (1.0 - coreSat) * 99.0;
        double temp50 = Math.min(this.temperature.value / 10000.0 * 50.0, 99.0);
        double tFuel = this.convertedFuel.value + this.reactableFuel.value;
        double convLVL = this.convertedFuel.value / tFuel * 1.3 - 0.3;
        double tempOffset = 444.7;
        double tempRiseExpo = negCSat * negCSat * negCSat / (100.0 - negCSat) + tempOffset;
        double tempRiseResist = temp50 * temp50 * temp50 * temp50 / (100.0 - temp50);
        double riseAmount = (tempRiseExpo - tempRiseResist * (1.0 - convLVL) + convLVL * 1000.0) / 10000.0;
        if (this.reactorState.value == ReactorState.STOPPING && convLVL < 1.0) {
            if (this.temperature.value <= 2001.0) {
                this.reactorState.value = ReactorState.COOLING;
                this.startupInitialized.value = false;
                return;
            }
            this.temperature.value = (double)this.saturation.value >= (double)this.maxSaturation.value * 0.99 && this.reactableFuel.value > 0.0 ? (this.temperature.value -= 1.0 - convLVL) : (this.temperature.value += riseAmount * 10.0);
        } else {
            this.temperature.value += riseAmount * 10.0;
        }
        int baseMaxRFt = (int)((double)this.maxSaturation.value / 1000.0 * DEConfig.reactorOutputMultiplier * 1.5);
        int maxRFt = (int)((double)baseMaxRFt * (1.0 + convLVL * 2.0));
        this.generationRate.value = (1.0 - coreSat) * (double)maxRFt;
        this.saturation.value = (int)((double)this.saturation.value + this.generationRate.value);
        this.tempDrainFactor.value = this.temperature.value > 8000.0 ? 1.0 + (this.temperature.value - 8000.0) * (this.temperature.value - 8000.0) * 2.5E-6 : (this.temperature.value > 2000.0 ? 1.0 : (this.temperature.value > 1000.0 ? (this.temperature.value - 1000.0) / 1000.0 : 0.0));
        this.fieldDrain.value = (int)Math.min(this.tempDrainFactor.value * Math.max(0.01, 1.0 - coreSat) * ((double)baseMaxRFt / 10.923556), 2.147483647E9);
        double fieldNegPercent = 1.0 - this.shieldCharge.value / this.maxShieldCharge.value;
        this.fieldInputRate.value = (double)this.fieldDrain.value / fieldNegPercent;
        this.shieldCharge.value -= Math.min((double)this.fieldDrain.value, this.shieldCharge.value);
        this.fuelUseRate.value = this.tempDrainFactor.value * (1.0 - coreSat) * (0.001 * DEConfig.reactorFuelUsageMultiplier);
        if (this.reactableFuel.value > 0.0) {
            this.convertedFuel.value += this.fuelUseRate.value;
            this.reactableFuel.value -= this.fuelUseRate.value;
        }
        if (this.shieldCharge.value <= 0.0 && this.temperature.value > 2000.0 && this.reactorState.value != ReactorState.BEYOND_HOPE) {
            this.reactorState.value = ReactorState.BEYOND_HOPE;
            for (int i = 0; i < this.componentPositions.length; ++i) {
                ManagedVec3I v = this.componentPositions[i];
                if (v.vec.sum() <= 0) continue;
                BlockPos p = this.getOffsetPos(v.vec).func_177972_a(EnumFacing.func_82600_a((int)i).func_176734_d());
                this.field_145850_b.func_72885_a(null, (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5, 4.0f, true, true);
            }
        }
    }

    public void updateCriticalState() {
        if (!(this.field_145850_b instanceof WorldServer)) {
            return;
        }
        this.shieldCharge.value = this.field_145850_b.field_73012_v.nextInt(Math.max(1, (int)(this.maxShieldCharge.value * 0.01)));
        this.animExtractState.value = 1.0;
        this.temperature.value = MathHelper.approachExp((double)this.temperature.value, (double)12000.0, (double)5.0E-4);
        if (DEConfig.disableLargeReactorBoom) {
            if (this.explosionCountdown.value == -1) {
                this.explosionCountdown.value = 1200 + this.field_145850_b.field_73012_v.nextInt(2400);
            }
            if (this.explosionCountdown.value-- <= 0) {
                this.minimalBoom();
            }
            return;
        }
        if (this.explosionProcess == null) {
            double radius = Utils.map((double)(this.convertedFuel.value + this.reactableFuel.value), (double)144.0, (double)10368.0, (double)50.0, (double)350.0) * DEConfig.reactorExplosionScale;
            this.explosionProcess = new ProcessExplosion(this.field_174879_c, (int)radius, (WorldServer)this.field_145850_b, -1);
            ProcessHandler.addProcess((IProcess)this.explosionProcess);
            this.explosionCountdown.value = -1;
            this.minExplosionDelay = 1200 + this.field_145850_b.field_73012_v.nextInt(2400);
            return;
        }
        --this.minExplosionDelay;
        if (!this.explosionProcess.isCalculationComplete()) {
            return;
        }
        if (this.explosionCountdown.value == -1) {
            this.explosionCountdown.value = 1200 + Math.max(0, this.minExplosionDelay);
        }
        if (this.explosionCountdown.value-- <= 0) {
            this.explosionProcess.detonate();
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    public boolean canCharge() {
        if (!this.field_145850_b.field_72995_K && !this.validateStructure()) {
            return false;
        }
        if (this.reactorState.value == ReactorState.BEYOND_HOPE) {
            return false;
        }
        return (this.reactorState.value == ReactorState.COLD || this.reactorState.value == ReactorState.COOLING) && this.reactableFuel.value + this.convertedFuel.value >= 144.0;
    }

    public boolean canActivate() {
        if (!this.field_145850_b.field_72995_K && !this.validateStructure()) {
            return false;
        }
        if (this.reactorState.value == ReactorState.BEYOND_HOPE) {
            return false;
        }
        return (this.reactorState.value == ReactorState.WARMING_UP || this.reactorState.value == ReactorState.STOPPING) && this.temperature.value >= 2000.0 && (this.saturation.value >= this.maxSaturation.value / 2 && this.shieldCharge.value >= this.maxShieldCharge.value / 2.0 || this.reactorState.value == ReactorState.STOPPING);
    }

    public boolean canStop() {
        if (this.reactorState.value == ReactorState.BEYOND_HOPE) {
            return false;
        }
        return this.reactorState.value == ReactorState.RUNNING || this.reactorState.value == ReactorState.WARMING_UP;
    }

    public void chargeReactor() {
        if (this.field_145850_b.field_72995_K) {
            LogHelper.dev("Reactor: Start Charging");
            this.sendPacketToServer(output -> output.writeByte(0), 0);
        } else if (this.canCharge()) {
            LogHelper.dev("Reactor: Start Charging");
            this.reactorState.value = ReactorState.WARMING_UP;
        }
    }

    public void activateReactor() {
        if (this.field_145850_b.field_72995_K) {
            LogHelper.dev("Reactor: Activate");
            this.sendPacketToServer(output -> output.writeByte(1), 0);
        } else if (this.canActivate()) {
            LogHelper.dev("Reactor: Activate");
            this.reactorState.value = ReactorState.RUNNING;
        }
    }

    public void shutdownReactor() {
        if (this.field_145850_b.field_72995_K) {
            LogHelper.dev("Reactor: Shutdown");
            this.sendPacketToServer(output -> output.writeByte(2), 0);
        } else if (this.canStop()) {
            LogHelper.dev("Reactor: Shutdown");
            this.reactorState.value = ReactorState.STOPPING;
        }
    }

    public void toggleFailSafe() {
        if (this.field_145850_b.field_72995_K) {
            this.sendPacketToServer(output -> output.writeByte(3), 0);
        } else {
            this.failSafeMode.value = !this.failSafeMode.value;
        }
    }

    public void onComponentClicked(EntityPlayer player, TileReactorComponent component) {
        if (!this.field_145850_b.field_72995_K) {
            player.openGui((Object)DraconicEvolution.instance, 14, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            this.sendPacketToClient((EntityPlayerMP)player, output -> output.writePos(component.func_174877_v()), 1);
        }
    }

    public void receivePacketFromClient(MCDataInput data, EntityPlayerMP client, int id) {
        byte func = data.readByte();
        if (id == 0 && func == 0) {
            this.chargeReactor();
        } else if (id == 0 && func == 1) {
            this.activateReactor();
        } else if (id == 0 && func == 2) {
            this.shutdownReactor();
        } else if (id == 0 && func == 3) {
            this.toggleFailSafe();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void receivePacketFromServer(MCDataInput data, int id) {
        if (id == 1) {
            BlockPos pos = data.readPos();
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (tile instanceof TileReactorComponent && screen instanceof GuiReactor) {
                ((GuiReactor)screen).component = (TileReactorComponent)tile;
            }
        }
    }

    private void checkPlayerCollision() {
        EntityPlayer player = BrandonsCore.proxy.getClientPlayer();
        double distance = Math.min(Utils.getDistanceAtoB((Vec3D)new Vec3D((Entity)player).add(0.0, (double)player.eyeHeight, 0.0), (Vec3D)Vec3D.getCenter((BlockPos)this.field_174879_c)), Utils.getDistanceAtoB((Vec3D)new Vec3D((Entity)player), (Vec3D)Vec3D.getCenter((BlockPos)this.field_174879_c)));
        if (distance < this.getCoreDiameter() / 2.0 + 0.5) {
            double dMod = 1.0 - distance / Math.max(0.1, this.getCoreDiameter() / 2.0 + 0.5);
            double offsetX = player.field_70165_t - (double)this.field_174879_c.func_177958_n() + 0.5;
            double offsetY = player.field_70163_u - (double)this.field_174879_c.func_177956_o() + 0.5;
            double offsetZ = player.field_70161_v - (double)this.field_174879_c.func_177952_p() + 0.5;
            double m = 1.0 * dMod;
            player.func_70024_g(offsetX * m, offsetY * m, offsetZ * m);
        }
    }

    public void pokeCore(TileReactorComponent component, EnumFacing pokeFrom) {
        LogHelper.dev("Reactor: Core Poked, StructValid: " + this.structureValid);
        if (this.structureValid.value) {
            TileEntity tile;
            if (component instanceof TileReactorEnergyInjector && !component.isBound.value && (tile = this.field_145850_b.func_175625_s(this.getOffsetPos(this.componentPositions[pokeFrom.func_176745_a()].vec))) == this) {
                this.componentPositions[pokeFrom.func_176745_a()].vec = this.getOffsetVec(component.func_174877_v());
                component.bindToCore(this);
                LogHelper.dev("Reactor: Injector Added!");
            }
            this.validateStructure();
        } else {
            this.attemptInitialization();
        }
    }

    public void componentBroken(TileReactorComponent component, EnumFacing componentSide) {
        if (!this.structureValid.value || this.reactorState.value == ReactorState.BEYOND_HOPE) {
            return;
        }
        if (component instanceof TileReactorEnergyInjector) {
            LogHelper.dev("Reactor: Component broken! (Injector)");
            TileEntity tile = this.field_145850_b.func_175625_s(this.getOffsetPos(this.componentPositions[componentSide.func_176745_a()].vec));
            if (tile == component || tile == null) {
                LogHelper.dev("Reactor: -Removed");
                this.componentPositions[componentSide.func_176745_a()].vec.set(0, 0, 0);
            }
        } else if (this.reactorState.value != ReactorState.COLD) {
            LogHelper.dev("Reactor: Component broken, Structure Invalidated (Unsafe!!!!)");
            if (this.temperature.value > 2000.0) {
                this.reactorState.value = ReactorState.BEYOND_HOPE;
            } else if (this.temperature.value >= 350.0) {
                this.minimalBoom();
            } else {
                this.reactorState.value = ReactorState.INVALID;
            }
            this.structureValid.value = false;
        } else {
            LogHelper.dev("Reactor: Component broken, Structure Invalidated (Safe)");
            this.structureValid.value = false;
            this.reactorState.value = ReactorState.INVALID;
        }
    }

    public void checkBlockIntrusions() {
        if (!(this.field_145850_b instanceof WorldServer)) {
            return;
        }
        if (this.tick % 100 == 0) {
            double rad = this.getCoreDiameter() * 1.05 / 2.0;
            Iterable inRange = BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177963_a(-rad, -rad, -rad), (BlockPos)this.field_174879_c.func_177963_a(rad + 1.0, rad + 1.0, rad + 1.0));
            for (BlockPos p : inRange) {
                if (p.equals((Object)this.field_174879_c) || Utils.getDistanceAtoB((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) - 0.5 >= rad || this.field_145850_b.func_175623_d(p) || this.blockIntrusions.containsKey(p)) continue;
                this.blockIntrusions.put(p, 0);
            }
        }
        if (this.blockIntrusions.size() > 0) {
            Iterator<Map.Entry<BlockPos, Integer>> i = this.blockIntrusions.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<BlockPos, Integer> entry = i.next();
                Vec3D iPos = new Vec3D(entry.getKey());
                if (this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                    ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.FLAME, false, iPos.x, iPos.y, iPos.z, 5, this.field_145850_b.field_73012_v.nextDouble(), this.field_145850_b.field_73012_v.nextDouble(), this.field_145850_b.field_73012_v.nextDouble(), 0.01, new int[0]);
                }
                entry.setValue(entry.getValue() + 1);
                if (entry.getValue() <= 100) continue;
                i.remove();
                this.field_145850_b.func_175718_b(2001, entry.getKey(), Block.func_176210_f((IBlockState)this.field_145850_b.func_180495_p(entry.getKey())));
                this.field_145850_b.func_175698_g(entry.getKey());
            }
            if (this.tick % 20 == 0 || this.field_145850_b.field_73012_v.nextInt(40) == 0) {
                DESoundHandler.playSoundFromServer(this.field_145850_b, Vec3D.getCenter((BlockPos)this.field_174879_c), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f, false, 64.0);
            }
        }
    }

    public void attemptInitialization() {
        LogHelper.dev("Reactor: Attempt Initialization");
        if (!this.findComponents()) {
            LogHelper.dev("Failed fo find components");
            return;
        }
        if (!this.checkStabilizerAxis()) {
            LogHelper.dev("Failed stabilizer check");
            return;
        }
        if (!this.bindComponents()) {
            LogHelper.dev("Failed fo bind components");
            return;
        }
        this.structureValid.value = true;
        if (this.reactorState.value == ReactorState.INVALID) {
            this.reactorState.value = this.temperature.value <= 100.0 ? ReactorState.COLD : ReactorState.COOLING;
        }
        LogHelper.dev("Reactor: Structure Successfully Initialized!\n");
    }

    public boolean findComponents() {
        LogHelper.dev("Reactor: Find Components");
        int stabilizersFound = 0;
        block0: for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.componentPositions[facing.func_176745_a()].vec.set(0, 0, 0);
            for (int i = 4; i < 8; ++i) {
                BlockPos searchPos = this.field_174879_c.func_177967_a(facing, i);
                if (this.field_145850_b.func_175623_d(searchPos)) continue;
                TileEntity searchTile = this.field_145850_b.func_175625_s(searchPos);
                LogHelper.dev("Reactor: -Found: " + searchTile);
                if (!(searchTile instanceof TileReactorComponent) || ((TileReactorComponent)searchTile).facing.value != facing.func_176734_d() || i < 2) continue block0;
                LogHelper.dev("Set " + facing.func_176745_a() + " " + this.getOffsetVec(searchPos));
                this.componentPositions[facing.func_176745_a()].vec = this.getOffsetVec(searchPos);
                if (!(searchTile instanceof TileReactorStabilizer)) continue block0;
                ++stabilizersFound;
                continue block0;
            }
        }
        LogHelper.dev("Reactor: Find Components | found " + stabilizersFound + " Stabilizers");
        return stabilizersFound == 4;
    }

    public boolean checkStabilizerAxis() {
        LogHelper.dev("Reactor: Check Stabilizer Axis");
        for (EnumFacing.Axis axis : EnumFacing.Axis.values()) {
            boolean axisValid = true;
            for (EnumFacing facing : FacingUtils.getFacingsAroundAxis((EnumFacing.Axis)axis)) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.getOffsetPos(this.componentPositions[facing.func_176745_a()].vec));
                if (tile instanceof TileReactorStabilizer && ((TileReactorStabilizer)tile).facing.value == facing.func_176734_d()) continue;
                axisValid = false;
                break;
            }
            if (!axisValid) continue;
            this.stabilizerAxis.value = axis;
            LogHelper.dev("Reactor: -Found Valid Axis: " + axis);
            return true;
        }
        return false;
    }

    public boolean bindComponents() {
        LogHelper.dev("Reactor: Binding Components");
        int stabilizersBound = 0;
        for (int i = 0; i < 6; ++i) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.getOffsetPos(this.componentPositions[i].vec));
            if (!(tile instanceof TileReactorComponent)) continue;
            ((TileReactorComponent)tile).bindToCore(this);
            if (!(tile instanceof TileReactorStabilizer)) continue;
            ++stabilizersBound;
        }
        return stabilizersBound == 4;
    }

    public boolean validateStructure() {
        LogHelper.dev("Reactor: Validate Structure");
        for (EnumFacing facing : FacingUtils.getFacingsAroundAxis((EnumFacing.Axis)((EnumFacing.Axis)this.stabilizerAxis.value))) {
            BlockPos pos = this.getOffsetPos(this.componentPositions[facing.func_176745_a()].vec);
            if (!this.field_145850_b.func_175726_f(pos).func_177410_o()) {
                return true;
            }
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            LogHelper.dev("Reactor: Validate Stabilizer: " + tile);
            if (!(tile instanceof TileReactorStabilizer) || !((TileReactorStabilizer)tile).getCorePos().equals((Object)this.field_174879_c)) {
                LogHelper.dev("Reactor: Structure Validation Failed!!!");
                return false;
            }
            for (ManagedVec3I vec : this.componentPositions) {
                pos = this.getOffsetPos(vec.vec);
                tile = this.field_145850_b.func_175625_s(pos);
                if (tile instanceof TileReactorEnergyInjector && !((TileReactorEnergyInjector)tile).isBound.value) {
                    ((TileReactorEnergyInjector)tile).bindToCore(this);
                }
                if (!(tile instanceof TileReactorComponent) || !((TileReactorComponent)tile).getCorePos().equals((Object)this.field_174879_c) || ((TileReactorComponent)tile).isBound.value) continue;
                LogHelper.warn("Detected a reactor component in an invalid state. This is likely due to a recent bug that has since been fixed. The state of this component will now be corrected.");
                ((TileReactorComponent)tile).bindToCore(this);
            }
        }
        LogHelper.dev("Reactor: Structure Validated!");
        return true;
    }

    private void minimalBoom() {
        Fluid pyro;
        IBlockState lava = Blocks.field_150356_k.func_176223_P();
        LogHelper.dev(FluidRegistry.isFluidRegistered((String)"pyrotheum"));
        if (FluidRegistry.isFluidRegistered((String)"pyrotheum") && (pyro = FluidRegistry.getFluid((String)"pyrotheum")).canBePlacedInWorld()) {
            lava = pyro.getBlock().func_176223_P();
        }
        Vec3D vec = Vec3D.getCenter((BlockPos)this.field_174879_c);
        this.field_145850_b.func_175698_g(this.field_174879_c);
        this.field_145850_b.func_72876_a(null, vec.x, vec.y, vec.z, 8.0f, true);
        int c = 25 + this.field_145850_b.field_73012_v.nextInt(25);
        for (int i = 0; i < c; ++i) {
            EntityFallingBlock entity = new EntityFallingBlock(this.field_145850_b, vec.x, vec.y, vec.z, lava);
            entity.field_145812_b = 1;
            entity.field_145813_c = false;
            double vMod = 0.5 + 2.0 * this.field_145850_b.field_73012_v.nextDouble();
            entity.func_70024_g((this.field_145850_b.field_73012_v.nextDouble() - 0.5) * vMod, this.field_145850_b.field_73012_v.nextDouble() / 1.5 * vMod, (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * vMod);
            this.field_145850_b.func_72838_d((Entity)entity);
        }
    }

    private BlockPos getOffsetPos(Vec3I vec) {
        return this.field_174879_c.func_177973_b((Vec3i)vec.getPos());
    }

    private Vec3I getOffsetVec(BlockPos offsetPos) {
        return new Vec3I(this.field_174879_c.func_177973_b((Vec3i)offsetPos));
    }

    public TileReactorComponent getComponent(EnumFacing facing) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.getOffsetPos(this.componentPositions[facing.func_176745_a()].vec));
        if (tile instanceof TileReactorComponent && ((TileReactorComponent)tile).facing.value == facing.func_176734_d()) {
            return (TileReactorComponent)tile;
        }
        return null;
    }

    public int injectEnergy(int rf) {
        int received = 0;
        if (this.reactorState.value == ReactorState.WARMING_UP) {
            if (!this.startupInitialized.value) {
                return 0;
            }
            if (this.shieldCharge.value < this.maxShieldCharge.value / 2.0) {
                received = Math.min(rf, (int)(this.maxShieldCharge.value / 2.0) - (int)this.shieldCharge.value + 1);
                this.shieldCharge.value += (double)received;
                if (this.shieldCharge.value > this.maxShieldCharge.value / 2.0) {
                    this.shieldCharge.value = this.maxShieldCharge.value / 2.0;
                }
            } else if (this.saturation.value < this.maxSaturation.value / 2) {
                received = Math.min(rf, this.maxSaturation.value / 2 - this.saturation.value);
                this.saturation.value += received;
            } else if (this.temperature.value < 2000.0) {
                received = rf;
                this.temperature.value += (double)received / (1000.0 + this.reactableFuel.value * 10.0);
                if (this.temperature.value > 2500.0) {
                    this.temperature.value = 2500.0;
                }
            }
        } else if (this.reactorState.value == ReactorState.RUNNING || this.reactorState.value == ReactorState.STOPPING) {
            double tempFactor = 1.0;
            if (this.temperature.value > 15000.0) {
                tempFactor = 1.0 - Math.min(1.0, (this.temperature.value - 15000.0) / 10000.0);
            }
            this.shieldCharge.value += Math.min((double)rf * (1.0 - this.shieldCharge.value / this.maxShieldCharge.value), this.maxShieldCharge.value - this.shieldCharge.value) * tempFactor;
            if (this.shieldCharge.value > this.maxShieldCharge.value) {
                this.shieldCharge.value = this.maxShieldCharge.value;
            }
            return rf;
        }
        return received;
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 40960.0;
    }

    public double getCoreDiameter() {
        double volume = (this.reactableFuel.value + this.convertedFuel.value) / 1296.0;
        double diameter = Math.cbrt((volume *= 1.0 + this.temperature.value / 10000.0 * 10.0) / Math.PI) * 2.0;
        return Math.max(0.5, diameter);
    }

    public static enum ReactorState {
        INVALID(false),
        COLD(false),
        WARMING_UP(true),
        RUNNING(true),
        STOPPING(true),
        COOLING(true),
        BEYOND_HOPE(true);

        private final boolean shieldActive;

        private ReactorState(boolean shieldActive) {
            this.shieldActive = shieldActive;
        }

        public boolean isShieldActive() {
            return this.shieldActive;
        }

        @SideOnly(value=Side.CLIENT)
        public String localize() {
            TextFormatting[] colours = new TextFormatting[]{TextFormatting.RED, TextFormatting.DARK_AQUA, TextFormatting.LIGHT_PURPLE, TextFormatting.GREEN, TextFormatting.LIGHT_PURPLE, TextFormatting.LIGHT_PURPLE, TextFormatting.DARK_RED};
            return colours[this.ordinal()] + I18n.func_135052_a((String)("gui.reactor.status." + this.name().toLowerCase() + ".info"), (Object[])new Object[0]);
        }
    }

    public static class Roller {
        public Vec3D pos;
        public Vec3D lastPos;
        public double direction;
        private World world;
        private double diameter;
        public double fallVelocity = 0.0;
        public double speed = 0.0;
        public int age = 0;

        public Roller(Vec3D pos, World world, double diameter) {
            this.pos = pos;
            this.lastPos = pos.copy();
            this.direction = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            this.world = world;
            this.diameter = diameter / 2.0 + 1.0;
            this.speed = -0.3;
        }

        public void update() {
            int y;
            this.lastPos = this.pos.copy();
            double x = Math.cos(this.direction);
            double z = Math.sin(this.direction);
            BlockPos p = this.pos.getPos();
            if (this.world.func_175623_d(p) || this.world.func_180495_p(p).func_177230_c() == DEFeatures.reactorCore) {
                while ((this.world.func_175623_d(p) || this.world.func_180495_p(p).func_177230_c() == DEFeatures.reactorCore) && p.func_177956_o() > 0) {
                    p = p.func_177977_b();
                }
            } else {
                while (!this.world.func_175623_d(p)) {
                    p = p.func_177984_a();
                }
            }
            this.fallVelocity = this.pos.y > (double)(y = p.func_177956_o()) + this.diameter ? (this.fallVelocity += 0.1) : 0.0;
            this.pos.y -= this.fallVelocity;
            if (this.pos.y < (double)y + this.diameter && this.fallVelocity > 0.0) {
                this.pos.y = (double)y + this.diameter;
            }
            if ((double)y + this.diameter > this.pos.y) {
                this.pos.y += ((double)y + this.diameter - this.pos.y) * Math.max(this.speed, 0.1);
            }
            if (this.speed < 0.5 && this.fallVelocity == 0.0) {
                this.speed += 0.01;
            }
            if (this.speed > 0.0) {
                this.pos.add(x * this.speed, 0.0, z * this.speed);
            }
            ++this.age;
        }
    }
}

