/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.balancedclaytools;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.balancedclaytools.ItemAxeClay;
import pl.asie.balancedclaytools.ItemPickaxeClay;
import pl.asie.balancedclaytools.ItemShovelClay;
import pl.asie.balancedclaytools.ProxyCommon;

@Mod(modid="balancedclaytools", name="Balanced Clay Tools", version="0.1.0", dependencies="after:preston", acceptedMinecraftVersions="[1.12.2]")
public class ModBalancedClayTools {
    @SidedProxy(modId="balancedclaytools", clientSide="pl.asie.balancedclaytools.ProxyClient", serverSide="pl.asie.balancedclaytools.ProxyCommon")
    public static ProxyCommon proxy;
    public static Item clayPickaxe;
    public static Item clayAxe;
    public static Item clayShovel;
    public static int prestonRecipeCompressionLevel;

    private Item prepare(Item toolItem, String name) {
        toolItem.func_77637_a(CreativeTabs.field_78040_i);
        toolItem.setRegistryName("balancedclaytools:" + name);
        toolItem.func_77655_b(name);
        return toolItem;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        clayPickaxe = this.prepare((Item)new ItemPickaxeClay(), "clay_pickaxe");
        clayAxe = this.prepare((Item)new ItemAxeClay(), "clay_axe");
        clayShovel = this.prepare((Item)new ItemShovelClay(), "clay_shovel");
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        prestonRecipeCompressionLevel = config.getInt("recipeCompressionLevel", "general", 8, -1, 1000, "Set the level of compression for the clay blocks required for this item. If 0, uses vanilla clay (otherwise requires Preston!). If -1, the recipe is disabled.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onRegisterItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{clayPickaxe, clayAxe, clayShovel});
    }

    private void createRecipe(Item result, String row1, String row2, String row3, ItemStack compressedStack, IForgeRegistry<IRecipe> registry) {
        ShapedOreRecipe recipe = new ShapedOreRecipe(new ResourceLocation("balancedclaytools:clay_pickaxe"), result, new Object[]{row1, row2, row3, Character.valueOf('C'), compressedStack, Character.valueOf('S'), "stickWood"}).setMirrored(true);
        recipe.setRegistryName(result.getRegistryName());
        registry.register((IForgeRegistryEntry)recipe);
    }

    @SubscribeEvent
    public void onRegisterRecipe(RegistryEvent.Register<IRecipe> event) {
        ItemStack clayStack;
        ItemStack compressedStack;
        if (prestonRecipeCompressionLevel >= 0 && !(compressedStack = proxy.compressItem(clayStack = new ItemStack(Blocks.field_150435_aG, 1), prestonRecipeCompressionLevel)).func_190926_b()) {
            this.createRecipe(clayPickaxe, "CCC", " S ", " S ", compressedStack, (IForgeRegistry<IRecipe>)event.getRegistry());
            this.createRecipe(clayAxe, "CC", "CS", " S", compressedStack, (IForgeRegistry<IRecipe>)event.getRegistry());
            this.createRecipe(clayShovel, "C", "S", "S", compressedStack, (IForgeRegistry<IRecipe>)event.getRegistry());
        }
    }
}

