/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers.dynamo;

import cofh.thermalexpansion.util.managers.dynamo.SteamManager;
import cofh.thermalexpansion.util.parsers.BaseParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;

public class SteamParser
extends BaseParser {
    int defaultEnergy = SteamManager.DEFAULT_ENERGY;

    @Override
    public void parseArray(JsonArray contentArray) {
        for (JsonElement contentElement : contentArray) {
            JsonObject content = contentElement.getAsJsonObject();
            if (content.has("//")) continue;
            int energy = this.defaultEnergy;
            ItemStack input = SteamParser.parseItemStack(content.get("input"));
            if (content.has("energy")) {
                energy = content.get("energy").getAsInt();
            } else if (content.has("energy_mod")) {
                energy = content.get("energy_mod").getAsInt() * this.defaultEnergy / 100;
            }
            if (SteamManager.addFuel(input, energy)) {
                ++this.parseCount;
                continue;
            }
            ++this.errorCount;
        }
    }
}

