/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers;

import cofh.core.init.CoreProps;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.parsers.ConstantParser;
import cofh.thermalexpansion.util.parsers.IContentParser;
import cofh.thermalexpansion.util.parsers.OreDictParser;
import cofh.thermalexpansion.util.parsers.dynamo.CompressionParser;
import cofh.thermalexpansion.util.parsers.dynamo.EnervationParser;
import cofh.thermalexpansion.util.parsers.dynamo.MagmaticParser;
import cofh.thermalexpansion.util.parsers.dynamo.NumismaticParser;
import cofh.thermalexpansion.util.parsers.dynamo.ReactantParser;
import cofh.thermalexpansion.util.parsers.dynamo.SteamParser;
import cofh.thermalexpansion.util.parsers.machine.ChargerParser;
import cofh.thermalexpansion.util.parsers.machine.CompactorParser;
import cofh.thermalexpansion.util.parsers.machine.CrucibleParser;
import cofh.thermalexpansion.util.parsers.machine.FurnaceParser;
import cofh.thermalexpansion.util.parsers.machine.PulverizerParser;
import cofh.thermalexpansion.util.parsers.machine.RefineryParser;
import cofh.thermalexpansion.util.parsers.machine.SawmillParser;
import cofh.thermalexpansion.util.parsers.machine.SmelterParser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ContentParser {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static File contentFolder;
    private static Map<String, IContentParser> contentParsers;

    private ContentParser() {
    }

    public static void initialize() {
        contentFolder = new File(CoreProps.configDir, "/cofh/thermalexpansion/content/");
        if (!contentFolder.exists()) {
            try {
                contentFolder.mkdir();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        contentParsers.put("oredict", new OreDictParser());
        contentParsers.put("constants", new ConstantParser());
        contentParsers.put("furnace", new FurnaceParser());
        contentParsers.put("pulverizer", new PulverizerParser());
        contentParsers.put("sawmill", new SawmillParser());
        contentParsers.put("smelter", new SmelterParser());
        contentParsers.put("compactor", new CompactorParser());
        contentParsers.put("crucible", new CrucibleParser());
        contentParsers.put("refinery", new RefineryParser());
        contentParsers.put("charger", new ChargerParser());
        contentParsers.put("dynamo_steam", new SteamParser());
        contentParsers.put("dynamo_magmatic", new MagmaticParser());
        contentParsers.put("dynamo_compression", new CompressionParser());
        contentParsers.put("dynamo_reactant", new ReactantParser());
        contentParsers.put("dynamo_enervation", new EnervationParser());
        contentParsers.put("dynamo_numismatic", new NumismaticParser());
    }

    private static void copyInternalFiles() {
    }

    private static void addConstantFiles(ArrayList<File> list, File folder) {
        File[] fList = folder.listFiles((file, name) -> name != null && (name.toLowerCase(Locale.US).endsWith(".json") && name.startsWith("_") || new File(file, name).isDirectory()));
        if (fList == null || fList.length <= 0) {
            return;
        }
        list.addAll(Arrays.asList(fList));
    }

    private static void addContentFiles(ArrayList<File> list, File folder) {
        File[] fList = folder.listFiles((file, name) -> name != null && (name.toLowerCase(Locale.US).endsWith(".json") && !name.startsWith("_") || new File(file, name).isDirectory()));
        if (fList == null || fList.length <= 0) {
            return;
        }
        list.addAll(Arrays.asList(fList));
    }

    public static void parseFiles() {
        ModContainer mod = FMLCommonHandler.instance().findContainerFor((Object)"thermalexpansion");
        ContentParser.parseCustomConstants();
        ContentParser.parseConstants(mod);
        ContentParser.parseCustomContent();
        ContentParser.parseContent(mod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseCustomConstants() {
        ArrayList<File> constantList = new ArrayList<File>();
        ContentParser.addConstantFiles(constantList, contentFolder);
        for (int i = 0; i < constantList.size(); ++i) {
            File file = constantList.get(i);
            if (file.isDirectory()) {
                ContentParser.addConstantFiles(constantList, file);
                continue;
            }
            String fileName = file.getName();
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file.toPath());
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                for (Map.Entry contentEntry : json.entrySet()) {
                    if (ContentParser.parseEntry((String)contentEntry.getKey(), (JsonElement)contentEntry.getValue())) {
                        ThermalExpansion.LOG.debug("Content entry added from file " + fileName + ": \"" + (String)contentEntry.getKey() + "\"");
                        continue;
                    }
                    ThermalExpansion.LOG.error("Error parsing entry from file " + fileName + ": \"" + (String)contentEntry.getKey() + "\" > Please make sure the entry is a valid JSON Array.");
                }
                continue;
            }
            catch (Exception e) {
                ThermalExpansion.LOG.error("Error parsing content file " + fileName + "!", (Throwable)e);
                continue;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseCustomContent() {
        ArrayList<File> contentList = new ArrayList<File>();
        ContentParser.addContentFiles(contentList, contentFolder);
        for (int i = 0; i < contentList.size(); ++i) {
            File file = contentList.get(i);
            if (file.isDirectory()) {
                ContentParser.addContentFiles(contentList, file);
                continue;
            }
            String fileName = file.getName();
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file.toPath());
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                for (Map.Entry contentEntry : json.entrySet()) {
                    if (ContentParser.parseEntry((String)contentEntry.getKey(), (JsonElement)contentEntry.getValue())) {
                        ThermalExpansion.LOG.debug("Content entry added from file " + fileName + ": \"" + (String)contentEntry.getKey() + "\"");
                        continue;
                    }
                    ThermalExpansion.LOG.error("Error parsing entry from file " + fileName + ": \"" + (String)contentEntry.getKey() + "\" > Please make sure the entry is a valid JSON Array.");
                }
                continue;
            }
            catch (Exception e) {
                ThermalExpansion.LOG.error("Error parsing content file " + fileName + "!", (Throwable)e);
                continue;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
    }

    public static void parseConstants(ModContainer mod) {
        CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/content/"), null, (root, file) -> {
            String fileName = file.getFileName().toString();
            if (!"json".equals(FilenameUtils.getExtension((String)fileName)) || !fileName.startsWith("_")) {
                return true;
            }
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file);
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                for (Map.Entry contentEntry : json.entrySet()) {
                    if (ContentParser.parseEntry((String)contentEntry.getKey(), (JsonElement)contentEntry.getValue())) {
                        ThermalExpansion.LOG.debug("Content entry added from file " + fileName + ": \"" + (String)contentEntry.getKey() + "\"");
                        continue;
                    }
                    ThermalExpansion.LOG.error("Error parsing entry from file " + fileName + ": \"" + (String)contentEntry.getKey() + "\" > Please make sure the entry is a valid JSON Array.");
                }
            }
            catch (Exception e) {
                ThermalExpansion.LOG.error("Error parsing content file " + fileName + "!", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            return true;
        }, (boolean)false, (boolean)false);
    }

    public static void parseContent(ModContainer mod) {
        CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/content/"), null, (root, file) -> {
            String fileName = file.getFileName().toString();
            if (!"json".equals(FilenameUtils.getExtension((String)fileName)) || fileName.startsWith("_")) {
                return true;
            }
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file);
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                for (Map.Entry contentEntry : json.entrySet()) {
                    if (ContentParser.parseEntry((String)contentEntry.getKey(), (JsonElement)contentEntry.getValue())) {
                        ThermalExpansion.LOG.debug("Content entry added from file " + fileName + ": \"" + (String)contentEntry.getKey() + "\"");
                        continue;
                    }
                    ThermalExpansion.LOG.error("Error parsing entry from file " + fileName + ": \"" + (String)contentEntry.getKey() + "\" > Please make sure the entry is a valid JSON Array.");
                }
            }
            catch (Exception e) {
                ThermalExpansion.LOG.error("Error parsing content file " + fileName + "!", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            return true;
        }, (boolean)false, (boolean)false);
    }

    private static boolean parseEntry(String type, JsonElement content) {
        if (contentParsers.containsKey(type)) {
            return contentParsers.get(type).parseContent(content);
        }
        return false;
    }

    static {
        contentParsers = new Object2ObjectOpenHashMap();
    }
}

