/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.render;

import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.model.bakery.generation.ILayeredBlockBakery;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BakeryDynamo
implements ILayeredBlockBakery {
    public static final BakeryDynamo INSTANCE = new BakeryDynamo();
    private static CCModel[][] modelCoil = new CCModel[2][6];
    private static CCModel[][] modelBase = new CCModel[2][6];
    private static CCModel[][] modelBaseOverlay = new CCModel[2][6];
    private static CCModel[] modelCoilAnimation = new CCModel[6];
    private static CCModel[] modelBaseAnimation = new CCModel[6];

    private static void generateModels() {
        double d1 = 0.001953125;
        double d2 = 0.375;
        double d3 = 0.625;
        double d4 = 0.25;
        double d5 = 0.75;
        BakeryDynamo.modelCoil[0][1] = CCModel.quadModel((int)48).generateBox(0, -4.0, 0.0, -4.0, 8.0, 8.0 - d1, 8.0, 0.0, 0.0, 32.0, 32.0, 16.0);
        BakeryDynamo.modelCoil[1][1] = CCModel.quadModel((int)48).generateBox(0, -4.0, 0.0, -4.0, 8.0, 8.0 - d1, 8.0, 0.0, 16.0, 32.0, 32.0, 16.0);
        CCModel.generateBackface((CCModel)modelCoil[0][1], (int)0, (CCModel)modelCoil[0][1], (int)24, (int)24);
        CCModel.generateBackface((CCModel)modelCoil[1][1], (int)0, (CCModel)modelCoil[1][1], (int)24, (int)24);
        modelCoil[0][1].computeNormals().shrinkUVs(d1);
        modelCoil[1][1].computeNormals().shrinkUVs(d1);
        BakeryDynamo.modelBase[0][1] = CCModel.quadModel((int)24).generateBox(0, -8.0, -8.0, -8.0, 16.0, 10.0, 16.0, 0.0, 0.0, 64.0, 64.0, 16.0).computeNormals().shrinkUVs(d1);
        BakeryDynamo.modelBase[1][1] = CCModel.quadModel((int)24).generateBox(0, -8.0, -8.0, -8.0, 16.0, 10.0, 16.0, 0.0, 32.0, 64.0, 64.0, 16.0).computeNormals().shrinkUVs(d1);
        BakeryDynamo.modelBaseOverlay[0][1] = CCModel.quadModel((int)24).generateBox(0, -8.0 - d1, -8.0 - d1, -8.0 - d1, 16.0 + 2.0 * d1, 10.0 + 2.0 * d1, 16.0 + 2.0 * d1, 0.0, 0.0, 64.0, 64.0, 16.0).computeNormals().shrinkUVs(d1);
        BakeryDynamo.modelBaseOverlay[1][1] = CCModel.quadModel((int)24).generateBox(0, -8.0 - d1, -8.0 - d1, -8.0 - d1, 16.0 + 2.0 * d1, 10.0 + 2.0 * d1, 16.0 + 2.0 * d1, 0.0, 32.0, 64.0, 64.0, 16.0).computeNormals().shrinkUVs(d1);
        BakeryDynamo.modelCoilAnimation[0] = CCModel.quadModel((int)16).generateBlock(0, d4 + d1, d1, d4 + d1, d5 - d1, 1.0 - d1, d5 - d1, 3).computeNormals();
        BakeryDynamo.modelCoilAnimation[1] = CCModel.quadModel((int)16).generateBlock(0, d4 + d1, d1, d4 + d1, d5 - d1, 1.0 - d1, d5 - d1, 3).computeNormals();
        BakeryDynamo.modelCoilAnimation[2] = CCModel.quadModel((int)16).generateBlock(0, d4 + d1, d4 + d1, d1, d5 - d1, d5 - d1, 1.0 - d1, 12).computeNormals();
        BakeryDynamo.modelCoilAnimation[3] = CCModel.quadModel((int)16).generateBlock(0, d4 + d1, d4 + d1, d1, d5 - d1, d5 - d1, 1.0 - d1, 12).computeNormals();
        BakeryDynamo.modelCoilAnimation[4] = CCModel.quadModel((int)16).generateBlock(0, d1, d4 + d1, d4 + d1, 1.0 - d1, d5 - d1, d5 - d1, 48).computeNormals();
        BakeryDynamo.modelCoilAnimation[5] = CCModel.quadModel((int)16).generateBlock(0, d1, d4 + d1, d4 + d1, 1.0 - d1, d5 - d1, d5 - d1, 48).computeNormals();
        BakeryDynamo.modelBaseAnimation[0] = CCModel.quadModel((int)16).generateBlock(0, d1, d2 + d1, d1, 1.0 - d1, 1.0 - d1, 1.0 - d1, 3).computeNormals();
        BakeryDynamo.modelBaseAnimation[1] = CCModel.quadModel((int)16).generateBlock(0, d1, d1, d1, 1.0 - d1, d3 - d1, 1.0 - d1, 3).computeNormals();
        BakeryDynamo.modelBaseAnimation[2] = CCModel.quadModel((int)16).generateBlock(0, d1, d1, d2 + d1, 1.0 - d1, 1.0 - d1, 1.0 - d1, 12).computeNormals();
        BakeryDynamo.modelBaseAnimation[3] = CCModel.quadModel((int)16).generateBlock(0, d1, d1, d1, 1.0 - d1, 1.0 - d1, d3 - d1, 12).computeNormals();
        BakeryDynamo.modelBaseAnimation[4] = CCModel.quadModel((int)16).generateBlock(0, d2 + d1, d1, d1, 1.0 - d1, 1.0 - d1, 1.0 - d1, 48).computeNormals();
        BakeryDynamo.modelBaseAnimation[5] = CCModel.quadModel((int)16).generateBlock(0, d1, d1, d1, d3 - d1, 1.0 - d1, 1.0 - d1, 48).computeNormals();
        for (CCModel[] model : modelCoil) {
            CCModel.generateSidedModels((CCModel[])model, (int)1, (Vector3)new Vector3());
        }
        for (CCModel[] model : modelBase) {
            CCModel.generateSidedModels((CCModel[])model, (int)1, (Vector3)new Vector3());
        }
        for (CCModel[] model : modelBaseOverlay) {
            CCModel.generateSidedModels((CCModel[])model, (int)1, (Vector3)new Vector3());
        }
    }

    protected void renderCoil(CCRenderState ccrs, int facing, boolean active, int type) {
        if (active) {
            modelCoil[0][facing].render(ccrs, new IVertexOperation[]{new Translation(0.5, 0.5, 0.5), new IconTransformation(TETextures.DYNAMO_COIL[type])});
        } else {
            modelCoil[1][facing].render(ccrs, new IVertexOperation[]{new Translation(0.5, 0.5, 0.5), new IconTransformation(TETextures.DYNAMO_COIL[type])});
        }
    }

    protected void renderBase(CCRenderState ccrs, int facing, boolean active, int type) {
        if (active) {
            modelBase[0][facing].render(ccrs, new IVertexOperation[]{new Translation(0.5, 0.5, 0.5), new IconTransformation(TETextures.DYNAMO[type])});
        } else {
            modelBase[1][facing].render(ccrs, new IVertexOperation[]{new Translation(0.5, 0.5, 0.5), new IconTransformation(TETextures.DYNAMO[type])});
        }
    }

    protected void renderBaseOverlay(CCRenderState ccrs, int facing, boolean active, TextureAtlasSprite sprite) {
        if (sprite != null) {
            if (active) {
                modelBaseOverlay[0][facing].render(ccrs, new IVertexOperation[]{new Translation(0.5, 0.5, 0.5), new IconTransformation(sprite)});
            } else {
                modelBaseOverlay[1][facing].render(ccrs, new IVertexOperation[]{new Translation(0.5, 0.5, 0.5), new IconTransformation(sprite)});
            }
        }
    }

    protected void renderCoilAnimation(CCRenderState ccrs, int facing, boolean active, TextureAtlasSprite icon) {
        if (active) {
            modelCoilAnimation[facing].render(ccrs, new IVertexOperation[]{new IconTransformation(icon)});
        }
    }

    protected void renderBaseAnimation(CCRenderState ccrs, int facing, boolean active, TextureAtlasSprite icon) {
        if (active) {
            modelBaseAnimation[facing].render(ccrs, new IVertexOperation[]{new IconTransformation(icon)});
        }
    }

    private static TextureAtlasSprite getOverlaySprite(EnumFacing face, int level) {
        if (level == 0) {
            return null;
        }
        return TETextures.DYNAMO_OVERLAY[level];
    }

    public IExtendedBlockState handleState(IExtendedBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.of((String)"Null tile. Position: %s", (Object[])new Object[]{pos}));
        }
        if (!(tile instanceof TileDynamoBase)) {
            return state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.of((String)"Tile is not an instance of TileDynamoBase, was %s. Pos: %s", (Object[])new Object[]{tile.getClass().getName(), pos}));
        }
        state = state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.OK);
        state = state.withProperty(TEProps.TILE_DYNAMO, (Object)((TileDynamoBase)tile));
        return state;
    }

    public List<BakedQuad> bakeItemQuads(EnumFacing face, ItemStack stack) {
        if (face == null && !stack.func_190926_b()) {
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((BufferBuilder)buffer);
            boolean creative = BlockDynamo.itemBlock.isCreative(stack);
            int level = BlockDynamo.itemBlock.getLevel(stack);
            this.renderCoil(ccrs, 1, false, 0);
            this.renderBase(ccrs, 1, false, stack.func_77960_j());
            if (TEProps.renderDynamoOverlay && level > 0) {
                this.renderBaseOverlay(ccrs, 1, false, creative ? TETextures.DYNAMO_OVERLAY_C : BakeryDynamo.getOverlaySprite(face, level));
            }
            buffer.func_178977_d();
            return buffer.bake();
        }
        return new ArrayList<BakedQuad>();
    }

    public List<BakedQuad> bakeLayerFace(EnumFacing face, BlockRenderLayer layer, IExtendedBlockState state) {
        if (face == null && state != null) {
            TileDynamoBase dynamo = (TileDynamoBase)((Object)state.getValue(TEProps.TILE_DYNAMO));
            boolean creative = dynamo.isCreative;
            boolean active = dynamo.isActive;
            int level = dynamo.getLevel();
            int facing = dynamo.getFacing();
            int coil = dynamo.getCoil();
            int type = ((BlockDynamo.Type)((Object)state.func_177229_b(BlockDynamo.VARIANT))).getMetadata();
            TextureAtlasSprite coilUnderlay = dynamo.getCoilUnderlayTexture();
            TextureAtlasSprite baseUnderlay = dynamo.getBaseUnderlayTexture();
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((BufferBuilder)buffer);
            if (layer == BlockRenderLayer.SOLID) {
                this.renderBaseAnimation(ccrs, facing, active, baseUnderlay);
            } else if (layer == BlockRenderLayer.CUTOUT) {
                this.renderCoil(ccrs, facing, active, coil);
                this.renderBase(ccrs, facing, active, type);
                if (TEProps.renderDynamoOverlay && level > 0) {
                    this.renderBaseOverlay(ccrs, facing, active, creative ? TETextures.DYNAMO_OVERLAY_C : BakeryDynamo.getOverlaySprite(face, level));
                }
            } else if (TileDynamoBase.COIL_UNDERLAY[coil]) {
                this.renderCoilAnimation(ccrs, facing, active, coilUnderlay);
            }
            buffer.func_178977_d();
            return buffer.bake();
        }
        return new ArrayList<BakedQuad>();
    }

    static {
        BakeryDynamo.generateModels();
    }
}

