/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.items.wateringcan;

import com.kashdeya.tinyprogressions.inits.TechItems;
import com.kashdeya.tinyprogressions.main.TinyProgressions;
import com.kashdeya.tinyprogressions.util.CanUtil;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class WateringCanBase
extends Item {
    private int range = 1;
    private int waterChance = 100;
    private boolean canWater = false;
    private boolean showParticlTicks = false;
    private boolean forceActive = false;
    private long ticksInUse;
    int clicks = 0;

    public WateringCanBase() {
        this.func_77625_d(1);
        this.func_77637_a(TinyProgressions.tabTP);
    }

    protected void setWateringRange(int newRange) {
        this.range = newRange;
    }

    protected void setWateringChance(int newChance) {
        this.waterChance = newChance;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ++this.ticksInUse;
        if (this.ticksInUse % 4L == 0L) {
            this.showParticlTicks = true;
            this.canWater = true;
        }
        if (this.forceActive && entityIn instanceof EntityPlayer) {
            RayTraceResult raytrace;
            ItemStack offhand;
            EntityPlayer player = (EntityPlayer)entityIn;
            if (!isSelected && (offhand = player.func_184586_b(EnumHand.OFF_HAND)).func_77973_b() != TechItems.watering_can && offhand.func_77973_b() != TechItems.watering_can_upgrade) {
                this.forceActive = false;
            }
            if ((raytrace = this.func_77621_a(worldIn, player, false)) != null && raytrace.field_72313_a == RayTraceResult.Type.BLOCK) {
                this.attemptWaterParticles(worldIn, raytrace.func_178782_a());
                this.attemptWater(worldIn, raytrace.func_178782_a());
            }
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.func_77636_d(stack) ? EnumRarity.UNCOMMON : EnumRarity.COMMON;
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.forceActive;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && player.func_70093_af()) {
            int wateringcanCount = (int)IntStream.range(0, player.field_71071_by.func_70302_i_()).mapToObj(i -> player.field_71071_by.func_70301_a(i)).filter(itemstack -> itemstack != ItemStack.field_190927_a).map(ItemStack::func_77973_b).filter(item -> item == TechItems.watering_can || item == TechItems.watering_can_upgrade).count();
            if (wateringcanCount <= 1) {
                if (wateringcanCount == 1) {
                    this.forceActive = !this.forceActive;
                }
                return EnumActionResult.FAIL;
            }
            this.forceActive = false;
            player.func_145747_a((ITextComponent)new TextComponentTranslation("item.watering_can.invalidusage", new Object[0]));
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, player.func_184586_b(hand))) {
            return EnumActionResult.FAIL;
        }
        this.attemptWaterParticles(world, pos);
        return this.attemptWater(world, pos);
    }

    private EnumActionResult attemptWater(World world, BlockPos pos) {
        if (!world.field_72995_K && this.canWater) {
            this.canWater = false;
            int chance = CanUtil.randInt(1, 100);
            if (chance <= this.waterChance) {
                for (int xAxis = -this.range; xAxis <= this.range; ++xAxis) {
                    for (int zAxis = -this.range; zAxis <= this.range; ++zAxis) {
                        for (int yAxis = -this.range; yAxis <= this.range; ++yAxis) {
                            Block checkBlock = world.func_180495_p(pos.func_177982_a(xAxis, yAxis, zAxis)).func_177230_c();
                            if (!(checkBlock instanceof IGrowable) && checkBlock != Blocks.field_150391_bh && checkBlock != Blocks.field_150434_aF && checkBlock != Blocks.field_150436_aH && checkBlock != Blocks.field_185766_cS) continue;
                            world.func_180497_b(pos.func_177982_a(xAxis, yAxis, zAxis), checkBlock, 0, 1);
                        }
                    }
                }
                return EnumActionResult.FAIL;
            }
        }
        return EnumActionResult.FAIL;
    }

    private void attemptWaterParticles(World world, BlockPos pos) {
        if (this.showParticlTicks) {
            this.showParticlTicks = false;
            Random rand = new Random();
            for (int x = -this.range; x <= this.range; ++x) {
                for (int z = -this.range; z <= this.range; ++z) {
                    double d0 = (float)pos.func_177982_a(x, 0, z).func_177958_n() + rand.nextFloat();
                    double d1 = (double)pos.func_177982_a(x, 0, z).func_177956_o() + 1.0;
                    double d2 = (float)pos.func_177982_a(x, 0, z).func_177952_p() + rand.nextFloat();
                    IBlockState checkSolidState = world.func_180495_p(pos);
                    Block checkSolid = checkSolidState.func_177230_c();
                    if (checkSolid.func_149686_d(checkSolidState) || checkSolid instanceof BlockFarmland) {
                        d1 += 1.0;
                    }
                    world.func_175688_a(EnumParticleTypes.WATER_DROP, d0, d1, d2, 0.0, 0.0, 0.0, new int[5]);
                }
            }
        }
    }

    public static boolean applyBonemeal(ItemStack stack, World worldIn, BlockPos target, EntityPlayer player, EnumHand hand) {
        IGrowable igrowable;
        IBlockState iblockstate = worldIn.func_180495_p(target);
        int hook = ForgeEventFactory.onApplyBonemeal((EntityPlayer)player, (World)worldIn, (BlockPos)target, (IBlockState)iblockstate, (ItemStack)stack, (EnumHand)hand);
        if (hook != 0) {
            return hook > 0;
        }
        if (iblockstate.func_177230_c() instanceof IGrowable && iblockstate.func_177230_c() != Blocks.field_150349_c && (igrowable = (IGrowable)iblockstate.func_177230_c()).func_176473_a(worldIn, target, iblockstate, worldIn.field_72995_K)) {
            if (!worldIn.field_72995_K) {
                if (igrowable.func_180670_a(worldIn, worldIn.field_73012_v, target, iblockstate)) {
                    igrowable.func_176474_b(worldIn, worldIn.field_73012_v, target, iblockstate);
                }
                stack.func_190920_e(stack.func_190916_E() - 1);
            }
            return true;
        }
        return false;
    }
}

