/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.splashanimation;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.SplashProgress;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class SplashAnimationRenderer {
    private static boolean animationSolid = false;
    private static int backgroundColor = 0;
    private static float frameDelay = 0.0f;
    private static float fadeOutTime = 0.0f;
    private static long startTime = 0L;
    private static List<BufferedImage> images = new ArrayList<BufferedImage>();
    private static int animTexture;
    private static int animTexWidth;
    private static int animTexHeight;
    private static int stage;
    private static int uploadedFrame;

    public static void run() {
        switch (stage) {
            case 0: {
                SplashAnimationRenderer.init();
                if (stage == 2) break;
                stage = 1;
            }
            case 1: {
                SplashAnimationRenderer.render();
                break;
            }
            case 2: {
                SplashAnimationRenderer.finish();
                break;
            }
        }
    }

    private static void init() {
        File confDir = new File("config");
        Configuration config = new Configuration(new File(confDir, "splashanimation.cfg"));
        animationSolid = config.getBoolean("areFramesSolid", "animation", true, "Are the animation frames solid?");
        backgroundColor = Integer.parseInt(config.getString("backgroundColor", "animation", "000000", "The background color used during the animation."), 16);
        frameDelay = config.getFloat("frameDelay", "animation", 0.03f, 0.005f, 1.0f, "The delay for each frame of animation, in seconds.");
        fadeOutTime = config.getFloat("fadeOutTime", "animation", 1.0f, 0.0f, 5.0f, "The fade out time after the final frame of animation.");
        String frameStr = config.getString("frameFileFormat", "animation", "%03d.png", "The filename template for each frame of animation, starting from 0.");
        if (config.hasChanged()) {
            config.save();
        }
        boolean addImages = true;
        File imgDir = new File("animation");
        int i = 0;
        while (addImages) {
            File imgFile = new File(imgDir, String.format(frameStr, i));
            try {
                BufferedImage image = ImageIO.read(imgFile);
                images.add(image);
                if (images.size() > 1 && (images.get(0).getWidth() != image.getWidth() || images.get(0).getHeight() != image.getHeight())) {
                    throw new RuntimeException("Mismatched animation frame sizes: 0 =/= " + i);
                }
            }
            catch (Exception e) {
                break;
            }
            ++i;
        }
        if (images.isEmpty()) {
            System.err.println("Found no images!");
            stage = 2;
            return;
        }
        animTexWidth = MathHelper.func_151236_b((int)images.get(0).getWidth());
        animTexHeight = MathHelper.func_151236_b((int)images.get(0).getHeight());
        int maxSize = SplashProgress.getMaxTextureSize();
        if (animTexWidth > maxSize || animTexHeight > maxSize) {
            System.err.println("Could not fit animation: " + maxSize + " too small");
            stage = 2;
            return;
        }
        GL11.glEnable((int)3553);
        animTexture = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)animTexture);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)animTexWidth, (int)animTexHeight, (int)0, (int)32993, (int)33639, (IntBuffer)null);
        GL11.glDisable((int)3553);
        startTime = System.currentTimeMillis();
    }

    private static void bindFrame(int i) {
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)animTexture);
        if (i != uploadedFrame && i >= 0 && i < images.size()) {
            BufferedImage img = images.get(i);
            int[] t = img.getRGB(0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth());
            IntBuffer buf = BufferUtils.createIntBuffer((int)t.length);
            buf.put(t);
            buf.position(0);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)img.getWidth(), (int)img.getHeight(), (int)32993, (int)33639, (IntBuffer)buf);
            uploadedFrame = i;
        }
    }

    private static void glColor(int v) {
        GL11.glColor4f((float)((float)(v >> 16 & 0xFF) / 255.0f), (float)((float)(v >> 8 & 0xFF) / 255.0f), (float)((float)(v & 0xFF) / 255.0f), (float)((float)(v >> 24 & 0xFF) / 255.0f));
    }

    private static void glColor(int v, float a) {
        GL11.glColor4f((float)((float)(v >> 16 & 0xFF) / 255.0f), (float)((float)(v >> 8 & 0xFF) / 255.0f), (float)((float)(v & 0xFF) / 255.0f), (float)a);
    }

    private static void render() {
        int finalElapsedMs = (int)((float)images.size() * (frameDelay * 1000.0f));
        int elapsedMs = (int)(System.currentTimeMillis() - startTime);
        int i = (int)((float)elapsedMs / 1000.0f / frameDelay);
        float alpha = 1.0f;
        if (elapsedMs >= finalElapsedMs && (alpha = 1.0f - (float)(elapsedMs - finalElapsedMs) / (fadeOutTime * 1000.0f)) < 0.0f) {
            stage = 2;
            return;
        }
        int w = Display.getWidth();
        int h = Display.getHeight();
        int iw = images.get(0).getWidth();
        int ih = images.get(0).getHeight();
        GL11.glViewport((int)0, (int)0, (int)w, (int)h);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)(-w / 2), (double)(w / 2), (double)(h / 2), (double)(-h / 2), (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        float maxU = (float)iw / (float)animTexWidth;
        float maxV = (float)ih / (float)animTexHeight;
        GL11.glDisable((int)3553);
        SplashAnimationRenderer.glColor(backgroundColor, alpha);
        GL11.glBegin((int)7);
        if (animationSolid) {
            GL11.glVertex2f((float)(-w / 2), (float)(-h / 2));
            GL11.glVertex2f((float)(-w / 2), (float)(-ih / 2));
            GL11.glVertex2f((float)(w / 2), (float)(-ih / 2));
            GL11.glVertex2f((float)(w / 2), (float)(-h / 2));
            GL11.glVertex2f((float)(-w / 2), (float)(ih / 2));
            GL11.glVertex2f((float)(-w / 2), (float)(h / 2));
            GL11.glVertex2f((float)(w / 2), (float)(h / 2));
            GL11.glVertex2f((float)(w / 2), (float)(ih / 2));
            GL11.glVertex2f((float)(-w / 2), (float)(-ih / 2));
            GL11.glVertex2f((float)(-w / 2), (float)(ih / 2));
            GL11.glVertex2f((float)(-iw / 2), (float)(ih / 2));
            GL11.glVertex2f((float)(-iw / 2), (float)(-ih / 2));
            GL11.glVertex2f((float)(iw / 2), (float)(-ih / 2));
            GL11.glVertex2f((float)(iw / 2), (float)(ih / 2));
            GL11.glVertex2f((float)(w / 2), (float)(ih / 2));
            GL11.glVertex2f((float)(w / 2), (float)(-ih / 2));
        } else {
            GL11.glVertex2f((float)(-w / 2), (float)(-h / 2));
            GL11.glVertex2f((float)(-w / 2), (float)(h / 2));
            GL11.glVertex2f((float)(w / 2), (float)(h / 2));
            GL11.glVertex2f((float)(w / 2), (float)(-h / 2));
        }
        GL11.glEnd();
        SplashAnimationRenderer.bindFrame(i);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)(-iw / 2), (float)(-ih / 2));
        GL11.glTexCoord2f((float)0.0f, (float)maxV);
        GL11.glVertex2f((float)(-iw / 2), (float)(ih / 2));
        GL11.glTexCoord2f((float)maxU, (float)maxV);
        GL11.glVertex2f((float)(iw / 2), (float)(ih / 2));
        GL11.glTexCoord2f((float)maxU, (float)0.0f);
        GL11.glVertex2f((float)(iw / 2), (float)(-ih / 2));
        GL11.glEnd();
        GL11.glDisable((int)3553);
    }

    public static void finish() {
        if (stage <= 2) {
            GL11.glDeleteTextures((int)animTexture);
            images.clear();
            stage = 3;
        }
    }

    static {
        stage = 0;
        uploadedFrame = -1;
    }
}

