/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbbanners;

import com.feed_the_beast.ftbbanners.net.FTBBannersNetHandler;
import com.feed_the_beast.ftbbanners.net.MessageSyncOneBanner;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class Banner {
    public final String id;
    public int dimension = 0;
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public ResourceLocation image = new ResourceLocation("textures/gui/presets/isles.png");
    public float width = 1.0f;
    public float height = 1.0f;
    public float rotation = 0.0f;
    public int alpha = 255;
    public float wind = 0.1f;
    public boolean shouldSave = false;

    public Banner(String _id) {
        this.id = _id;
    }

    public void write(NBTTagCompound nbt) {
        nbt.func_74768_a("Dimension", this.dimension);
        nbt.func_74780_a("X", this.x);
        nbt.func_74780_a("Y", this.y);
        nbt.func_74780_a("Z", this.z);
        nbt.func_74778_a("Image", this.image.toString());
        nbt.func_74776_a("Width", this.width);
        nbt.func_74776_a("Height", this.height);
        nbt.func_74776_a("Rotation", this.rotation);
        nbt.func_74768_a("Alpha", this.alpha);
        nbt.func_74776_a("Wind", this.wind);
    }

    public void read(NBTTagCompound nbt) {
        this.dimension = nbt.func_74762_e("Dimension");
        this.x = nbt.func_74769_h("X");
        this.y = nbt.func_74769_h("Y");
        this.z = nbt.func_74769_h("Z");
        this.image = new ResourceLocation(nbt.func_74779_i("Image"));
        this.width = nbt.func_74760_g("Width");
        this.height = nbt.func_74760_g("Height");
        this.rotation = nbt.func_74760_g("Rotation");
        this.alpha = nbt.func_74762_e("Alpha");
        this.wind = nbt.func_74760_g("Wind");
    }

    public void write(ByteBuf data) {
        data.writeInt(this.dimension);
        data.writeDouble(this.x);
        data.writeDouble(this.y);
        data.writeDouble(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.image.toString());
        data.writeFloat(this.width);
        data.writeFloat(this.height);
        data.writeFloat(this.rotation);
        data.writeByte(this.alpha);
        data.writeFloat(this.wind);
    }

    public void read(ByteBuf data) {
        this.dimension = data.readInt();
        this.x = data.readDouble();
        this.y = data.readDouble();
        this.z = data.readDouble();
        this.image = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)data));
        this.width = data.readFloat();
        this.height = data.readFloat();
        this.rotation = data.readFloat();
        this.alpha = data.readUnsignedByte();
        this.wind = data.readFloat();
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o != null && this.id.equals(o.toString());
    }

    public void save(File folder) {
        File file = new File(folder, this.id + ".nbt");
        if (this.height == 0.0f) {
            file.delete();
            FTBBannersNetHandler.NET.sendToAll((IMessage)new MessageSyncOneBanner(this));
            return;
        }
        if (!file.exists() && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        this.write(nbt);
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
            try (FileOutputStream out = new FileOutputStream(file);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)out);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        });
    }

    public void saveAndSend() {
        this.shouldSave = true;
        FTBBannersNetHandler.NET.sendToAll((IMessage)new MessageSyncOneBanner(this));
    }
}

