/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.lib;

import com.brandon3055.draconicevolution.DEConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class OreDoublingRegistry {
    public static Map<String, ItemStack> oreRecipes = new HashMap<String, ItemStack>();
    public static Map<ItemStack, ItemStack> stackToStackRecipes = new HashMap<ItemStack, ItemStack>();

    public static void init() {
        for (String oreName : OreDictionary.getOreNames()) {
            String ingot;
            if (!oreName.startsWith("ore") || DEConfig.oreBlacklist.contains(oreName) || (!OreDictionary.doesOreNameExist((String)(ingot = oreName.replace("ore", "ingot"))) || OreDictionary.getOres((String)ingot).isEmpty() || OreDictionary.getOres((String)oreName).isEmpty()) && (!OreDictionary.doesOreNameExist((String)(ingot = oreName.replace("ore", "gem"))) || OreDictionary.getOres((String)ingot).isEmpty() || OreDictionary.getOres((String)oreName).isEmpty())) continue;
            NonNullList ingots = OreDictionary.getOres((String)ingot);
            int oreId = OreDictionary.getOreID((String)oreName);
            ItemStack stack = ItemStack.field_190927_a;
            for (ItemStack candidate : ingots) {
                boolean invalid = false;
                for (int id : OreDictionary.getOreIDs((ItemStack)candidate)) {
                    if (id != oreId) continue;
                    invalid = true;
                    break;
                }
                if (invalid) continue;
                stack = candidate;
                ResourceLocation registryName = candidate.func_77973_b().getRegistryName();
                if (registryName == null || !registryName.func_110624_b().equals("thermalfoundation")) continue;
                break;
            }
            if (stack.func_190926_b()) continue;
            stack = stack.func_77946_l();
            stack.func_190920_e(2);
            OreDoublingRegistry.registerOreResult(oreName, stack);
        }
        OreDoublingRegistry.registerDEOverrides();
    }

    public static void registerOreResult(String ore, ItemStack result) {
        oreRecipes.put(ore, result);
    }

    public static void registerResult(ItemStack input, ItemStack result) {
        stackToStackRecipes.put(input, result);
    }

    public static ItemStack getSmeltingResult(ItemStack stack) {
        int[] ids;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190916_E() != 1) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
        }
        if (stackToStackRecipes.containsKey(stack)) {
            return stackToStackRecipes.get(stack);
        }
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String sid = OreDictionary.getOreName((int)id);
            if (!oreRecipes.containsKey(sid)) continue;
            return oreRecipes.getOrDefault(sid, ItemStack.field_190927_a);
        }
        return FurnaceRecipes.func_77602_a().func_151395_a(stack);
    }

    private static void registerDEOverrides() {
        OreDoublingRegistry.registerOreResult("sand", new ItemStack(Blocks.field_150359_w, 2));
        OreDoublingRegistry.registerOreResult("cobblestone", new ItemStack(Blocks.field_150348_b, 2));
        OreDoublingRegistry.registerOreResult("netherrack", new ItemStack(Items.field_151130_bT, 2));
        OreDoublingRegistry.registerOreResult("cobblestone", new ItemStack(Blocks.field_150348_b, 2));
        OreDoublingRegistry.registerResult(new ItemStack(Items.field_151119_aD), new ItemStack(Items.field_151118_aC, 2));
        OreDoublingRegistry.registerResult(new ItemStack((Block)Blocks.field_150434_aF), new ItemStack(Items.field_151100_aR, 2, 2));
    }
}

