/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.draconicevolution.api.itemconfig.AOEConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.BooleanConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.items.tools.ToolBase;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;

public abstract class WyvernHoe
extends ToolBase {
    protected int baseAOE = 1;

    @Override
    public double getBaseAttackSpeedConfig() {
        return ToolStats.WYV_HOE_ATTACK_SPEED;
    }

    @Override
    public double getBaseAttackDamageConfig() {
        return ToolStats.WYV_HOE_ATTACK_DAMAGE;
    }

    @Override
    public void loadEnergyStats() {
        this.setEnergyStats(ToolStats.WYVERN_BASE_CAPACITY, 512000, 0);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.hoeBlock(stack, player, world, pos, facing)) {
            if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150458_ak) {
                return EnumActionResult.FAIL;
            }
        } else {
            this.modifyEnergy(stack, -this.energyPerOperation);
        }
        if (player.func_70093_af()) {
            return EnumActionResult.SUCCESS;
        }
        int AOE = ToolConfigHelper.getIntegerField("digAOE", stack);
        boolean fill = ToolConfigHelper.getBooleanField("landFill", stack);
        Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-AOE, 0, -AOE), (BlockPos)pos.func_177982_a(AOE, 0, AOE));
        for (BlockPos aoePos : blocks) {
            boolean up2OK;
            BlockEvent.PlaceEvent event;
            boolean lowerBlockOk;
            if (aoePos.equals((Object)pos) || !fill && (world.func_175623_d(aoePos) || !world.func_175623_d(aoePos.func_177984_a()))) continue;
            boolean airOrReplaceable = world.func_175623_d(aoePos) || world.func_180495_p(aoePos).func_177230_c().func_176200_f((IBlockAccess)world, aoePos);
            boolean bl = lowerBlockOk = world.isSideSolid(aoePos.func_177977_b(), EnumFacing.UP) || world.func_180495_p(aoePos.func_177977_b()).func_177230_c() == Blocks.field_150458_ak;
            if (fill && airOrReplaceable && lowerBlockOk && (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_70431_c(new ItemStack(Blocks.field_150346_d))) && !(event = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)new BlockSnapshot(world, aoePos, Blocks.field_150346_d.func_176223_P()), (EnumFacing)EnumFacing.UP, (EnumHand)player.func_184600_cs())).isCanceled() && (player.field_71075_bZ.field_75098_d || InventoryUtils.consumeStack((ItemStack)new ItemStack(Blocks.field_150346_d), (IInventory)player.field_71071_by))) {
                world.func_175656_a(aoePos, Blocks.field_150346_d.func_176223_P());
            }
            boolean canDropAbove = world.func_180495_p(aoePos.func_177984_a()).func_177230_c() == Blocks.field_150346_d || world.func_180495_p(aoePos.func_177984_a()).func_177230_c() == Blocks.field_150349_c || world.func_180495_p(aoePos.func_177984_a()).func_177230_c() == Blocks.field_150458_ak;
            boolean canRemoveAbove = canDropAbove || world.func_180495_p(aoePos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, aoePos.func_177984_a());
            boolean bl2 = up2OK = world.func_175623_d(aoePos.func_177984_a().func_177984_a()) || world.func_180495_p(aoePos.func_177984_a().func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, aoePos.func_177984_a().func_177984_a());
            if (fill && !world.func_175623_d(aoePos.func_177984_a()) && canRemoveAbove && up2OK) {
                if (canDropAbove) {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(Blocks.field_150346_d)));
                }
                world.func_175698_g(aoePos.func_177984_a());
            }
            if (!this.hoeBlock(stack, player, world, aoePos, facing)) continue;
            this.modifyEnergy(stack, -this.energyPerOperation);
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean hoeBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing face) {
        if (this.getEnergyStored(stack) < this.energyPerOperation && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (!player.func_175151_a(pos, face, stack)) {
            return false;
        }
        int hook = ForgeEventFactory.onHoeUse((ItemStack)stack, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (hook != 0) {
            return hook > 0;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (face != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                this.setBlock(player, world, pos, Blocks.field_150458_ak.func_176223_P());
                return true;
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        this.setBlock(player, world, pos, Blocks.field_150458_ak.func_176223_P());
                        return true;
                    }
                    case COARSE_DIRT: {
                        this.setBlock(player, world, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected void setBlock(EntityPlayer player, World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, state, 11);
        }
    }

    @Override
    public List<String> getValidUpgrades(ItemStack stack) {
        List<String> list = super.getValidUpgrades(stack);
        list.add("digAOE");
        return list;
    }

    @Override
    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        int maxAOE = this.baseAOE + UpgradeHelper.getUpgradeLevel(stack, "digAOE");
        registry.register(stack, new AOEConfigField("digAOE", 0, 0, maxAOE, "config.field.digAOE.description"));
        registry.register(stack, new BooleanConfigField("landFill", false, "config.field.landFill.description"));
        return registry;
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 2;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnumEnchantmentType.ALL;
    }

    @Override
    public int getToolTier(ItemStack stack) {
        return 0;
    }
}

