/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent;

import com.brandon3055.brandonscore.client.gui.modulargui_old.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.EnumAlignment;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiHoverPopup;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiTextField;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DisplayComponentBase;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.IDisplayComponentFactory;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.w3c.dom.Element;

public class DCLink
extends DisplayComponentBase {
    public static final String TARGET_BRANCH = "branch";
    public static final String TARGET_WEB = "web";
    public static final String ATTRIB_LINK_TARGET = "targetLocation";
    public static final String ATTRIB_LINK = "link";
    public static final String ATTRIB_SIZE = "size";
    public static final String ATTRIB_HC = "hoverColour";
    public int headingSize = 0;
    public String displayString = "";
    public String linkTarget = "";
    public String link = "";
    public int hoverColour = 255;
    private int xMin = 0;
    private int xMax = 1000;

    public DCLink(GuiModWiki modularGui, String componentType, TreeBranchRoot branch) {
        super(modularGui, componentType, branch);
        this.ySize = 12;
    }

    @Override
    public void setXSize(int xSize) {
        super.setXSize(xSize);
        if (xSize < 10) {
            return;
        }
        float scaleFactor = 1.0f + (float)this.headingSize / 2.0f;
        List list = this.fontRenderer.func_78271_c(this.displayString, (int)((float)xSize / scaleFactor));
        int split = list.size();
        this.ySize = (int)((float)this.fontRenderer.field_78288_b * scaleFactor * (float)split);
        this.xMin = xSize;
        this.xMax = 0;
        for (String string : list) {
            float x = 0.0f;
            float scaledWidth = (float)this.fontRenderer.func_78256_a(string) * scaleFactor;
            switch (this.alignment) {
                case LEFT: {
                    x = 2.0f * scaleFactor;
                    break;
                }
                case CENTER: {
                    x = (float)xSize / 2.0f - scaledWidth / 2.0f;
                    break;
                }
                case RIGHT: {
                    x = (float)xSize - scaledWidth - 2.0f * scaleFactor;
                }
            }
            if (x < (float)this.xMin) {
                this.xMin = (int)x;
            }
            if (!(x + scaledWidth > (float)this.xMax)) continue;
            this.xMax = (int)(x + scaledWidth);
        }
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        float scaleFactor = 1.0f + (float)this.headingSize / 2.0f;
        List list = this.fontRenderer.func_78271_c(this.displayString, (int)((float)this.xSize / scaleFactor));
        for (String string : list) {
            float x = 0.0f;
            float y = (float)this.yPos + (float)this.fontRenderer.field_78288_b * scaleFactor * (float)list.indexOf(string);
            float scaledWidth = (float)this.fontRenderer.func_78256_a(string) * scaleFactor;
            switch (this.alignment) {
                case LEFT: {
                    x = (float)this.xPos + 2.0f * scaleFactor;
                    break;
                }
                case CENTER: {
                    x = (float)this.xPos + (float)this.xSize / 2.0f - scaledWidth / 2.0f;
                    break;
                }
                case RIGHT: {
                    x = (float)this.xPos + ((float)this.xSize - scaledWidth) - 2.0f * scaleFactor;
                }
            }
            if (this.headingSize > 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)1.0f);
                GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
            }
            boolean mouseOver = this.isMouseOver(mouseX, mouseY) && mouseX >= this.xPos + this.xMin && mouseX <= this.xPos + this.xMax;
            this.drawString(this.fontRenderer, string, x, y, mouseOver ? this.hoverColour : this.getColour(), this.shadow);
            if (this.headingSize <= 0) continue;
            GlStateManager.func_179121_F();
        }
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        boolean mouseOver;
        boolean bl = mouseOver = this.isMouseOver(mouseX, mouseY) && mouseX >= this.xPos + this.xMin && mouseX <= this.xPos + this.xMax;
        if (mouseOver) {
            if (this.linkTarget.equals(TARGET_BRANCH)) {
                if (this.branch.guiWiki.wikiDataTree.idToBranchMap.containsKey(this.link)) {
                    this.branch.guiWiki.wikiDataTree.setActiveBranch(this.branch.guiWiki.wikiDataTree.idToBranchMap.get(this.link));
                } else {
                    this.displayString = TextFormatting.DARK_RED + "[ERROR: Broken Link]";
                    this.headingSize = 0;
                }
            } else if (this.linkTarget.equals(TARGET_WEB)) {
                try {
                    ReflectionHelper.setPrivateValue(GuiScreen.class, (Object)((Object)this.branch.guiWiki), (Object)new URI(this.link), (String[])new String[]{"clickedLinkURI", "field_175286_t"});
                    this.mc.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this.branch.guiWiki, this.link, 31102009, false));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public LinkedList<MGuiElementBase> getEditControls() {
        LinkedList<MGuiElementBase> list = super.getEditControls();
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "TOGGLE_ALIGN", 0, 0, 26, 12, "Align"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Text Alignment"}));
        MGuiTextField textField = new MGuiTextField(this.modularGui, 0, 0, 100, 12, this.fontRenderer).setListener((IMGuiListener)this).setMaxStringLength(2048).setText(this.displayString);
        textField.setId("TEXT");
        textField.addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui, new String[]{"Modify Link Text", TextFormatting.GREEN + "Will Auto-Save 3 seconds after you stop typing."}, (MGuiElementBase)textField));
        list.add((MGuiElementBase)textField);
        list.add((MGuiElementBase)new MGuiLabel(this.modularGui, 0, 0, 37, 12, "Colour:").setAlignment(EnumAlignment.CENTER));
        MGuiTextField colourField = new MGuiTextField(this.modularGui, 0, 0, 45, 12, this.fontRenderer).setListener((IMGuiListener)this).setMaxStringLength(6);
        colourField.setId("COLOUR");
        colourField.addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui, new String[]{"Set the primary link colour.", TextFormatting.GOLD + "This is a HEX value meaning it accepts digits between 0 and F", TextFormatting.GOLD + "Format is Red, Green, Blue [RRGGBB]", TextFormatting.GREEN + "Will Auto-Save 3 seconds after you stop typing."}, (MGuiElementBase)colourField));
        colourField.setText(Integer.toHexString(this.getColour()));
        colourField.setValidator((Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                try {
                    Utils.parseHex((String)input, (boolean)false);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
        });
        list.add((MGuiElementBase)colourField);
        list.add((MGuiElementBase)new MGuiLabel(this.modularGui, 0, 0, 70, 12, "Hover Colour:").setAlignment(EnumAlignment.CENTER));
        MGuiTextField hoverColourField = new MGuiTextField(this.modularGui, 0, 0, 45, 12, this.fontRenderer).setListener((IMGuiListener)this).setMaxStringLength(6);
        hoverColourField.setId("COLOUR_HOVER");
        hoverColourField.addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui, new String[]{"Set the hover link colour.", TextFormatting.GOLD + "This is a HEX value meaning it accepts digits between 0 and F", TextFormatting.GOLD + "Format is Red, Green, Blue [RRGGBB]", TextFormatting.GREEN + "Will Auto-Save 3 seconds after you stop typing."}, (MGuiElementBase)hoverColourField));
        hoverColourField.setText(Integer.toHexString(this.hoverColour));
        hoverColourField.setValidator((Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                try {
                    Utils.parseHex((String)input, (boolean)false);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
        });
        list.add((MGuiElementBase)hoverColourField);
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "CYCLE_SIZE", 0, 0, 20, 12, "S:"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Cycle Trough Link Sizes", "Hold Shift to reverse"}).setDisplayString("S:" + this.headingSize));
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "SHADOW", 0, 0, 10, 12, "S"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Shadow"}));
        list.add(new MGuiButtonSolid(this.modularGui, "OBFUSCATED", 0, 0, 10, 12, TextFormatting.OBFUSCATED + "O"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Obfuscated"}).addToGroup("STYLE"));
        list.add(new MGuiButtonSolid(this.modularGui, "BOLD", 0, 0, 10, 12, TextFormatting.BOLD + "B"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Bold"}).addToGroup("STYLE"));
        list.add(new MGuiButtonSolid(this.modularGui, "STRIKETHROUGH", 0, 0, 10, 12, TextFormatting.STRIKETHROUGH + "S"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Strike-through"}).addToGroup("STYLE"));
        list.add(new MGuiButtonSolid(this.modularGui, "UNDERLINE", 0, 0, 10, 12, TextFormatting.UNDERLINE + "U"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Underline"}).addToGroup("STYLE"));
        list.add(new MGuiButtonSolid(this.modularGui, "ITALIC", 0, 0, 10, 12, TextFormatting.ITALIC + "I"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Italic"}).addToGroup("STYLE"));
        String type = this.linkTarget.equals(TARGET_BRANCH) ? "Target Branch ID:" : (this.linkTarget.equals(TARGET_WEB) ? "Target URL:" : "Target Type Not Set");
        list.add((MGuiElementBase)new MGuiLabel(this.modularGui, 0, 0, this.fontRenderer.func_78256_a(type) + 4, 12, type).setAlignment(EnumAlignment.CENTER));
        MGuiTextField linkField = new MGuiTextField(this.modularGui, 0, 0, 200, 12, this.fontRenderer).setListener((IMGuiListener)this).setMaxStringLength(2048).setText(this.link);
        linkField.setId("LINK_FIELD");
        hoverColourField.addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui, new String[]{"Set the link destination.", TextFormatting.GOLD + "Destination can be a web address if or a branch id depending on the target type.", TextFormatting.GOLD + "To get the id of a branch go to its edit menu and click the \"Copy ID\" button.", TextFormatting.GREEN + "Will Auto-Save 3 seconds after you stop typing."}, (MGuiElementBase)linkField));
        list.add((MGuiElementBase)linkField);
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "SWITCH_TARGET", 0, 0, 36, 12, "Target"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Switch Target Type"}));
        return list;
    }

    @Override
    public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
        super.onMGuiEvent(eventString, eventElement);
        if (eventElement.id.equals("TEXT") && eventString.equals("TEXT_FIELD_CHANGED") && eventElement instanceof MGuiTextField) {
            if (StringUtils.func_151246_b((String)((MGuiTextField)eventElement).getText())) {
                return;
            }
            this.element.setTextContent(((MGuiTextField)eventElement).getText());
            this.displayString = ((MGuiTextField)eventElement).getText();
            this.requiresSave = true;
            this.saveTimer = 60;
        } else if (eventString.equals("BUTTON_PRESS") && eventElement instanceof MGuiButtonSolid && ((MGuiButtonSolid)eventElement).buttonName.equals("CYCLE_SIZE")) {
            this.headingSize += GuiScreen.func_146272_n() ? -1 : 1;
            if (this.headingSize > 10) {
                this.headingSize = 0;
            } else if (this.headingSize < 0) {
                this.headingSize = 0;
            }
            this.element.setAttribute(ATTRIB_SIZE, String.valueOf(this.headingSize));
            this.save();
        } else if (eventString.equals("BUTTON_PRESS") && eventElement instanceof MGuiButtonSolid && ((MGuiButtonSolid)eventElement).buttonName.equals("SHADOW")) {
            this.shadow = !this.shadow;
            this.element.setAttribute("shadow", String.valueOf(this.shadow));
            this.save();
        } else if (eventElement.id.equals("COLOUR") && eventString.equals("TEXT_FIELD_CHANGED") && eventElement instanceof MGuiTextField) {
            try {
                this.setColour(Utils.parseHex((String)((MGuiTextField)eventElement).getText()));
                this.element.setAttribute("colour", Integer.toHexString(this.getColour()));
                this.requiresSave = true;
                this.saveTimer = 60;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (eventElement.id.equals("COLOUR_HOVER") && eventString.equals("TEXT_FIELD_CHANGED") && eventElement instanceof MGuiTextField) {
            try {
                this.hoverColour = Utils.parseHex((String)((MGuiTextField)eventElement).getText());
                this.element.setAttribute(ATTRIB_HC, Integer.toHexString(this.hoverColour));
                this.requiresSave = true;
                this.saveTimer = 60;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (eventElement instanceof MGuiButton && eventElement.isInGroup("STYLE")) {
            TextFormatting format = TextFormatting.valueOf((String)((MGuiButton)eventElement).buttonName);
            this.displayString = this.displayString.contains(format.toString()) ? this.displayString.replace(format.toString(), "") : format + this.displayString;
            for (MGuiElementBase element : this.branch.guiWiki.contentWindow.editControls) {
                if (!(element instanceof MGuiTextField)) continue;
                ((MGuiTextField)element).setText(this.displayString);
                break;
            }
            this.element.setTextContent(this.displayString);
            this.save();
        } else if (eventElement.id.equals("LINK_FIELD") && eventString.equals("TEXT_FIELD_CHANGED") && eventElement instanceof MGuiTextField) {
            try {
                this.linkTarget = ((MGuiTextField)eventElement).getText();
                this.element.setAttribute(ATTRIB_LINK, this.linkTarget);
                this.requiresSave = true;
                this.saveTimer = 60;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (eventString.equals("BUTTON_PRESS") && eventElement instanceof MGuiButtonSolid && ((MGuiButtonSolid)eventElement).buttonName.equals("SWITCH_TARGET")) {
            this.linkTarget = this.linkTarget.equals(TARGET_BRANCH) ? TARGET_WEB : TARGET_BRANCH;
            this.element.setAttribute(ATTRIB_LINK_TARGET, this.linkTarget);
            this.save();
        }
    }

    @Override
    public void onCreated() {
        this.element.setAttribute(ATTRIB_LINK_TARGET, TARGET_BRANCH);
        this.element.setAttribute(ATTRIB_LINK, this.branch.branchID);
        this.element.setAttribute(ATTRIB_SIZE, "0");
        this.element.setTextContent("Click to the left or right of this text to edit.");
        this.element.setAttribute(ATTRIB_HC, "0000FF");
        this.element.setAttribute("shadow", "true");
        this.element.setAttribute("alignment", "CENTER");
    }

    @Override
    public void loadFromXML(Element element) {
        super.loadFromXML(element);
        this.linkTarget = element.getAttribute(ATTRIB_LINK_TARGET);
        this.link = element.getAttribute(ATTRIB_LINK);
        this.displayString = element.getTextContent();
        if (element.hasAttribute(ATTRIB_SIZE)) {
            this.headingSize = Integer.parseInt(element.getAttribute(ATTRIB_SIZE));
        }
        if (element.hasAttribute(ATTRIB_HC)) {
            try {
                this.hoverColour = Utils.parseHex((String)element.getAttribute(ATTRIB_HC), (boolean)false);
            }
            catch (Exception e) {
                LogHelper.error("Error reading element colour: " + element + " In:" + this.branch.branchID);
                e.printStackTrace();
            }
        }
    }

    public static class Factory
    implements IDisplayComponentFactory {
        @Override
        public DisplayComponentBase createNewInstance(GuiModWiki guiWiki, TreeBranchRoot branch) {
            DCLink component = new DCLink(guiWiki, this.getID(), branch);
            component.setWorldAndResolution(guiWiki.field_146297_k, guiWiki.screenWidth(), guiWiki.screenHeight());
            return component;
        }

        @Override
        public String getID() {
            return DCLink.ATTRIB_LINK;
        }
    }
}

