/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.tileentity;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.EnergyHelper;
import com.brandon3055.brandonscore.lib.Vec3B;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.draconicevolution.api.ICrystalLink;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerClientWireless;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerServerWireless;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXRing;
import com.brandon3055.draconicevolution.client.render.effect.CrystalGLFXBase;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCrystalWirelessIO
extends TileCrystalBase {
    protected Map<Vec3B, EnumFacing> receiverSideMap = new HashMap<Vec3B, EnumFacing>();
    protected LinkedList<Vec3B> linkedReceivers = new LinkedList();
    protected LinkedList<BlockPos> receiverCache = null;
    protected Map<BlockPos, EnumFacing> receiverFaceCache = null;
    protected List<LinkedDevice> fastList = new ArrayList<LinkedDevice>();
    protected List<LinkedDevice> slowList = new ArrayList<LinkedDevice>();
    public LinkedList<int[]> receiverTransferRates = new LinkedList();
    public LinkedList<Byte> receiverFlowRates = new LinkedList();
    public final ManagedBool useUpdateOptimisation = (ManagedBool)this.dataManager.register("transportState", (IManagedData)new ManagedBool(true)).syncViaContainer().saveToTile().saveToItem().finish();
    public final ManagedBool inputMode = (ManagedBool)this.dataManager.register("inputMode", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().saveToItem().finish();
    public Map<Integer, Integer> containerReceiverFlow = new HashMap<Integer, Integer>();

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateEnergyFlow();
        }
        super.func_73660_a();
    }

    private void updateEnergyFlow() {
        if (this.receiverTransferRates.size() != this.linkedReceivers.size()) {
            this.rebuildReceiverTransferList();
        }
        this.getReceiversFaces();
        ArrayList<LinkedDevice> moveToSlow = new ArrayList<LinkedDevice>();
        for (LinkedDevice receiver : this.fastList) {
            if (!this.updateDevice(receiver)) {
                this.removeReceiver(receiver.pos);
                return;
            }
            if (receiver.timeOut <= 40) continue;
            moveToSlow.add(receiver);
        }
        if (this.tick % 80 == 0) {
            ArrayList<LinkedDevice> moveToFast = new ArrayList<LinkedDevice>();
            for (LinkedDevice receiver : this.slowList) {
                if (!this.updateDevice(receiver)) {
                    this.removeReceiver(receiver.pos);
                    return;
                }
                if (receiver.timeOut != 0) continue;
                moveToFast.add(receiver);
            }
            if (!moveToFast.isEmpty()) {
                this.fastList.addAll(moveToFast);
                this.slowList.removeAll(moveToFast);
            }
        }
        if (!moveToSlow.isEmpty()) {
            this.slowList.addAll(moveToSlow);
            this.fastList.removeAll(moveToSlow);
        }
        if (!this.field_145850_b.field_72995_K && DEEventHandler.serverTicks % 10 == 0) {
            this.receiverFlowRates.clear();
            for (int i = 0; i < this.linkedReceivers.size(); ++i) {
                this.receiverFlowRates.add(this.flowConversion(this.receiverTransfer(i)));
            }
        }
    }

    @Override
    public boolean onBlockActivated(IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            this.inputMode.value = !this.inputMode.value;
            return true;
        }
        return super.onBlockActivated(state, player, hand, side, hitX, hitY, hitZ);
    }

    protected boolean updateDevice(LinkedDevice receiver) {
        int transfered;
        if (!receiver.isLinkValid(this.field_145850_b)) {
            return receiver.invalidTime++ < 100;
        }
        receiver.invalidTime = 0;
        TileEntity tile = receiver.getCachedTile();
        if (tile == null) {
            receiver.timeOut = receiver.timeOut < 40 ? 40 : ++receiver.timeOut;
            return true;
        }
        if (this.inputMode.value) {
            transfered = EnergyHelper.extractEnergy((TileEntity)tile, (int)this.energyStorage.receiveEnergy(this.getMaxWirelessTransfer(), true), (EnumFacing)receiver.side, (boolean)false);
            this.energyStorage.receiveEnergy(transfered, false);
        } else {
            transfered = EnergyHelper.insertEnergy((TileEntity)tile, (int)this.energyStorage.extractEnergy(this.getMaxWirelessTransfer(), true), (EnumFacing)receiver.side, (boolean)false);
            this.energyStorage.extractEnergy(transfered, false);
        }
        receiver.timeOut = transfered > 0 ? 0 : ++receiver.timeOut;
        this.receiverTransferRates.get((int)receiver.index)[this.tick % 20] = transfered;
        return true;
    }

    public void rebuildReceiverTransferList() {
        this.receiverTransferRates.clear();
        this.receiverFlowRates.clear();
        for (int i = 0; i < this.linkedReceivers.size(); ++i) {
            this.receiverTransferRates.add(new int[20]);
            this.receiverFlowRates.add((byte)0);
        }
    }

    public int getMaxWirelessTransfer() {
        return this.getTier() == 0 ? 32000 : (this.getTier() == 1 ? 128000 : 512000);
    }

    public int receiverTransfer(int index) {
        long sum = 0L;
        for (int transfer : this.receiverTransferRates.get(index)) {
            sum += (long)transfer;
        }
        return (int)(sum / 20L);
    }

    public byte flowConversion(int transferRate) {
        double d = (double)transferRate / ((double)this.getMaxWirelessTransfer() * 0.01 + (double)transferRate);
        return (byte)(d * 255.0);
    }

    @Override
    public boolean binderUsed(EntityPlayer player, BlockPos linkTarget, EnumFacing sideClicked) {
        TileEntity tile = this.field_145850_b.func_175625_s(linkTarget);
        if (tile == null || tile instanceof ICrystalLink) {
            return super.binderUsed(player, linkTarget, sideClicked);
        }
        Vec3B offset = this.getOffset(linkTarget);
        if (this.linkedReceivers.contains(offset)) {
            this.removeReceiver(linkTarget);
            ChatHelper.indexedTrans((ICommandSender)player, (String)"eNet.de.linkBroken.info", (TextFormatting)TextFormatting.GREEN, (Object[])new Object[0]);
            return true;
        }
        if (this.inputMode.value) {
            if (!EnergyHelper.canExtractEnergy((TileEntity)tile, (EnumFacing)sideClicked)) {
                if (EnergyHelper.isEnergyTile((TileEntity)tile)) {
                    ChatHelper.indexedTrans((ICommandSender)player, (String)"eNet.de.sideCanNotExtract.info", (TextFormatting)TextFormatting.RED, (Object[])new Object[0]);
                    return false;
                }
                return super.binderUsed(player, linkTarget, sideClicked);
            }
        } else if (!EnergyHelper.canReceiveEnergy((TileEntity)tile, (EnumFacing)sideClicked)) {
            if (EnergyHelper.isEnergyTile((TileEntity)tile)) {
                ChatHelper.indexedTrans((ICommandSender)player, (String)"eNet.de.sideCanNotReceive.info", (TextFormatting)TextFormatting.RED, (Object[])new Object[0]);
                return false;
            }
            return super.binderUsed(player, linkTarget, sideClicked);
        }
        if (this.linkedReceivers.size() >= this.getMaxReceivers()) {
            ChatHelper.indexedTrans((ICommandSender)player, (String)"eNet.de.maxReceivers.info", (TextFormatting)TextFormatting.RED, (Object[])new Object[0]);
            return false;
        }
        this.addReceiver(linkTarget, sideClicked);
        ChatHelper.indexedTrans((ICommandSender)player, (String)"eNet.de.devicesLinked.info", (TextFormatting)TextFormatting.GREEN, (Object[])new Object[0]);
        return true;
    }

    public List<BlockPos> getReceivers() {
        if (this.receiverCache == null || this.receiverCache.size() != this.linkedReceivers.size()) {
            this.reCachePositions();
        }
        return this.receiverCache;
    }

    public Map<BlockPos, EnumFacing> getReceiversFaces() {
        if (this.receiverCache == null || this.receiverCache.size() != this.linkedReceivers.size() || this.receiverFaceCache == null || this.receiverFaceCache.size() != this.linkedReceivers.size()) {
            this.reCachePositions();
        }
        return this.receiverFaceCache;
    }

    public int getMaxReceivers() {
        return this.getTier() == 0 ? 16 : (this.getTier() == 1 ? 32 : 64);
    }

    private void reCachePositions() {
        this.receiverCache = new LinkedList();
        this.receiverFaceCache = new HashMap<BlockPos, EnumFacing>();
        this.fastList.clear();
        this.slowList.clear();
        for (Vec3B offset : this.linkedReceivers) {
            this.receiverCache.add(this.fromOffset(offset));
            this.receiverFaceCache.put(this.fromOffset(offset), this.receiverSideMap.get(offset));
            this.fastList.add(new LinkedDevice(this.linkedReceivers.indexOf(offset), this.fromOffset(offset), this.receiverSideMap.get(offset)));
        }
        this.updateBlock();
    }

    @Override
    public EnergyCrystal.CrystalType getType() {
        return EnergyCrystal.CrystalType.WIRELESS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CrystalGLFXBase createStaticFX() {
        return new CrystalFXRing(this.field_145850_b, this);
    }

    @Override
    public Vec3D getBeamLinkPos(BlockPos linkTo) {
        Vec3D thisVec = Vec3D.getCenter((BlockPos)this.field_174879_c);
        Vec3D targVec = Vec3D.getCenter((BlockPos)linkTo);
        double dist = thisVec.distXZ(targVec);
        double offM = 0.4;
        if (dist == 0.0) {
            if (this.field_174879_c.func_177956_o() > linkTo.func_177956_o()) {
                return thisVec.subtract(0.0, 0.4, 0.0);
            }
            return thisVec.subtract(0.0, -0.4, 0.0);
        }
        double xDist = thisVec.x - targVec.x;
        double zDist = thisVec.z - targVec.z;
        double xOff = xDist / dist;
        double zOff = zDist / dist;
        return thisVec.subtract(xOff * offM, 0.0, zOff * offM);
    }

    @Override
    public boolean renderBeamTermination() {
        return true;
    }

    @Override
    public ENetFXHandler createServerFXHandler() {
        return new ENetFXHandlerServerWireless(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ENetFXHandler createClientFXHandler() {
        return new ENetFXHandlerClientWireless(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDisplayData(List<String> displayList) {
        super.addDisplayData(displayList);
        displayList.add(TextFormatting.GREEN + I18n.func_135052_a((String)"eNet.de.hudWirelessLinks.info", (Object[])new Object[0]) + ": " + this.getReceivers().size() + " / " + this.getMaxReceivers());
        TextFormatting colour = !this.inputMode.value ? TextFormatting.GOLD : TextFormatting.DARK_AQUA;
        displayList.add(I18n.func_135052_a((String)("eNet.de.IOOutput_" + !this.inputMode.value + ".info"), (Object[])new Object[]{colour}));
    }

    public void addReceiver(BlockPos pos, EnumFacing side) {
        Vec3B offset = this.getOffset(pos);
        this.linkedReceivers.add(offset);
        this.receiverSideMap.put(offset, side);
        this.reCachePositions();
        this.updateBlock();
    }

    public void removeReceiver(BlockPos pos) {
        Vec3B offset = this.getOffset(pos);
        this.linkedReceivers.remove(offset);
        this.receiverSideMap.remove(offset);
        this.reCachePositions();
        this.updateBlock();
    }

    @Override
    public void writeExtraNBT(NBTTagCompound compound) {
        super.writeExtraNBT(compound);
        NBTTagList list = new NBTTagList();
        for (Vec3B vec : this.linkedReceivers) {
            NBTTagCompound receiver = new NBTTagCompound();
            receiver.func_74773_a("Offset", new byte[]{vec.x, vec.y, vec.z});
            receiver.func_74774_a("Side", (byte)this.receiverSideMap.get(vec).func_176745_a());
            list.func_74742_a((NBTBase)receiver);
        }
        compound.func_74782_a("LinkedReceivers", (NBTBase)list);
    }

    @Override
    public void readExtraNBT(NBTTagCompound compound) {
        super.readExtraNBT(compound);
        NBTTagList list = compound.func_150295_c("LinkedReceivers", 10);
        this.linkedReceivers.clear();
        this.receiverSideMap.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound receiver = list.func_150305_b(i);
            byte[] offset = receiver.func_74770_j("Offset");
            Vec3B vec = new Vec3B(offset[0], offset[1], offset[2]);
            this.linkedReceivers.add(vec);
            this.receiverSideMap.put(vec, EnumFacing.func_82600_a((int)receiver.func_74771_c("Side")));
        }
        this.receiverCache = null;
    }

    @Override
    public void detectAndSendContainerChanges(List<IContainerListener> listeners) {
        super.detectAndSendContainerChanges(listeners);
        if (this.linkedReceivers.size() != this.receiverTransferRates.size() && !this.field_145850_b.field_72995_K) {
            this.rebuildReceiverTransferList();
        }
        List<BlockPos> positions = this.getReceivers();
        NBTTagList list = new NBTTagList();
        for (BlockPos lPos : positions) {
            int index = positions.indexOf(lPos);
            if (this.containerReceiverFlow.containsKey(index) && this.containerReceiverFlow.get(index).intValue() == this.receiverTransfer(index)) continue;
            this.containerReceiverFlow.put(index, this.receiverTransfer(index));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("I", (byte)index);
            data.func_74768_a("E", this.receiverTransfer(index));
            list.func_74742_a((NBTBase)data);
        }
        if (!list.func_82582_d()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("L", (NBTBase)list);
            this.sendUpdateToListeners(listeners, this.sendPacketToClient(output -> output.writeNBTTagCompound(compound), 1));
        } else if (this.containerReceiverFlow.size() > this.linkedReceivers.size()) {
            this.containerReceiverFlow.clear();
            this.sendUpdateToListeners(listeners, this.sendPacketToClient(output -> {}, 1));
        }
    }

    @Override
    public void receivePacketFromServer(MCDataInput data, int id) {
        super.receivePacketFromServer(data, id);
        if (id == 1) {
            NBTTagCompound compound = data.readNBTTagCompound();
            NBTTagList list = compound.func_150295_c("L", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tagData = list.func_150305_b(i);
                this.containerReceiverFlow.put(Integer.valueOf(tagData.func_74771_c("I")), tagData.func_74762_e("E"));
            }
        }
    }

    @Override
    public void receivePacketFromClient(MCDataInput data, EntityPlayerMP client, int id) {
        super.receivePacketFromClient(data, client, id);
        if (id == 11) {
            int intValue = data.readInt();
            if (this.getReceivers().size() > intValue && intValue >= 0) {
                BlockPos target = this.getReceivers().get(intValue);
                this.removeReceiver(target);
            }
        } else if (id == 21) {
            ArrayList<BlockPos> links = new ArrayList<BlockPos>(this.getReceivers());
            for (BlockPos target : links) {
                this.removeReceiver(target);
            }
        }
    }

    private class LinkedDevice {
        public final int index;
        public final BlockPos pos;
        private EnumFacing side;
        public int timeOut = 0;
        private TileEntity tileCache = null;
        private int invalidTime = 0;

        public LinkedDevice(int index, BlockPos pos, EnumFacing side) {
            this.index = index;
            this.pos = pos;
            this.side = side;
        }

        public boolean isLinkValid(World world) {
            this.tileCache = world.func_175625_s(this.pos);
            return this.tileCache != null && EnergyHelper.isEnergyTile((TileEntity)this.tileCache, (EnumFacing)this.side) || !world.func_175726_f(this.pos).func_177410_o();
        }

        public TileEntity getCachedTile() {
            return this.tileCache;
        }
    }
}

