/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import sonar.core.helpers.ListHelper;

public class SimpleObservableList<T>
extends ArrayList<T> {
    public List<IListWatcher<T>> watchers = new ArrayList<IListWatcher<T>>();

    public void addWatcher(IListWatcher<T> watcher) {
        ListHelper.addWithCheck(this.watchers, watcher);
    }

    public void removeWatcher(IListWatcher<T> watcher) {
        this.watchers.remove(watcher);
    }

    @Override
    public boolean add(T t) {
        boolean add = super.add(t);
        if (add) {
            this.watchers.forEach((? super T w) -> w.onElementAdded(t));
        }
        return add;
    }

    @Override
    public boolean remove(Object o) {
        boolean remove = super.remove(o);
        if (remove) {
            this.watchers.forEach((? super T w) -> w.onElementRemoved(o));
        }
        return remove;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean addAll = super.addAll(c);
        if (addAll) {
            this.watchers.forEach(IListWatcher::onListChanged);
        }
        return addAll;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean addAll = super.addAll(index, c);
        if (addAll) {
            this.watchers.forEach(IListWatcher::onListChanged);
        }
        return addAll;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removeAll = super.removeAll(c);
        if (removeAll) {
            this.watchers.forEach(IListWatcher::onListChanged);
        }
        return removeAll;
    }

    @Override
    public void clear() {
        this.forEach((? super E e) -> this.watchers.forEach((? super T w) -> w.onElementRemoved(e)));
        super.clear();
    }

    @Override
    public T set(int index, T element) {
        Object set = super.set(index, element);
        this.watchers.forEach((? super T w) -> w.onElementRemoved(set));
        this.watchers.forEach((? super T w) -> w.onElementAdded(element));
        return set;
    }

    @Override
    public void add(int index, T element) {
        int original_size = this.size();
        super.add(index, element);
        if (this.size() != original_size) {
            this.watchers.forEach((? super T w) -> w.onElementAdded(element));
        }
    }

    public static interface IListWatcher<T> {
        public void onElementAdded(@Nullable T var1);

        public void onElementRemoved(@Nullable T var1);

        public void onListChanged();
    }
}

