/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.tileentity;

import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import sonar.core.api.energy.EnergyMode;
import sonar.core.api.energy.ISonarEnergyTile;
import sonar.core.api.utils.ActionType;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.handlers.energy.EnergyTransferHandler;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.integration.EUHelper;
import sonar.core.integration.SonarLoader;
import sonar.core.network.sync.SyncEnergyStorage;
import sonar.core.network.sync.SyncSidedEnergyStorage;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyProvider", modid="redstoneflux"), @Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")})
public abstract class TileEntityEnergy
extends TileEntitySonar
implements IEnergyReceiver,
IEnergyProvider,
ISonarEnergyTile,
IEnergyTile,
IEnergySink,
IEnergySource {
    public EnergyMode energyMode = EnergyMode.RECIEVE;
    public final SyncSidedEnergyStorage storage = new SyncSidedEnergyStorage(this, 0);
    boolean IC2Connected = false;

    public TileEntityEnergy() {
        this.syncList.addPart(this.storage);
    }

    public void setEnergyMode(EnergyMode mode) {
        this.energyMode = mode;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.DROP) {
            this.storage.setEnergyStored(nbt.func_74762_e("energy"));
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.DROP) {
            nbt.func_74768_a("energy", this.storage.getEnergyStored());
        }
        return nbt;
    }

    public void addEnergy(EnumFacing ... faces) {
        EnergyTransferHandler.INSTANCE_SC.transferToAdjacent(this, SonarHelper.getEnumFacingValues(), this.storage.getMaxExtract());
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        EnergyMode mode = this.getModeForSide(facing);
        if (CapabilityEnergy.ENERGY == capability) {
            return true;
        }
        if (SonarLoader.teslaLoaded && mode.canConnect() && (capability == TeslaCapabilities.CAPABILITY_CONSUMER && mode.canRecieve() || capability == TeslaCapabilities.CAPABILITY_PRODUCER && mode.canSend() || capability == TeslaCapabilities.CAPABILITY_HOLDER)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        EnergyMode mode = this.getModeForSide(facing);
        if (CapabilityEnergy.ENERGY == capability) {
            return (T)this.storage.setCurrentFace(facing);
        }
        if (mode != null && SonarLoader.teslaLoaded && mode.canConnect() && (capability == TeslaCapabilities.CAPABILITY_CONSUMER && mode.canRecieve() || capability == TeslaCapabilities.CAPABILITY_PRODUCER && mode.canSend() || capability == TeslaCapabilities.CAPABILITY_HOLDER)) {
            return (T)this.storage.setCurrentFace(facing);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public EnergyMode getModeForSide(EnumFacing side) {
        if (side == null) {
            return EnergyMode.SEND_RECIEVE;
        }
        return this.energyMode;
    }

    @Override
    public SyncEnergyStorage getStorage() {
        return this.storage;
    }

    @Override
    public EnergyMode getMode() {
        return this.energyMode;
    }

    @Optional.Method(modid="redstoneflux")
    public boolean canConnectEnergy(EnumFacing from) {
        return this.getModeForSide(from).canConnect();
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (this.energyMode.canSend()) {
            return this.storage.extractEnergy(maxExtract, simulate);
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.energyMode.canRecieve()) {
            return this.storage.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    @Optional.Method(modid="ic2")
    public void onLoad() {
        super.onLoad();
        if (!this.func_145831_w().field_72995_K && !this.IC2Connected) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.IC2Connected = true;
        }
    }

    @Optional.Method(modid="ic2")
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.func_145831_w().field_72995_K && this.IC2Connected) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.IC2Connected = false;
        }
    }

    @Optional.Method(modid="ic2")
    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.func_145831_w().field_72995_K && this.IC2Connected) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.IC2Connected = false;
        }
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return Math.min(EUHelper.getVoltage(this.getSinkTier()), (double)(this.storage.addEnergy(this.storage.getMaxReceive(), ActionType.getTypeForAction(true)) / 4L));
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return this.getModeForSide(side).canRecieve();
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        int addRF = this.storage.receiveEnergy((int)amount * 4, true);
        this.storage.addEnergy(addRF, ActionType.getTypeForAction(false));
        return amount - (double)(addRF / 4);
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return this.getModeForSide(side).canSend();
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return Math.min(EUHelper.getVoltage(this.getSourceTier()), (double)(this.storage.removeEnergy(this.storage.getMaxExtract(), ActionType.getTypeForAction(true)) / 4L));
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        this.storage.removeEnergy((long)(amount * 4.0), ActionType.getTypeForAction(false));
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return 4;
    }
}

