/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.item;

import cofh.redstoneflux.api.IEnergyContainerItem;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.api.energy.ISonarEnergyItem;
import sonar.core.api.utils.ActionType;
import sonar.core.common.item.SonarItem;
import sonar.core.helpers.FontHelper;
import sonar.core.network.sync.SyncItemEnergyStorage;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux")})
public class SonarEnergyItem
extends SonarItem
implements ISonarEnergyItem,
IEnergyContainerItem {
    public SyncItemEnergyStorage storage;
    public int capacity;
    public int maxReceive;
    public int maxExtract;

    public SonarEnergyItem(int capacity, int maxReceive, int maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.storage = new SyncItemEnergyStorage(ItemStack.field_190927_a, capacity, maxReceive, maxExtract);
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag par4) {
        super.func_77624_a(stack, world, list, par4);
        if (stack != null) {
            list.add(FontHelper.translate("energy.stored") + ": " + this.getEnergyLevel(stack) + " RF");
        }
    }

    @Override
    public long addEnergy(ItemStack stack, long maxReceive, ActionType action) {
        return this.storage.setItemStack(stack).addEnergy(maxReceive, action);
    }

    @Override
    public long removeEnergy(ItemStack stack, long maxExtract, ActionType action) {
        return this.storage.setItemStack(stack).removeEnergy(maxExtract, action);
    }

    @Override
    public long getEnergyLevel(ItemStack stack) {
        return this.storage.setItemStack(stack).getEnergyLevel();
    }

    @Override
    public long getFullCapacity(ItemStack stack) {
        return this.storage.setItemStack(stack).getFullCapacity();
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return this.storage.setItemStack(container).receiveEnergy(maxReceive, simulate);
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return this.storage.setItemStack(container).extractEnergy(maxExtract, simulate);
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(ItemStack container) {
        return this.storage.setItemStack(container).getEnergyStored();
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(ItemStack container) {
        return this.storage.setItemStack(container).getMaxEnergyStored();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        this.storage = new SyncItemEnergyStorage(stack, this.capacity, this.maxReceive, this.maxExtract);
        return this.storage;
    }
}

